/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;

public class ErrorEntryToken
extends ArtifactAccessorResultWithoutGammas {
    public static final ErrorEntryToken SENTINEL = new ErrorEntryToken();
    private int summaryId;
    private String errorSeverity;
    private String errorVersion;
    private int errorCount;

    public ErrorEntryToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public ErrorEntryToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setSummaryId((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.SummaryId, (Object)-1));
        this.setErrorSeverity(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ErrorSeverity, ""));
        this.setErrorVersion(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ErrorVersion, ""));
        this.setErrorCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ErrorCount, (Object)0));
    }

    public ErrorEntryToken(Long id, String name) {
        super(id, name);
        this.setSummaryId(-1);
        this.setErrorSeverity("");
        this.setErrorVersion("");
        this.setErrorCount(0);
    }

    public ErrorEntryToken() {
    }

    public int getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(int summaryId) {
        this.summaryId = summaryId;
    }

    public String getErrorSeverity() {
        return this.errorSeverity;
    }

    public void setErrorSeverity(String errorSeverity) {
        this.errorSeverity = errorSeverity;
    }

    public String getErrorVersion() {
        return this.errorVersion;
    }

    public void setErrorVersion(String errorVersion) {
        this.errorVersion = errorVersion;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    public CreateArtifact createArtifact(String key) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(CoreAttributeTypes.SummaryId, Integer.toString(this.getSummaryId()));
        values.put(CoreAttributeTypes.ErrorSeverity, this.getErrorSeverity());
        values.put(CoreAttributeTypes.ErrorVersion, this.getErrorVersion());
        values.put(CoreAttributeTypes.ErrorCount, Integer.toString(this.getErrorCount()));
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.ErrorEntry.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.ErrorEntry.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }
}

