/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.model.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.change.ChangeType;

public class ChangeReportRowDto {
    private String names = "";
    private String itemType = "";
    private String changeType = "";
    private String isValue = "";
    private String wasValue = "";
    private ArtifactReadable artA;
    private ArtifactReadable artB;
    private ChangeType itemKindType;
    private Long itemTypeId;
    private ModificationType modType;
    private ApplicabilityToken isApplic;
    private ApplicabilityToken wasApplic;
    private TransactionId txId;

    public ChangeReportRowDto() {
    }

    public ChangeReportRowDto(ArtifactReadable artA, ArtifactReadable artB, String names, String itemType, Long itemTypeId, String changeType, String isValue, String wasValue, ChangeType itemKindType, ModificationType modType, ApplicabilityToken isApplic, ApplicabilityToken wasApplic, TransactionId txId) {
        this.artA = artA;
        this.artB = artB;
        this.names = names;
        this.itemType = itemType;
        this.changeType = changeType;
        this.isValue = isValue == null ? "" : isValue;
        this.wasValue = wasValue == null ? "" : wasValue;
        this.itemKindType = itemKindType;
        this.itemTypeId = itemTypeId;
        this.modType = modType;
        this.isApplic = isApplic;
        this.wasApplic = wasApplic;
        this.txId = txId;
    }

    public String getIds() {
        String id = this.artA.getIdString();
        if (this.artB.isValid()) {
            id = String.valueOf(id) + " - " + this.artB.getIdString();
        }
        return id;
    }

    public String getNames() {
        return this.names;
    }

    public void setNames(String names) {
        this.names = names;
    }

    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemKind() {
        return this.getItemKindType().getName().replace("Change", "");
    }

    public String getChangeType() {
        return this.changeType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public String getIsValue() {
        return this.isValue;
    }

    public void setIsValue(String isValue) {
        this.isValue = isValue;
    }

    public String getWasValue() {
        return this.wasValue;
    }

    public void setWasValue(String wasValue) {
        this.wasValue = wasValue;
    }

    @JsonIgnore
    public ArtifactReadable getArtA() {
        return this.artA;
    }

    @JsonIgnore
    public ArtifactReadable getArtB() {
        return this.artB;
    }

    @JsonIgnore
    public ChangeType getItemKindType() {
        return this.itemKindType;
    }

    public void setItemKindType(ChangeType itemKindType) {
        this.itemKindType = itemKindType;
    }

    @JsonIgnore
    public Long getItemTypeId() {
        return this.itemTypeId;
    }

    public void setItemTypeId(Long itemTypeId) {
        this.itemTypeId = itemTypeId;
    }

    @JsonIgnore
    public ModificationType getModType() {
        return this.modType;
    }

    public void setModType(ModificationType modType) {
        this.modType = modType;
    }

    @JsonIgnore
    public ArtifactTypeToken getArtType() {
        return this.artA.getArtifactType();
    }

    @JsonIgnore
    public ApplicabilityToken getIsApplic() {
        return this.isApplic;
    }

    @JsonIgnore
    public ApplicabilityToken getWasApplic() {
        return this.wasApplic;
    }

    public TransactionId getTxId() {
        return this.txId;
    }
}

