/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.osee.framework.core.server.internal.ProcessingStateEnum;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.logger.Log;

public abstract class InternalOseeHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = -4965613535312739355L;
    private boolean areLogsAllowed;
    private ProcessingStateEnum processingState;
    private HttpServletRequest request;
    private final Log logger;

    public InternalOseeHttpServlet(Log logger) {
        this.logger = logger;
        this.areLogsAllowed = false;
        this.processingState = ProcessingStateEnum.IDLE;
        this.request = null;
    }

    protected Log getLogger() {
        return this.logger;
    }

    protected boolean areLogsAllowed() {
        return this.areLogsAllowed;
    }

    void setLogsAllowed(boolean value) {
        this.areLogsAllowed = value;
    }

    ProcessingStateEnum getState() {
        return this.processingState;
    }

    String getCurrentRequest() {
        return this.request != null ? String.format("[%s] [%s - %s]", this.request.getMethod(), this.request.getContextPath(), this.request.getQueryString()) : "";
    }

    protected abstract void checkAccessControl(HttpServletRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long start = 0L;
        if (this.areLogsAllowed()) {
            start = System.currentTimeMillis();
        }
        try {
            InternalOseeHttpServlet internalOseeHttpServlet = this;
            synchronized (internalOseeHttpServlet) {
                this.processingState = ProcessingStateEnum.BUSY;
                this.request = request;
            }
            try {
                this.checkAccessControl(request);
                super.service(request, response);
            }
            catch (OseeCoreException ex) {
                response.setStatus(407);
                response.getWriter().write(Lib.exceptionToString((Exception)((Object)ex)));
                throw new ServletException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            if (this.areLogsAllowed()) {
                long elapsed = System.currentTimeMillis() - start;
                this.getLogger().info("[%s] [%s - %s] serviced in [%s] ms", new Object[]{request.getMethod(), request.getContextPath(), request.getQueryString(), elapsed});
            }
            InternalOseeHttpServlet elapsed = this;
            synchronized (elapsed) {
                this.processingState = ProcessingStateEnum.IDLE;
                this.request = null;
            }
            throw throwable;
        }
        if (this.areLogsAllowed()) {
            long elapsed = System.currentTimeMillis() - start;
            this.getLogger().info("[%s] [%s - %s] serviced in [%s] ms", new Object[]{request.getMethod(), request.getContextPath(), request.getQueryString(), elapsed});
        }
        InternalOseeHttpServlet internalOseeHttpServlet = this;
        synchronized (internalOseeHttpServlet) {
            this.processingState = ProcessingStateEnum.IDLE;
            this.request = null;
        }
    }
}

