/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.xhtml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AlignType implements Enumerator
{
    LEFT(0, "left", "left"),
    CENTER(1, "center", "center"),
    RIGHT(2, "right", "right"),
    JUSTIFY(3, "justify", "justify"),
    CHAR(4, "char", "char");

    public static final int LEFT_VALUE = 0;
    public static final int CENTER_VALUE = 1;
    public static final int RIGHT_VALUE = 2;
    public static final int JUSTIFY_VALUE = 3;
    public static final int CHAR_VALUE = 4;
    private static final AlignType[] VALUES_ARRAY;
    public static final List<AlignType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AlignType[]{LEFT, CENTER, RIGHT, JUSTIFY, CHAR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AlignType get(String literal) {
        AlignType[] alignTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            AlignType result = alignTypeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static AlignType getByName(String name) {
        AlignType[] alignTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            AlignType result = alignTypeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static AlignType get(int value) {
        switch (value) {
            case 0: {
                return LEFT;
            }
            case 1: {
                return CENTER;
            }
            case 2: {
                return RIGHT;
            }
            case 3: {
                return JUSTIFY;
            }
            case 4: {
                return CHAR;
            }
        }
        return null;
    }

    private AlignType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

