/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.resource.management.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.osee.framework.resource.management.IResource;

public class CompressedResourceBridge
implements IResource {
    private final byte[] backing;
    private final boolean isCompressed;
    private final URI uri;

    public CompressedResourceBridge(byte[] backing, URI uri, boolean isCompressed) {
        this.backing = backing;
        this.isCompressed = isCompressed;
        this.uri = uri;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.backing);
    }

    @Override
    public URI getLocation() {
        return this.uri;
    }

    @Override
    public String getName() {
        String value = this.uri.toASCIIString();
        return value.substring(value.lastIndexOf("/") + 1, value.length());
    }

    @Override
    public boolean isCompressed() {
        return this.isCompressed;
    }
}

