/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.util.AbstractImmutableMapSet;
import org.eclipse.osee.framework.jdk.core.util.MapCollection;

public interface MapSet<K, V>
extends MapCollection<K, V, Set<V>> {
    @SafeVarargs
    public static <K, V> MapSet<K, V> ofEntries(Map.Entry<K, Set<V>> ... entries) {
        if (entries == null) {
            throw new NullPointerException("MapList::ofEntries, parameter \"entries\" is null");
        }
        Map.Entry[] newEntries = new Map.Entry[entries.length];
        int i = 0;
        Map.Entry<K, Set<V>>[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<K, Set<V>> entry = entryArray[n2];
            K key = entry.getKey();
            Set<V> value = entry.getValue();
            newEntries[i++] = Map.entry(key, Set.copyOf(value));
            ++n2;
        }
        Map map = Map.ofEntries(newEntries);
        AbstractImmutableMapSet mapSet = new AbstractImmutableMapSet(map);
        return mapSet;
    }
}

