/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.AbstractImmutableMapList;
import org.eclipse.osee.framework.jdk.core.util.MapCollection;

public interface MapList<K, V>
extends MapCollection<K, V, List<V>> {
    @SafeVarargs
    public static <K, V> MapList<K, V> ofEntries(Map.Entry<K, List<V>> ... entries) {
        if (entries == null) {
            throw new NullPointerException("MapList::ofEntries, parameter \"entries\" is null");
        }
        Map.Entry[] newEntries = new Map.Entry[entries.length];
        int i = 0;
        Map.Entry<K, List<V>>[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<K, List<V>> entry = entryArray[n2];
            K key = entry.getKey();
            List<V> value = entry.getValue();
            newEntries[i++] = Map.entry(key, List.copyOf(value));
            ++n2;
        }
        Map map = Map.ofEntries(newEntries);
        AbstractImmutableMapList mapList = new AbstractImmutableMapList(map);
        return mapList;
    }
}

