/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.change;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;
import org.eclipse.osee.framework.jdk.core.text.change.CharacterChanger;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

class StringBuilderChanger
implements CharacterChanger,
ToMessage {
    private final int srcStartIndex;
    private final int srcEndIndex;
    private final int length;
    private CharacterChanger next;
    private final StringBuilder stringBuilder;

    public StringBuilderChanger(int srcStartIndex, int srcEndIndex, StringBuilder stringBuilder) {
        this.stringBuilder = Objects.requireNonNull(stringBuilder, "StringBuilderChanger::new, parameter \"stringBuilder\" cannot be null.");
        this.srcStartIndex = srcStartIndex;
        this.srcEndIndex = srcEndIndex;
        this.length = srcEndIndex - srcStartIndex;
        this.next = null;
        if (this.srcStartIndex < 0 || this.srcEndIndex < this.srcStartIndex) {
            throw new IndexOutOfBoundsException(new Message().title("StringBuilderChanger::new, change set start and/or end index out of bounds.").indentInc().segment("srcStartIndex", srcStartIndex).segment("srcEndIndex", srcEndIndex).toString());
        }
    }

    @Override
    public int getStartIndex() {
        return this.srcStartIndex;
    }

    @Override
    public int getEndIndex() {
        return this.srcEndIndex;
    }

    @Override
    public int applyChange(char[] dest, int destPos) {
        this.stringBuilder.getChars(0, this.stringBuilder.length(), dest, destPos);
        return destPos + this.stringBuilder.length();
    }

    @Override
    public void applyChange(Writer writer) throws IOException {
        writer.append(this.stringBuilder);
    }

    @Override
    public CharacterChanger next() {
        return this.next;
    }

    @Override
    public void setNext(CharacterChanger next) {
        this.next = next;
    }

    @Override
    public int getLengthDelta() {
        return this.stringBuilder.length() - this.length;
    }

    @Override
    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title("StringBuilderChanger").indentInc().segment("srcStartIndex", this.srcStartIndex).segment("srcEndIndex", this.srcEndIndex).segment("length", this.length).segment("stringBulder", this.stringBuilder).segment("stringBuilder length", this.stringBuilder.length()).segment("next", Objects.nonNull(this.next) ? "set" : "unset").indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

