/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text.change;

import java.io.Writer;
import org.eclipse.osee.framework.jdk.core.text.change.CharacterChanger;

public class DeleteChange
implements CharacterChanger {
    private int srcStartIndex;
    private int srcEndIndex;
    private CharacterChanger next;

    public DeleteChange(int srcStartIndex, int srcEndIndex) {
        this.srcStartIndex = srcStartIndex;
        this.srcEndIndex = srcEndIndex;
    }

    public void coalesce(DeleteChange overlapping) {
        DeleteChange changeA = null;
        DeleteChange changeB = null;
        if (overlapping.srcStartIndex < this.srcStartIndex) {
            changeA = overlapping;
            changeB = this;
        } else {
            changeA = this;
            changeB = overlapping;
        }
        if (changeB.srcStartIndex > changeA.srcEndIndex) {
            throw new IllegalArgumentException("Tried to coalesce non-adjacent, non-overlapping DeleteChanges");
        }
        this.srcStartIndex = changeA.srcStartIndex;
        this.srcEndIndex = changeB.srcEndIndex;
    }

    @Override
    public int getStartIndex() {
        return this.srcStartIndex;
    }

    @Override
    public int getEndIndex() {
        return this.srcEndIndex;
    }

    @Override
    public int applyChange(char[] dest, int destPos) {
        return destPos;
    }

    @Override
    public void applyChange(Writer writer) {
    }

    @Override
    public CharacterChanger next() {
        return this.next;
    }

    @Override
    public void setNext(CharacterChanger next) {
        this.next = next;
    }

    @Override
    public int getLengthDelta() {
        return this.srcStartIndex - this.srcEndIndex;
    }
}

