/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal.oauth;

import com.google.common.io.ByteSource;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.JaxRsApi;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.OAuthOseeTypes;
import org.eclipse.osee.framework.jdk.core.type.BaseIdentity;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jaxrs.server.security.OAuthClient;
import org.eclipse.osee.orcs.account.admin.internal.oauth.OAuthClientCredential;

public class ClientArtifact
extends BaseIdentity<String>
implements OAuthClient {
    private final ArtifactReadable artifact;
    private final OAuthClientCredential credential;
    private final JaxRsApi jaxRsApi;
    private ByteSource logoSupplier;

    public ClientArtifact(ArtifactReadable artifact, OAuthClientCredential credential, JaxRsApi jaxRsApi) {
        super((Object)artifact.getGuid());
        this.credential = credential;
        this.artifact = artifact;
        this.jaxRsApi = jaxRsApi;
    }

    public long getClientUuid() {
        return this.credential.getClientId();
    }

    public long getSubjectId() {
        return this.credential.getSubjectId();
    }

    public String getApplicationName() {
        return this.artifact.getName();
    }

    public String getApplicationDescription() {
        return (String)this.artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Description);
    }

    public String getApplicationWebUri() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)OAuthOseeTypes.OAuthClientWebsiteUri);
    }

    public String getApplicationLogoUri() {
        return this.artifact.getSoleAttributeAsString((AttributeTypeToken)OAuthOseeTypes.OAuthClientLogoUri);
    }

    public boolean isConfidential() {
        return (Boolean)this.artifact.getSoleAttributeValue((AttributeTypeToken)OAuthOseeTypes.OAuthClientIsConfidential);
    }

    public List<String> getAllowedGrantTypes() {
        return this.artifact.getAttributeValues((AttributeTypeToken)OAuthOseeTypes.OAuthClientAuthorizedGrantType);
    }

    public List<String> getRedirectUris() {
        return this.artifact.getAttributeValues((AttributeTypeToken)OAuthOseeTypes.OAuthClientAuthorizedRedirectUri);
    }

    public List<String> getRegisteredScopes() {
        return this.artifact.getAttributeValues((AttributeTypeToken)OAuthOseeTypes.OAuthClientAuthorizedScope);
    }

    public List<String> getRegisteredAudiences() {
        return this.artifact.getAttributeValues((AttributeTypeToken)OAuthOseeTypes.OAuthClientAuthorizedAudience);
    }

    public Map<String, String> getProperties() {
        String data = (String)this.artifact.getSoleAttributeValue((AttributeTypeToken)OAuthOseeTypes.OAuthClientProperties, null);
        if (Strings.isValid((String)data)) {
            return this.jaxRsApi.readMapValue(data, String.class, String.class);
        }
        return Collections.emptyMap();
    }

    public String getClientId() {
        return this.credential.getClientKey();
    }

    public String getClientSecret() {
        return this.credential.getClientSecret();
    }

    public List<String> getApplicationCertificates() {
        return this.credential.getClientCertificates();
    }

    public boolean hasApplicationLogoSupplier() {
        return this.artifact.getAttributeCount((AttributeTypeToken)CoreAttributeTypes.ImageContent) > 0;
    }

    public ByteSource getApplicationLogoSupplier() {
        return this.logoSupplier;
    }

    public void setApplicationLogoSupplier(ByteSource supplier) {
        this.logoSupplier = supplier;
    }

    public InputStream getInput() {
        return (InputStream)this.artifact.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ImageContent);
    }
}

