/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.util.health;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class HealthCheckResults {
    private final HashCollection<String, String> testNameToResultsMap = new HashCollection(50);
    private final HashCollection<String, String> testNameToIdMap = new HashCollection(50);
    private boolean persist = false;

    public void log(ArtifactId artifact, String testName, String message) {
        if (artifact != null) {
            this.testNameToIdMap.put((Object)testName, (Object)artifact.getIdString());
        }
        this.log(testName, message);
    }

    public void log(String testName, String message) {
        this.testNameToResultsMap.put((Object)testName, (Object)message);
    }

    public void addResultsMapToResultData(XResultData xResultData) {
        Object[] keys = this.testNameToResultsMap.keySet().toArray(new String[this.testNameToResultsMap.keySet().size()]);
        Arrays.sort(keys);
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object testName = objectArray[n2];
            xResultData.log("<b>" + (String)testName + "</b>");
            for (String result : (List)this.testNameToResultsMap.getValues(testName)) {
                xResultData.log("   - " + result);
            }
            HashSet idStrs = new HashSet();
            Collection values = this.testNameToIdMap.getValues(testName);
            if (values != null) {
                idStrs.addAll(values);
            }
            xResultData.logf("<b>" + (String)testName + "</b> Ids: " + Collections.toString((String)",", idStrs) + "\n\n", new Object[0]);
            ++n2;
        }
    }

    public boolean isPersist() {
        return this.persist;
    }

    public void setPersist(boolean persist) {
        this.persist = persist;
    }
}

