/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.notify;

import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.notify.AtsNotificationEvent;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.notify.AtsWorkItemNotificationEvent;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsNotificationEventFactory {
    public static AtsNotificationEvent getNotificationEvent(AtsUser fromUser, Collection<AtsUser> users, String id, String type, String description) {
        AtsNotificationEvent event = new AtsNotificationEvent();
        event.setType(type);
        event.setId(id);
        event.setDescription(description);
        event.setFromUserId(fromUser.getUserId());
        for (AtsUser user : users) {
            event.getUserIds().add(user.getUserId());
        }
        return event;
    }

    public static AtsNotificationEvent getNotificationEvent(AtsUser fromUser, Collection<AtsUser> users, String id, String type, String url, String cancelUrl, String description) {
        AtsNotificationEvent event = AtsNotificationEventFactory.getNotificationEvent(fromUser, users, id, type, description);
        event.setUrl(url);
        return event;
    }

    public static AtsNotificationEvent getNotificationEventByUserIds(AtsUser fromUser, Collection<String> userIds, String id, String type, String description) {
        AtsNotificationEvent event = new AtsNotificationEvent();
        event.setType(type);
        event.setId(id);
        event.setDescription(description);
        event.getUserIds().addAll(userIds);
        event.setFromUserId(fromUser.getUserId());
        return event;
    }

    public static AtsNotificationEvent getNotificationEventByUserIds(AtsUser fromUser, Collection<String> userIds, String id, String type, String description, String url) {
        AtsNotificationEvent event = AtsNotificationEventFactory.getNotificationEventByUserIds(fromUser, userIds, id, type, description);
        event.setUrl(url);
        return event;
    }

    public static AtsWorkItemNotificationEvent getWorkItemNotificationEvent(AtsUser fromUser, IAtsWorkItem workItem, List<AtsUser> users, AtsNotifyType ... notifyType) {
        AtsWorkItemNotificationEvent event = AtsNotificationEventFactory.getWorkItemNotificationEvent(fromUser, workItem, notifyType);
        for (AtsUser user : users) {
            event.getUserIds().add(user.getUserId());
        }
        return event;
    }

    public static AtsWorkItemNotificationEvent getWorkItemNotificationEvent(AtsUser fromUser, IAtsWorkItem workItem, AtsNotifyType ... notifyType) {
        AtsWorkItemNotificationEvent event = new AtsWorkItemNotificationEvent();
        event.setFromUserId(fromUser.getUserId());
        if (!Strings.isValid((String)workItem.getAtsId())) {
            throw new OseeArgumentException("ATS Id cannot be null for %s", new Object[]{workItem.toStringWithId()});
        }
        event.getAtsIds().add(workItem.getAtsId());
        event.getIds().add(workItem.getId());
        event.setNotifyType(notifyType);
        return event;
    }
}

