/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.api.utils;

import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.AttachmentBuilder;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactSpecification;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.publishing.DataAccessOperations;
import org.eclipse.osee.framework.core.publishing.FilenameFactory;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AttachmentFactory {
    private static final String ATTACHMENT_TEMPLATE = "attachment; filename=";
    private static final String BRANCH_HEADER = "OSEE-Branch";
    private static final int BUFFER_SIZE = 1024;
    private static final String FINAL_DEFAULT_NAME = "UNNAMED";
    private static final String FINAL_DEFAULT_SUFFIX = "";
    private String defaultName;
    private final DataAccessOperations dataAccessOperations;
    private String suffix;

    private static String cleanName(String name) {
        return name.replaceAll("[^a-zA-Z0-9_+-]", "-");
    }

    public AttachmentFactory() {
        this.dataAccessOperations = null;
        this.setDefaultName(null);
        this.setSuffix(null);
    }

    public AttachmentFactory(String defaultName, String suffix) {
        this.dataAccessOperations = null;
        this.setDefaultName(defaultName);
        this.setSuffix(suffix);
    }

    public AttachmentFactory(String defaultName, String suffix, DataAccessOperations dataAccessOperations) {
        this.dataAccessOperations = Objects.requireNonNull(dataAccessOperations, "AttachmentFactory::new, The parameter \"dataAccessOperations\" cannot be null.");
        this.setDefaultName(defaultName);
        this.setSuffix(suffix);
    }

    public Attachment create(InputStream inputStream, CharSequence id, BranchToken branchToken, ArtifactToken artifactToken, CharSequence ... segments) {
        String branchName = Objects.nonNull(branchToken) ? branchToken.getName() : null;
        String artifactName = Objects.nonNull(artifactToken) ? artifactToken.getName() : null;
        Attachment attachment = this.create(inputStream, id, branchName, artifactName, segments);
        return attachment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment create(InputStream inputStream, CharSequence id, BranchId branchId, ArtifactId artifactId, CharSequence ... segments) {
        String artifactName;
        String branchName;
        if (Objects.isNull(this.dataAccessOperations) && (Objects.nonNull(artifactId) && artifactId.isValid() || Objects.nonNull(branchId) && branchId.isValid())) {
            throw new UnsupportedOperationException(new Message().title((CharSequence)"AttachementFactory:create, Attempt to create and \"Attachment\" using a \"branchId\" and/or an \"artifactId\" when the factory was not created with the \"OrcsApi\" service.").indentInc().segment((CharSequence)"Branch Identifier", (Object)branchId).segment((CharSequence)"Artifact Identifier", (Object)artifactId).segment((CharSequence)"Attachement Identifier", (Object)id).toString());
        }
        DataAccessOperations dataAccessOperations = this.dataAccessOperations;
        synchronized (dataAccessOperations) {
            branchName = Objects.nonNull(branchId) && branchId.isValid() ? (String)this.dataAccessOperations.getBranchByIdentifier(branchId).mapValue(BranchToken::getShortName).orElseGet(null) : null;
            artifactName = Objects.nonNull(artifactId) && artifactId.isValid() ? (String)this.dataAccessOperations.getArtifactReadableByIdentifier(new ArtifactSpecification(branchId, branchId.getViewId(), artifactId)).mapValue(Named::getName).orElseGet((Object)this.defaultName) : this.defaultName;
        }
        Attachment attachment = this.create(inputStream, id, branchName, artifactName, segments);
        return attachment;
    }

    public Attachment create(InputStream inputStream, CharSequence id, CharSequence branchName, CharSequence filename, CharSequence ... segments) {
        CharSequence[] charSequenceArray;
        AttachmentBuilder attachmentBuilder = new AttachmentBuilder();
        if (Strings.isValid((CharSequence[])new CharSequence[]{id})) {
            attachmentBuilder.id(id.toString());
        }
        if (Objects.nonNull(inputStream)) {
            DataHandler dataHandler = new DataHandler((DataSource)new InputStreamDataSource(inputStream, "application/octet-stream"));
            attachmentBuilder.dataHandler(dataHandler);
        }
        if (Strings.isValid((CharSequence[])new CharSequence[]{filename}) && Objects.nonNull(segments)) {
            charSequenceArray = this.newSegments(filename, segments);
        } else if (Strings.isValid((CharSequence[])new CharSequence[]{filename})) {
            CharSequence[] charSequenceArray2 = new CharSequence[1];
            charSequenceArray = charSequenceArray2;
            charSequenceArray2[0] = filename;
        } else {
            charSequenceArray = segments;
        }
        CharSequence[] newSegments = charSequenceArray;
        this.getContentDisposition(newSegments).ifPresent(arg_0 -> ((AttachmentBuilder)attachmentBuilder).contentDisposition(arg_0));
        this.getBranchHeaderValue(branchName).ifPresent(branchHeaderValue -> {
            AttachmentBuilder attachmentBuilder2 = attachmentBuilder.header(BRANCH_HEADER, branchHeaderValue);
        });
        Attachment attachment = attachmentBuilder.build();
        return attachment;
    }

    private Optional<String> getBranchHeaderValue(CharSequence branchName) {
        return Strings.isValid((CharSequence[])new CharSequence[]{branchName}) ? Optional.ofNullable(FilenameFactory.makeNameSafer((CharSequence)branchName)) : Optional.empty();
    }

    private Optional<ContentDisposition> getContentDisposition(CharSequence ... segments) {
        String cleanFileName = FilenameFactory.create((CharSequence)this.suffix, (CharSequence[])segments);
        if (Objects.isNull(cleanFileName)) {
            return Optional.empty();
        }
        String fileAttachmentString = new StringBuilder(1024).append(ATTACHMENT_TEMPLATE).append(cleanFileName).toString();
        ContentDisposition contentDisposition = new ContentDisposition(fileAttachmentString);
        return Optional.of(contentDisposition);
    }

    private CharSequence[] newSegments(CharSequence first, CharSequence ... rest) {
        CharSequence[] newSegments = new CharSequence[rest.length + 1];
        newSegments[0] = first;
        System.arraycopy(rest, 0, newSegments, 1, rest.length);
        return newSegments;
    }

    private void setDefaultName(String defaultName) {
        this.defaultName = Objects.nonNull(defaultName) && !defaultName.isBlank() ? AttachmentFactory.cleanName(defaultName) : FINAL_DEFAULT_NAME;
    }

    private void setSuffix(String suffix) {
        this.suffix = Objects.nonNull(suffix) && !suffix.isBlank() ? AttachmentFactory.cleanName(suffix) : FINAL_DEFAULT_SUFFIX;
    }
}

