/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.json.basic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonObject;

public class JsonMapObjectReaderWriter {
    private static final Set<Character> ESCAPED_CHARS;
    private static final char DQUOTE = '\"';
    private static final char COMMA = ',';
    private static final char COLON = ':';
    private static final char OBJECT_START = '{';
    private static final char OBJECT_END = '}';
    private static final char ARRAY_START = '[';
    private static final char ARRAY_END = ']';
    private static final char ESCAPE = '\\';
    private static final String NULL_VALUE = "null";
    private boolean format;

    public JsonMapObjectReaderWriter() {
    }

    public JsonMapObjectReaderWriter(boolean format) {
        this.format = format;
    }

    public String toJson(JsonMapObject obj) {
        return this.toJson(obj.asMap());
    }

    public String toJson(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        this.toJsonInternal((Output)new StringBuilderOutput(sb), map);
        return sb.toString();
    }

    public String toJson(List<Object> list) {
        StringBuilder sb = new StringBuilder();
        this.toJsonInternal((Output)new StringBuilderOutput(sb), list);
        return sb.toString();
    }

    public void toJson(JsonMapObject obj, OutputStream os) {
        this.toJson(obj.asMap(), os);
    }

    public void toJson(Map<String, Object> map, OutputStream os) {
        this.toJsonInternal((Output)new StreamOutput(os), map);
    }

    protected void toJsonInternal(Output out, Map<String, Object> map) {
        out.append('{');
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            out.append('\"').append(this.escapeJson(entry.getKey())).append('\"');
            out.append(':');
            this.toJsonInternal(out, entry.getValue(), it.hasNext());
        }
        out.append('}');
    }

    protected void toJsonInternal(Output out, Object[] array) {
        this.toJsonInternal(out, Arrays.asList(array));
    }

    protected void toJsonInternal(Output out, Collection<?> coll) {
        out.append('[');
        this.formatIfNeeded(out);
        Iterator<?> iter = coll.iterator();
        while (iter.hasNext()) {
            this.toJsonInternal(out, iter.next(), iter.hasNext());
        }
        this.formatIfNeeded(out);
        out.append(']');
    }

    protected void toJsonInternal(Output out, Object value, boolean hasNext) {
        if (value == null) {
            out.append(null);
        } else if (JsonMapObject.class.isAssignableFrom(value.getClass())) {
            out.append(this.toJson((JsonMapObject)value));
        } else if (value.getClass().isArray()) {
            this.toJsonInternal(out, (Object[])value);
        } else if (Collection.class.isAssignableFrom(value.getClass())) {
            this.toJsonInternal(out, (Collection)value);
        } else if (Map.class.isAssignableFrom(value.getClass())) {
            this.toJsonInternal(out, (Map)value);
        } else {
            boolean quotesNeeded = this.checkQuotesNeeded(value);
            if (quotesNeeded) {
                out.append('\"');
            }
            String valueStr = value.toString();
            if (value instanceof String) {
                valueStr = this.escapeJson(valueStr);
            }
            out.append(valueStr);
            if (quotesNeeded) {
                out.append('\"');
            }
        }
        if (hasNext) {
            out.append(',');
            this.formatIfNeeded(out);
        }
    }

    private boolean checkQuotesNeeded(Object value) {
        Class<?> cls = value.getClass();
        return !Number.class.isAssignableFrom(cls) && Boolean.class != cls && !JsonObject.class.isAssignableFrom(cls);
    }

    protected void formatIfNeeded(Output out) {
        if (this.format) {
            out.append("\r\n ");
        }
    }

    public JsonMapObject fromJsonToJsonObject(InputStream is) throws IOException {
        return this.fromJsonToJsonObject(IOUtils.toString((InputStream)is));
    }

    public JsonMapObject fromJsonToJsonObject(String json) {
        JsonMapObject obj = new JsonMapObject();
        this.fromJson(obj, json);
        return obj;
    }

    public void fromJson(JsonMapObject obj, String json) {
        String theJson = json.trim();
        JsonObjectSettable settable = new JsonObjectSettable(obj);
        this.readJsonObjectAsSettable(settable, theJson.substring(1, theJson.length() - 1));
    }

    public Map<String, Object> fromJson(InputStream is) throws IOException {
        return this.fromJson(IOUtils.toString((InputStream)is));
    }

    public Map<String, Object> fromJson(String json) {
        String theJson = json.trim();
        MapSettable nextMap = new MapSettable();
        this.readJsonObjectAsSettable(nextMap, theJson.substring(1, theJson.length() - 1));
        return nextMap.map;
    }

    public List<Object> fromJsonAsList(String json) {
        return this.fromJsonAsList(null, json);
    }

    public List<Object> fromJsonAsList(String name, String json) {
        String theJson = json.trim();
        return this.internalFromJsonAsList(name, theJson.substring(1, theJson.length() - 1));
    }

    protected void readJsonObjectAsSettable(Settable values, String json) {
        for (int i = 0; i < json.length(); ++i) {
            String newJson;
            int closingIndex;
            if (Character.isWhitespace(json.charAt(i))) continue;
            int closingQuote = json.indexOf(34, i + 1);
            int from = json.charAt(i) == '\"' ? i + 1 : i;
            String name = json.substring(from, closingQuote);
            int sepIndex = json.indexOf(58, closingQuote + 1);
            if (sepIndex == -1) {
                throw new UncheckedIOException(new IOException("Error in parsing json"));
            }
            int j = 1;
            while (Character.isWhitespace(json.charAt(sepIndex + j))) {
                ++j;
            }
            if (json.charAt(sepIndex + j) == '{') {
                closingIndex = JsonMapObjectReaderWriter.getClosingIndex(json, '{', '}', sepIndex + j);
                newJson = json.substring(sepIndex + j + 1, closingIndex);
                MapSettable nextMap = new MapSettable();
                this.readJsonObjectAsSettable(nextMap, newJson);
                values.put(name, nextMap.map);
                i = closingIndex + 1;
                continue;
            }
            if (json.charAt(sepIndex + j) == '[') {
                closingIndex = JsonMapObjectReaderWriter.getClosingIndex(json, '[', ']', sepIndex + j);
                newJson = json.substring(sepIndex + j + 1, closingIndex);
                values.put(name, this.internalFromJsonAsList(name, newJson));
                i = closingIndex + 1;
                continue;
            }
            int commaIndex = JsonMapObjectReaderWriter.getCommaIndex(json, sepIndex + j);
            Object value = this.readPrimitiveValue(name, json, sepIndex + j, commaIndex);
            values.put(name, value);
            i = commaIndex + 1;
        }
    }

    protected List<Object> internalFromJsonAsList(String name, String json) {
        LinkedList<Object> values = new LinkedList<Object>();
        for (int i = 0; i < json.length(); ++i) {
            if (Character.isWhitespace(json.charAt(i))) continue;
            if (json.charAt(i) == '{') {
                int closingIndex = JsonMapObjectReaderWriter.getClosingIndex(json, '{', '}', i);
                MapSettable nextMap = new MapSettable();
                this.readJsonObjectAsSettable(nextMap, json.substring(i + 1, closingIndex));
                values.add(nextMap.map);
                i = closingIndex + 1;
                continue;
            }
            int commaIndex = JsonMapObjectReaderWriter.getCommaIndex(json, i);
            Object value = this.readPrimitiveValue(name, json, i, commaIndex);
            values.add(value);
            i = commaIndex;
        }
        return values;
    }

    protected Object readPrimitiveValue(String name, String json, int from, int to) {
        Object value = json.substring(from, to);
        String valueStr = value.toString().trim();
        if (valueStr.charAt(0) == '\"') {
            value = valueStr.substring(1, valueStr.length() - 1);
        } else if ("true".equals(valueStr) || "false".equals(valueStr)) {
            value = Boolean.valueOf(valueStr);
        } else {
            if (NULL_VALUE.equals(valueStr)) {
                return null;
            }
            try {
                value = Long.valueOf(valueStr);
            }
            catch (NumberFormatException ex) {
                value = Double.valueOf(valueStr);
            }
        }
        if (value instanceof String) {
            if (((String)value).contains("\\/")) {
                value = ((String)value).replace("\\/", "/");
            }
            if (((String)value).contains("\\\"")) {
                value = ((String)value).replace("\\\"", "\"");
            }
            if (((String)value).contains("\\\\")) {
                value = ((String)value).replace("\\\\", "\\");
            }
        }
        return value;
    }

    protected static int getCommaIndex(String json, int from) {
        int commaIndex = JsonMapObjectReaderWriter.getNextSepCharIndex(json, ',', from);
        if (commaIndex == -1) {
            commaIndex = json.length();
        }
        return commaIndex;
    }

    protected static int getClosingIndex(String json, char openChar, char closeChar, int from) {
        int nextOpenIndex = JsonMapObjectReaderWriter.getNextSepCharIndex(json, openChar, from + 1);
        int closingIndex = JsonMapObjectReaderWriter.getNextSepCharIndex(json, closeChar, from + 1);
        while (nextOpenIndex != -1 && nextOpenIndex < closingIndex) {
            nextOpenIndex = JsonMapObjectReaderWriter.getNextSepCharIndex(json, openChar, nextOpenIndex + 1);
            closingIndex = JsonMapObjectReaderWriter.getNextSepCharIndex(json, closeChar, closingIndex + 1);
        }
        return closingIndex;
    }

    protected static int getNextSepCharIndex(String json, char curlyBracketChar, int from) {
        int nextCurlyBracketIndex = -1;
        boolean inString = false;
        for (int i = from; i < json.length(); ++i) {
            char currentChar = json.charAt(i);
            if (currentChar == curlyBracketChar && !inString) {
                nextCurlyBracketIndex = i;
                break;
            }
            if (currentChar != '\"' || i > from && json.charAt(i - 1) == '\\') continue;
            inString = !inString;
        }
        return nextCurlyBracketIndex;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    private String escapeJson(String value) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"' && (i == 0 || value.charAt(i - 1) != '\\')) {
                sb.append('\\').append(c);
                continue;
            }
            if (!(c != '\\' || i != 0 && value.charAt(i - 1) == '\\' || i != value.length() - 1 && this.isEscapedChar(value.charAt(i + 1)))) {
                sb.append('\\').append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean isEscapedChar(char c) {
        return ESCAPED_CHARS.contains(Character.valueOf(c));
    }

    static {
        HashSet<Character> chars = new HashSet<Character>();
        chars.add(Character.valueOf('\"'));
        chars.add(Character.valueOf('\\'));
        chars.add(Character.valueOf('/'));
        chars.add(Character.valueOf('b'));
        chars.add(Character.valueOf('f'));
        chars.add(Character.valueOf('h'));
        chars.add(Character.valueOf('r'));
        chars.add(Character.valueOf('t'));
        ESCAPED_CHARS = Collections.unmodifiableSet(chars);
    }

    private class StreamOutput
    implements Output {
        private OutputStream os;

        StreamOutput(OutputStream os) {
            this.os = os;
        }

        @Override
        public Output append(String str) {
            try {
                this.os.write(StringUtils.toBytesUTF8((String)(str != null ? str : JsonMapObjectReaderWriter.NULL_VALUE)));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            return this;
        }

        @Override
        public Output append(char ch) {
            try {
                this.os.write(ch);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            return this;
        }
    }

    private class StringBuilderOutput
    implements Output {
        private StringBuilder sb;

        StringBuilderOutput(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public Output append(String str) {
            this.sb.append(str);
            return this;
        }

        @Override
        public Output append(char ch) {
            this.sb.append(ch);
            return this;
        }
    }

    private static interface Output {
        public Output append(String var1);

        public Output append(char var1);
    }

    private static class JsonObjectSettable
    implements Settable {
        private JsonMapObject obj;

        JsonObjectSettable(JsonMapObject obj) {
            this.obj = obj;
        }

        @Override
        public void put(String key, Object value) {
            this.obj.setProperty(key, value);
        }
    }

    private static final class MapSettable
    implements Settable {
        private Map<String, Object> map = new LinkedHashMap<String, Object>();

        private MapSettable() {
        }

        @Override
        public void put(String key, Object value) {
            this.map.put(key, value);
        }
    }

    private static interface Settable {
        public void put(String var1, Object var2);
    }
}

