/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model.transaction;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.resource.management.IResourceManager;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.rest.model.transaction.BranchLocation;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderDataFactory;
import org.eclipse.osee.orcs.rest.model.transaction.TransferBranch;
import org.eclipse.osee.orcs.rest.model.transaction.TransferDBType;
import org.eclipse.osee.orcs.rest.model.transaction.TransferOpType;
import org.eclipse.osee.orcs.rest.model.transaction.TransferTransaction;
import org.eclipse.osee.orcs.rest.model.transaction.TransferTupleTypes;
import org.eclipse.osee.orcs.search.TupleQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class TransactionTransferManifest {
    private TransactionId exportId = null;
    private TransactionId buildId = null;
    private List<TransferBranch> transferBranchList;
    public String path;
    private final XResultData results = new XResultData();
    private final int PURGE_TXS_LIMIT = 100;

    public List<TransferBranch> getTransferBranches() {
        if (this.transferBranchList == null) {
            this.transferBranchList = new ArrayList<TransferBranch>();
        }
        return this.transferBranchList;
    }

    public void addTransferBranch(TransferBranch tb) {
        if (this.transferBranchList == null) {
            this.transferBranchList = new ArrayList<TransferBranch>();
        }
        this.transferBranchList.add(tb);
    }

    public TransferBranch getTransferBranch(BranchId branchId) {
        for (TransferBranch tb : this.transferBranchList) {
            if (!tb.getBranchId().equals(branchId)) continue;
            return tb;
        }
        return null;
    }

    public XResultData parse(String dirName) {
        this.transferBranchList = new ArrayList<TransferBranch>();
        this.path = dirName;
        File manifestFile = new File(String.format("%s%s%s", this.path, File.separator, "manifest.md"));
        try {
            String manifest = Lib.fileToString((File)manifestFile);
            String[] mdLines = manifest.split("\n");
            if (!mdLines[0].toLowerCase().contains("buildid")) {
                this.results.errorf("BuildId not found in: %s ", new Object[]{mdLines[0]});
                return this.results;
            }
            this.buildId = TransactionId.valueOf((String)mdLines[0].split(":")[1].trim());
            if (!mdLines[1].toLowerCase().contains("exportid")) {
                this.results.errorf("ExportId not found in: %s ", new Object[]{mdLines[1]});
                return this.results;
            }
            this.exportId = TransactionId.valueOf((String)mdLines[1].split(":")[1].trim());
            boolean done = false;
            int i = 4;
            TransferBranch transBranch = null;
            while (!done) {
                if (mdLines[i].toLowerCase().contains("prev")) {
                    if (transBranch != null) {
                        this.transferBranchList.add(transBranch);
                    }
                    transBranch = this.createTransferBranchFromRow(mdLines[i]);
                } else if (mdLines[i].toLowerCase().contains("cur")) {
                    this.results.errorf("not accepting this type %s", new Object[]{mdLines[i]});
                } else if (mdLines[i].toLowerCase().contains("add")) {
                    this.addRowToTransferBranch(transBranch, mdLines[i], TransferOpType.ADD);
                } else if (mdLines[i].toLowerCase().contains("empty")) {
                    this.addRowToTransferBranch(transBranch, mdLines[i], TransferOpType.EMPTY);
                } else if (mdLines[i].length() < 3) {
                    done = true;
                    this.transferBranchList.add(transBranch);
                } else {
                    this.results.errorf("unhandled type in row : %s ", new Object[]{mdLines[i]});
                    return this.results;
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.results.errorf("%s", new Object[]{String.format("IO Exception while verifying manifest and transaction files. %s ", e.getMessage())});
        }
        return this.results;
    }

    private TransferBranch createTransferBranchFromRow(String row) {
        String[] mdCols = row.split("\\|");
        TransferBranch transBranch = new TransferBranch(BranchId.valueOf((String)mdCols[1].trim()));
        transBranch.setUniqueTx(TransactionId.valueOf((String)mdCols[3].trim()));
        transBranch.setPrevTx(TransactionId.valueOf((String)mdCols[2].trim()));
        TransferTransaction trans = new TransferTransaction(transBranch.getBranchId(), transBranch.getPrevTx(), TransactionId.valueOf((String)mdCols[3].trim()), TransferOpType.PREV_TX);
        transBranch.addTransferTransaction(trans);
        return transBranch;
    }

    private void addRowToTransferBranch(TransferBranch transBranch, String row, TransferOpType type) {
        String[] mdCols = row.split("\\|");
        TransactionId sourceTx = TransactionId.valueOf((String)mdCols[2].trim());
        TransactionId uniqueTx = TransactionId.valueOf((String)mdCols[3].trim());
        TransferTransaction trans = new TransferTransaction(transBranch.getBranchId(), sourceTx, uniqueTx, type);
        transBranch.addTransferTransaction(trans);
    }

    public XResultData validate(TupleQuery tupleQuery) {
        ArrayList dirs = Lib.readListFromDir((String)this.path, null);
        try {
            if (!this.isExportIdValid(tupleQuery, this.exportId)) {
                this.results.error("The export ID is not valid. This id is not matched or there is more than one in db. ");
                return this.results;
            }
            for (TransferBranch tb : this.transferBranchList) {
                BranchId branchId = tb.getBranchId();
                int index = -1;
                int j = 0;
                while (j < dirs.size()) {
                    if (branchId.toString().equals(dirs.get(j))) {
                        index = j;
                        break;
                    }
                    ++j;
                }
                if (index == -1) {
                    this.results.error(String.format("Missing %s directory. ", branchId.toString()));
                    return this.results;
                }
                ArrayList tempfiles = Lib.readListFromDir((String)String.format("%s%s%s", this.path, File.separator, dirs.get(index)), null);
                for (TransferTransaction transTx : tb.getTxList()) {
                    String fileString;
                    if (!transTx.getTransferOp().equals((Object)TransferOpType.ADD) || tempfiles.contains(fileString = transTx.getSourceTransId().toString())) continue;
                    this.results.errorf("Missing %s.json under %s ", new Object[]{fileString, tb.getBranchId().toString()});
                    return this.results;
                }
                BranchLocation branchLoc = this.getMaxTransactionIdFromBranchLocations(tupleQuery, branchId);
                if (branchLoc.getUniqueTxId().equals(tb.getUniqueTx())) continue;
                this.results.errorf("PrevTX of branch %s is not matched. ", new Object[]{tb.getBranchId().toString()});
                return this.results;
            }
        }
        catch (Exception e) {
            this.results.errorf("%s", new Object[]{String.format("IO Exception while verifying manifest and transaction files. %s ", e.getMessage())});
        }
        return this.results;
    }

    public ArrayList<String> getAllImportedTransIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (TransferBranch tb : this.transferBranchList) {
            for (TransferTransaction transTx : tb.getTxList()) {
                TransactionId tx = transTx.getImportedTransId();
                if (tx == null || !tx.isValid()) continue;
                ids.add(tx.getIdString());
            }
        }
        return ids;
    }

    public XResultData purgeAllImportedTransaction(OrcsApi orcsApi) {
        ArrayList<String> transIdList = this.getAllImportedTransIds();
        StringBuilder transIds = new StringBuilder("");
        try {
            int i = 0;
            while (i < transIdList.size()) {
                if (i % 100 == 0 && transIds.length() != 0) {
                    orcsApi.getTransactionFactory().purgeTxs(transIds.toString());
                    this.results.log(String.format("Purged succesfully the transaction ids: %s. ", transIds.toString()));
                    transIds = new StringBuilder("");
                }
                if (transIds.length() == 0) {
                    transIds.append(transIdList.get(i));
                } else {
                    transIds.append(",").append(transIdList.get(i));
                }
                ++i;
            }
            if (transIds.length() != 0) {
                orcsApi.getTransactionFactory().purgeTxs(transIds.toString());
                this.results.log(String.format("Purged succesfully the transaction ids: %s. ", transIds.toString()));
            }
        }
        catch (Exception e) {
            this.results.errorf("%s", new Object[]{String.format("Roll back failed while purging transaction ids %s. ", e.getMessage())});
        }
        return this.results;
    }

    public XResultData importAllTransactions(OrcsApi orcsApi, IResourceManager resourceManager) {
        try {
            for (TransferBranch tb : this.transferBranchList) {
                BranchId branchId = tb.getBranchId();
                String current = "";
                try {
                    for (TransferTransaction transTx : tb.getTxList()) {
                        File transFile;
                        TransferOpType op = transTx.getTransferOp();
                        if (!TransferOpType.ADD.equals((Object)op) || !(transFile = new File(String.format("%s%s%s%s%s.json", this.path, File.separator, branchId.toString(), File.separator, transTx.getSourceTransId().toString()))).exists()) continue;
                        current = transFile.getName();
                        TransactionBuilderDataFactory txBdf = new TransactionBuilderDataFactory(orcsApi, resourceManager);
                        String transStr = Lib.fileToString((File)transFile);
                        TransactionBuilder trans = txBdf.loadFromJson(transStr);
                        TransactionToken token = trans.commit();
                        if (token.isInvalid()) {
                            this.results.errorf("Transaction token at %s - %s is invalid. ", new Object[]{branchId.toString(), current});
                            break;
                        }
                        transTx.setImportedTransId((TransactionId)token);
                    }
                }
                catch (Exception e) {
                    this.results.errorf("Failed at %s - %s: %s. ", new Object[]{branchId.toString(), current, e.getMessage()});
                }
                if (!this.results.isFailed()) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.results.error(e.getMessage());
        }
        return this.results;
    }

    private final BranchLocation getMaxTransactionIdFromBranchLocations(TupleQuery tupleQuery, BranchId branchid) {
        BranchLocation bl2;
        Pair pair = new Pair(null, null);
        ArrayList fileBranchLocs = new ArrayList();
        tupleQuery.getTuple4E2E3E4FromE1(TransferTupleTypes.TransferFile, (BranchId)CoreBranches.COMMON, (Object)branchid, (E2, E3, E4) -> {
            BranchLocation bl = new BranchLocation();
            bl.setBranchId(branchid);
            bl.setTransferOp((TransferOpType)((Object)E2));
            bl.setBaseTxId((TransactionId)E3);
            bl.setUniqueTxId((TransactionId)E4);
            fileBranchLocs.add(bl);
        });
        for (BranchLocation bl2 : fileBranchLocs) {
            if (pair.getFirst() == null) {
                if (bl2.getTransferOp().equals((Object)TransferOpType.PREV_TX)) {
                    pair = new Pair((Object)bl2.getBaseTxId(), (Object)bl2.getBaseTxId());
                    continue;
                }
                pair = new Pair((Object)bl2.getBaseTxId(), (Object)bl2.getUniqueTxId());
                continue;
            }
            TransactionId test = (TransactionId)pair.getFirst();
            if (!test.isLessThan((Id)bl2.getBaseTxId()) || bl2.getTransferOp().equals((Object)TransferOpType.PREV_TX)) continue;
            pair = new Pair((Object)bl2.getBaseTxId(), (Object)bl2.getUniqueTxId());
        }
        bl2 = new BranchLocation();
        bl2.setBranchId(branchid);
        bl2.setBaseTxId((TransactionId)pair.getFirst());
        bl2.setUniqueTxId((TransactionId)pair.getSecond());
        return bl2;
    }

    private boolean isExportIdValid(TupleQuery tupleQuery, TransactionId exportId) {
        ArrayList exportIdList = new ArrayList();
        int intDbType = TransferDBType.DESTINATION.ordinal();
        tupleQuery.getTuple4E1FromTupleType(TransferTupleTypes.ExportedBranch, TransferTupleTypes.LongExportedDBType, Long.valueOf(intDbType), exportIdList::add);
        for (TransactionId id : exportIdList) {
            if (id.equals(exportId)) continue;
            return false;
        }
        return exportIdList.size() == 1;
    }

    public XResultData addAllImportedTransToTupleTable(OrcsApi orcsApi) {
        try {
            TransactionBuilder txTransTuple = orcsApi.getTransactionFactory().createTransaction((BranchId)CoreBranches.COMMON, "Add imported transaction tuples.");
            for (TransferBranch tb : this.transferBranchList) {
                for (TransferTransaction txTrans : tb.getTxList()) {
                    if (!TransferOpType.ADD.equals((Object)txTrans.getTransferOp())) continue;
                    txTransTuple.addTuple4(TransferTupleTypes.TransferFile, (Object)tb.getBranchId(), (Object)txTrans.getTransferOp(), (Object)txTrans.getImportedTransId(), (Object)txTrans.getSourceUniqueTrans());
                }
            }
            txTransTuple.commit();
        }
        catch (Exception e) {
            this.results.error(String.format("Error while Adding transaction tuples to database %s ", e.getMessage()));
        }
        return this.results;
    }

    public void getTransactionMapping(HashMap<TransactionId, TransactionId> regenMap) {
        for (TransferBranch tb : this.transferBranchList) {
            for (TransferTransaction txTrans : tb.getTxList()) {
                regenMap.put(txTrans.getSourceTransId(), txTrans.getSourceUniqueTrans());
            }
        }
    }

    public TransactionId getExportID() {
        return this.exportId;
    }

    public void setExportID(TransactionId exportId) {
        this.exportId = exportId;
    }

    public TransactionId getBuildID() {
        return this.buildId;
    }

    public void setBuildID(TransactionId buildId) {
        this.buildId = buildId;
    }
}

