/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionResult;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.orcs.rest.model.Transaction;
import org.eclipse.osee.orcs.rest.model.transaction.TransactionBuilderData;
import org.eclipse.osee.orcs.rest.model.transaction.TransferInitData;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

@Path(value="txs")
@Swagger
public interface TransactionEndpoint {
    @GET
    @Produces(value={"application/json"})
    public List<Transaction> getAllTxs();

    @GET
    @Path(value="{tx-id}")
    @Produces(value={"application/json"})
    public Transaction getTx(@PathParam(value="tx-id") TransactionId var1);

    @GET
    @Path(value="{tx-id1}/diff/{tx-id2}")
    @Produces(value={"application/json"})
    public List<ChangeItem> compareTxs(@PathParam(value="tx-id1") TransactionId var1, @PathParam(value="tx-id2") TransactionId var2);

    @GET
    @Path(value="export/from/{tx-id1}/to/{tx-id2}")
    @Produces(value={"application/json"})
    public TransactionBuilderData exportTxsDiff(@PathParam(value="tx-id1") TransactionId var1, @PathParam(value="tx-id2") TransactionId var2);

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransactionResult create(TransactionBuilder var1);

    @PUT
    @Path(value="{tx-id}/comment")
    public Response setTxComment(@PathParam(value="tx-id") TransactionId var1, String var2);

    @DELETE
    @Path(value="{tx-ids}")
    public Response purgeTxs(@PathParam(value="tx-ids") String var1);

    @DELETE
    @Path(value="purgeunused")
    public Response purgeUnusedBackingDataAndTransactions(@QueryParam(value="rowCount") @DefaultValue(value="100") int var1);

    @PUT
    @Path(value="branch/{branch-id}/transaction/{tx-id}/artifact/{art-id}/comment")
    public Response replaceWithBaselineTxVersion(@PathParam(value="branch-id") BranchId var1, @PathParam(value="tx-id") TransactionId var2, @PathParam(value="art-id") ArtifactId var3, String var4);

    @GET
    @Path(value="{art-id}/{branch-id}")
    @Produces(value={"application/json"})
    public List<ChangeItem> getArtifactHistory(@PathParam(value="art-id") ArtifactId var1, @PathParam(value="branch-id") BranchId var2);

    @PUT
    @Path(value="xfer/init")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TransferInitData initTransactionTransfer(TransferInitData var1);

    @GET
    @Path(value="xfer/getXferFile")
    @Produces(value={"application/json"})
    public XResultData generateTransferFile(@QueryParam(value="exportId") TransactionId var1, @QueryParam(value="mode") String var2);

    @GET
    @Path(value="xfer/getLatestXferFile")
    @Produces(value={"application/json"})
    public XResultData reGenerateTransferFile(@QueryParam(value="exportId") TransactionId var1, @QueryParam(value="mode") String var2);

    @POST
    @Path(value="xfer/upload")
    @Produces(value={"application/json"})
    public XResultData uploadTransferFile(InputStream var1);

    @POST
    @Path(value="xfer/apply")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public XResultData applyTransferFile(@QueryParam(value="location") String var1);

    @GET
    @Path(value="xfer/list")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public XResultData getTransferFileList(@QueryParam(value="exportId") String var1);

    @GET
    @Path(value="xfer/exportIdlist")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public XResultData getExportIdList();

    @GET
    @Path(value="xfer/exportData")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public XResultData getExportData(@QueryParam(value="exportId") String var1);

    @GET
    @Path(value="xfer/download")
    @Produces(value={"application/octet-stream"})
    public Response downloadTransferFile(@QueryParam(value="filename") String var1);

    @POST
    @Path(value="xfer/lock")
    @Produces(value={"application/json"})
    public XResultData lock(@QueryParam(value="exportId") TransactionId var1);

    @POST
    @Path(value="xfer/unlock")
    @Produces(value={"application/json"})
    public XResultData unlock(@QueryParam(value="exportId") TransactionId var1);

    @GET
    @Path(value="xfer/isLocked")
    @Produces(value={"application/json"})
    public XResultData isLocked(@QueryParam(value="exportId") TransactionId var1);
}

