/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.synchronization;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.osee.define.rest.api.synchronization.Root;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class ExportRequest
implements ToMessage {
    private String synchronizationArtifactType;
    private Root[] roots;

    public ExportRequest() {
        this.synchronizationArtifactType = null;
        this.roots = null;
    }

    public ExportRequest(String synchronizationArtifactType, Root[] roots) {
        this.synchronizationArtifactType = Objects.requireNonNull(synchronizationArtifactType, "ExportRequest::new, the parameter \"synchronizationArtifactType\" is null.");
        this.roots = Objects.requireNonNull(roots, "ExportRequest::new, the parameter \"roots\" is null.");
    }

    public Root[] getRoots() {
        if (Objects.isNull(this.roots)) {
            Message message = new Message().title((CharSequence)"ExportRequest::getRoots, the member \"roots\" has not been set.").blank();
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        return this.roots;
    }

    public String getSynchronizationArtifactType() {
        if (Objects.isNull(this.synchronizationArtifactType)) {
            Message message = new Message().title((CharSequence)"ExportRequest::getSynchronizationArtifactType, the member \"synchronizationArtifactType\" has not been set.").blank();
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        return this.synchronizationArtifactType;
    }

    public boolean isValid() {
        return Objects.nonNull(this.synchronizationArtifactType) && Objects.nonNull(this.roots) && !Arrays.stream(this.roots).anyMatch(Predicate.not(Root::isValid));
    }

    public void setRoots(Root[] roots) {
        if (Objects.nonNull(this.roots)) {
            Message message = new Message().title((CharSequence)"ExportRequest::setRoots, the member \"roots\" has already been set.").blank();
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        this.roots = Objects.requireNonNull(roots, "ExportRequest::setRoots, the parameter \"roots\" is null.");
    }

    public void setSynchronizationArtifactType(String synchronizationArtifactType) {
        if (Objects.nonNull(this.synchronizationArtifactType)) {
            Message message = new Message().title((CharSequence)"ExportRequest::getSynchronizationArtifactType, the member \"synchronizationArtifactType\" has already been set.").blank();
            this.toMessage(1, message);
            throw new IllegalStateException(message.toString());
        }
        this.synchronizationArtifactType = Objects.requireNonNull(synchronizationArtifactType, "ExportRequest::new, the parameter \"synchronizationArtifactType\" is null.");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = Objects.nonNull(message) ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"ExportRequest").indentInc().segment((CharSequence)"synchronizationArtifactType", (Object)this.synchronizationArtifactType).segmentIndexed((CharSequence)"roots", (Object[])this.roots).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

