/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.publisher.templatemanager;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.cxf.jaxrs.model.wadl.Description;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateKeyGroups;
import org.eclipse.osee.define.rest.api.publisher.templatemanager.PublishingTemplateRequest;
import org.eclipse.osee.framework.core.publishing.PublishingTemplate;
import org.eclipse.osee.framework.jdk.core.annotation.Swagger;

@Swagger
@Path(value="templatemanager")
public interface TemplateManagerEndpoint {
    @DELETE
    @Description(value="Empties the caches of Publishing Templates that are held by the Template Manager.")
    public void deleteCache();

    @POST
    @Description(value="Gets the publishing template that is the \"best match\" for the publishing template request parameters.")
    @Path(value="getPublishingTemplate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PublishingTemplate getPublishingTemplate(PublishingTemplateRequest var1);

    @POST
    @Description(value="Gets a status report for the publishing template that is the \"best match\" for the publishing template request parameters.")
    @Path(value="getPublishingTemplateStatus")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String getPublishingTemplateStatus(PublishingTemplateRequest var1);

    @GET
    @Description(value="Gets a list of all the keys for the Publishing Templates cached by the Publishing Template Manager. This method is provided for building a client GUI list of publishing templates for selection. Each element of the list contains the publishing template identifier, match criteria, name, and safe name. The list is sorted by the safe name.")
    @Path(value="getPublishingTemplateKeyGroups")
    @Produces(value={"application/json"})
    public PublishingTemplateKeyGroups getPublishingTemplateKeyGroups(@QueryParam(value="filterBySafeName") @DefaultValue(value="") String var1);
}

