/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.api.publisher.datarights;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.osee.define.rest.api.publisher.datarights.Section;
import org.eclipse.osee.define.rest.api.publisher.datarights.StatementMap;
import org.eclipse.osee.framework.core.publishing.FormatIndicator;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.ToMessage;

public class Response
implements ToMessage {
    private FormatIndicator format;
    private String cuiHeader;
    private StatementMap[] statementList;
    private Integer[] titlePageStatementList;
    private Integer[] everyPageHeaderStatementList;
    private Integer[] everyPageFooterStatementList;
    private Section[] sectionList;

    public Response() {
        this.format = null;
        this.cuiHeader = null;
        this.statementList = null;
        this.titlePageStatementList = null;
        this.everyPageHeaderStatementList = null;
        this.everyPageFooterStatementList = null;
        this.sectionList = null;
    }

    public Response(FormatIndicator format, String cuiHeader, StatementMap[] statementList, Integer[] titlePageStatementList, Integer[] everyPageHeaderStatementList, Integer[] everyPageFooterStatementList, Section[] sectionList) {
        this.format = Objects.requireNonNull(format, "Response::new, parameter \"format\" cannot be null.");
        this.cuiHeader = Objects.requireNonNull(cuiHeader, "Response::new, parameter \"cuiHeader\" cannot be null.");
        this.statementList = Objects.requireNonNull(statementList, "Response::new, parameter \"statementList\" cannot be null.");
        this.titlePageStatementList = Objects.requireNonNull(titlePageStatementList, "Response::new, parameter \"titlePageStatementList\" cannot be null.");
        this.everyPageHeaderStatementList = Objects.requireNonNull(everyPageHeaderStatementList, "Response::new, parameter \"everyPageHeaderStatementList\" cannot be null.");
        this.everyPageFooterStatementList = Objects.requireNonNull(everyPageFooterStatementList, "Response::new, parameter \"everyPageFooterStatementList\" cannot be null.");
        this.sectionList = Objects.requireNonNull(sectionList, "Response::new, parameter \"sectionList\" cannot be null.");
    }

    public FormatIndicator getFormat() {
        if (Objects.isNull(this.format)) {
            throw new IllegalStateException("Response::getFormat, member \"format\" has not been set.");
        }
        return this.format;
    }

    public String getCuiHeader() {
        if (Objects.isNull(this.cuiHeader)) {
            throw new IllegalStateException("Response::getCuiHeader, member \"cuiHeader\" has not been set.");
        }
        return this.cuiHeader;
    }

    public StatementMap[] getStatementList() {
        if (Objects.isNull(this.statementList)) {
            throw new IllegalStateException("Response::getStatementList, member \"statementList\" has not been set.");
        }
        return this.statementList;
    }

    public Integer[] getTitlePageStatementList() {
        if (Objects.isNull(this.titlePageStatementList)) {
            throw new IllegalStateException("Response::getTitlePageStatementList, member \"titlePageStatementList\" has not been set.");
        }
        return this.titlePageStatementList;
    }

    public Integer[] getEveryPageHeaderStatementList() {
        if (Objects.isNull(this.everyPageHeaderStatementList)) {
            throw new IllegalStateException("Response::getEveryPageHeaderStatementList, member \"everyPageHeaderStatementList\" has not been set.");
        }
        return this.everyPageHeaderStatementList;
    }

    public Integer[] getEveryPageFooterStatementList() {
        if (Objects.isNull(this.everyPageFooterStatementList)) {
            throw new IllegalStateException("Response::getEveryPageFooterStatementList, member \"everyPageFooterStatementList\" has not been set.");
        }
        return this.everyPageFooterStatementList;
    }

    public Section[] getSectionList() {
        if (Objects.isNull(this.statementList)) {
            throw new IllegalStateException("Response::getSectionList, member \"sectionList\" has not been set.");
        }
        return this.sectionList;
    }

    @JsonIgnore
    public boolean isValid() {
        return Objects.nonNull(this.format) && Objects.nonNull(this.cuiHeader) && Strings.isValidAndNonBlank((String)this.cuiHeader) && Objects.nonNull(this.statementList) && Arrays.stream(this.statementList).allMatch(StatementMap::isValid) && Objects.nonNull(this.titlePageStatementList) && Objects.nonNull(this.everyPageHeaderStatementList) && Objects.nonNull(this.everyPageFooterStatementList) && Objects.nonNull(this.sectionList) && Arrays.stream(this.sectionList).allMatch(Section::isValid);
    }

    public void setFormat(FormatIndicator format) {
        if (Objects.nonNull(this.format)) {
            throw new IllegalStateException("Response::setFormat, member \"format\" has already been set.");
        }
        this.format = Objects.requireNonNull(format, "Response::setFormat, parameter \"format\" cannot be null.");
    }

    public void setCuiHeader(String cuiHeader) {
        if (Objects.nonNull(this.cuiHeader)) {
            throw new IllegalStateException("Response::setCuiHeader, member \"cuiHeader\" has already been set.");
        }
        this.cuiHeader = Objects.requireNonNull(cuiHeader, "Response::setCuiHeader, parameter \"cuiHeader\" cannot be null.");
    }

    public void setStatementList(StatementMap[] statementList) {
        if (Objects.nonNull(this.statementList)) {
            throw new IllegalStateException("Response::setStatementList, member \"statementList\" has already been set.");
        }
        this.statementList = Objects.requireNonNull(statementList, "Response::setStatementList, parameter \"statementList\" cannot be null.");
    }

    public void setTitlePageStatementList(Integer[] titlePageStatementList) {
        if (Objects.nonNull(this.titlePageStatementList)) {
            throw new IllegalStateException("Response::setTitlePageStatementList, member \"titlePageStatementList\" has already been set.");
        }
        this.titlePageStatementList = Objects.requireNonNull(titlePageStatementList, "Response::setTitlePageStatementList, parameter \"titlePageStatementList\" cannot be null.");
    }

    public void setEveryPageHeaderStatementlist(Integer[] everyPageHeaderStatementList) {
        if (Objects.nonNull(this.everyPageHeaderStatementList)) {
            throw new IllegalStateException("Response::setEveryPageHeaderStatementList, member \"everyPageHeaderStatementList\" has already been set.");
        }
        this.everyPageHeaderStatementList = Objects.requireNonNull(everyPageHeaderStatementList, "Response::setEveryPageHeaderStatementList, parameter \"everyPageHeaderStatementList\" cannot be null.");
    }

    public void setEveryPageFooterStatementList(Integer[] everyPageFooterStatementList) {
        if (Objects.nonNull(this.everyPageFooterStatementList)) {
            throw new IllegalStateException("Response::setEveryPageFooterStatementList, member \"everyPageFooterStatementList\" has already been set.");
        }
        this.everyPageFooterStatementList = Objects.requireNonNull(everyPageFooterStatementList, "Response::setEveryPageFooterStatementList, parameter \"everyPageFooterStatementList\" cannot be null.");
    }

    public void setSectionList(Section[] sectionList) {
        if (Objects.nonNull(this.sectionList)) {
            throw new IllegalStateException("Response::setSectionList, member \"sectionList\" has already been set.");
        }
        this.sectionList = Objects.requireNonNull(sectionList, "Response::setSectionList, parameter \"sectionList\" cannot be null.");
    }

    public Message toMessage(int indent, Message message) {
        Message outMessage = message != null ? message : new Message();
        outMessage.indent(indent).title((CharSequence)"Data Rights - Response").indentInc().segment((CharSequence)"Format Indicator", (Object)this.format).segment((CharSequence)"CUI Header", (Object)this.cuiHeader).segment((CharSequence)"Statement Map", (Object)this.statementList).segment((CharSequence)"Title Page Statement List", (Object)this.titlePageStatementList).segment((CharSequence)"Every Page Header Statement List", (Object)this.everyPageHeaderStatementList).segment((CharSequence)"Every Page Footer Statement List", (Object)this.everyPageFooterStatementList).segment((CharSequence)"Section List", (Object)this.sectionList).indentDec();
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

