/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.publishing.relation.table.RelationTableOptions;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Message;
import org.eclipse.osee.orcs.core.internal.SetupPublishing;
import org.eclipse.osee.orcs.core.util.PublishingTemplateContentMapEntry;
import org.eclipse.osee.orcs.core.util.PublishingTemplateMatchCriterion;
import org.eclipse.osee.orcs.core.util.PublishingTemplateSetter;

public class PublishingTemplate {
    private String identifier;
    private final List<PublishingTemplateMatchCriterion> matchCriteria;
    private final String name;
    private final ArtifactToken parentArtifactToken;
    private final @Nullable Supplier<String> publishOptionsSupplier;
    private final @Nullable Supplier<String> templateContentSupplier;
    private final @Nullable RelationTableOptions relationTableOptions;
    private final List<PublishingTemplateContentMapEntry> publishingTemplateContentMapEntries;

    public static List<PublishingTemplate> load(Supplier<List<PublishingTemplate>> publishingTemplatesSupplier, PublishingTemplateSetter publishingTemplateSetter, Class<?> locationClass, boolean inOseeInf) {
        return publishingTemplatesSupplier.get().stream().map(publishingTemplate -> publishingTemplate.load(locationClass, inOseeInf, publishingTemplateSetter)).collect(Collectors.toList());
    }

    public PublishingTemplate(ArtifactToken parentArtifactToken, String name, @Nullable Supplier<String> publishOptionsSupplier, @Nullable Supplier<String> templateContentSupplier, List<PublishingTemplateContentMapEntry> publishingTemplateContentMapEntries, List<PublishingTemplateMatchCriterion> matchCriteria, RelationTableOptions relationTableOptions) {
        this.parentArtifactToken = Objects.requireNonNull(parentArtifactToken, "SetupPublishing.PublishingTemplate::new, paramter \"parentArtifactToken\" cannot be null.");
        this.name = Objects.requireNonNull(name, "SetupPublishing.PublishingTemplate::new, parameter \"name\" cannnot be null.");
        this.publishOptionsSupplier = publishOptionsSupplier;
        this.templateContentSupplier = templateContentSupplier;
        this.publishingTemplateContentMapEntries = Objects.requireNonNull(publishingTemplateContentMapEntries);
        this.matchCriteria = matchCriteria;
        this.relationTableOptions = relationTableOptions == null ? new RelationTableOptions() : relationTableOptions;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    private String readFile(boolean inOseeInf, Path filePath, Class<?> locationClass) {
        try {
            return inOseeInf ? OseeInf.getResourceContents((String)filePath.toString(), SetupPublishing.class) : Lib.fileToString(locationClass, (String)Paths.get("support", new String[0]).resolve(filePath).toString());
        }
        catch (Exception e) {
            Message message = new Message().title((CharSequence)"PublishingTemplate::readFile, Failed to load file.").indentInc().segment((CharSequence)"In Osee Inf", (Object)inOseeInf).segment((CharSequence)"File Path", (Object)filePath);
            if (!inOseeInf) {
                message.segment((CharSequence)"Location Class", (Object)locationClass.getName());
            }
            message.reasonFollows((Throwable)e);
            throw new AssertionError(message.toString(), e);
        }
    }

    private String readTemplateFile(boolean inOseeInf, Path filePath, Class<?> locationClass) {
        return this.readFile(inOseeInf, filePath, locationClass).replace("_TEMPLATE_NAME_", this.name);
    }

    private PublishingTemplate load(Class<?> locationClass, boolean inOseeInf, PublishingTemplateSetter publishingTemplateSetter) {
        Objects.requireNonNull(locationClass);
        Objects.requireNonNull(publishingTemplateSetter);
        String templateContents = (String)Conditions.getWhenNonNull(this.templateContentSupplier);
        String publishOptionsContents = (String)Conditions.getWhenNonNull(this.publishOptionsSupplier);
        List<Map.Entry<String, String>> publishingTemplateContentMapEntries = this.publishingTemplateContentMapEntries.stream().map(publishingTemplateContentMapEntry -> Map.entry(publishingTemplateContentMapEntry.getFormatIndicator().getFormatName(), this.readTemplateFile(inOseeInf, publishingTemplateContentMapEntry.getTemplateContentPath(), locationClass))).collect(Collectors.toList());
        ArrayList<String> matchCriteria = this.matchCriteria != null ? (List)this.matchCriteria.stream().map(PublishingTemplateMatchCriterion::getTemplateMatchCriteria).collect(Collectors.toCollection(ArrayList::new)) : new ArrayList<String>();
        this.identifier = publishingTemplateSetter.set(this.parentArtifactToken, this.name, templateContents, publishOptionsContents, publishingTemplateContentMapEntries, matchCriteria, this.relationTableOptions);
        return this;
    }

    public static class FileSupplierOseeInf
    implements Supplier<String> {
        private final String pathString;

        public FileSupplierOseeInf(String pathString) {
            this.pathString = pathString;
        }

        @Override
        public String get() {
            String filePathString = Paths.get(this.pathString, new String[0]).toString();
            try {
                String contents = OseeInf.getResourceContents((String)filePathString, SetupPublishing.class);
                return contents;
            }
            catch (Exception e) {
                Message message = new Message().title((CharSequence)"PublishingTemplate.FileSupplierOseeInf::get, Failed to load file.").indentInc().segment((CharSequence)"File Path", (Object)filePathString).reasonFollows((Throwable)e);
                throw new AssertionError(message.toString(), e);
            }
        }
    }

    public static class FileSupplierSupport
    implements Supplier<String> {
        private final String pathString;
        private final Class<?> locationClass;

        public FileSupplierSupport(String pathString, Class<?> locationClass) {
            this.pathString = pathString;
            this.locationClass = locationClass;
        }

        @Override
        public String get() {
            String filePathString = Paths.get("support", this.pathString).toString();
            try {
                String contents = Lib.fileToString(this.locationClass, (String)filePathString);
                return contents;
            }
            catch (Exception e) {
                Message message = new Message().title((CharSequence)"PublishingTemplate.FileSupplierSupport::get, Failed to load file.").indentInc().segment((CharSequence)"File Path", (Object)filePathString).segment((CharSequence)"Location Class", (Object)this.locationClass.getName()).reasonFollows((Throwable)e);
                throw new AssertionError(message.toString(), e);
            }
        }
    }

    public static class StringSupplier
    implements Supplier<String> {
        private final String string;

        public StringSupplier(String string) {
            this.string = string;
        }

        @Override
        public String get() {
            return this.string;
        }
    }
}

