/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.util;

import com.google.common.base.Predicate;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;

public abstract class FilterableCollection<MATCH_DATA, KEY, DATA> {
    private final Multimap<KEY, DATA> map;

    protected FilterableCollection(Multimap<KEY, DATA> map) {
        this.map = map;
    }

    protected FilterableCollection() {
        this(Multimaps.synchronizedMultimap((Multimap)LinkedHashMultimap.create()));
    }

    protected abstract ResultSet<DATA> createResultSet(List<DATA> var1);

    protected abstract <T extends DATA> ResultSet<T> createResultSet(KEY var1, List<T> var2);

    public void add(KEY type, DATA data) {
        this.map.put(type, data);
    }

    public void remove(KEY type, DATA data) {
        this.map.remove(type, data);
    }

    public Collection<DATA> getAll() {
        return this.map.values();
    }

    public Collection<DATA> getAllByType(KEY type) {
        return this.map.get(type);
    }

    protected List<DATA> getListByFilter(Predicate<MATCH_DATA> matcher) {
        return this.getListByFilter(this.getAll(), matcher);
    }

    protected ResultSet<DATA> getResultSetByFilter(Predicate<MATCH_DATA> matcher) {
        return this.getResultSetByFilter(this.getAll(), matcher);
    }

    protected <T extends DATA> ResultSet<T> getSetByFilter(KEY type, Predicate<MATCH_DATA> matcher) {
        List<T> result = this.getListByFilter(type, matcher);
        ResultSet<T> resultSet = this.createResultSet(type, result);
        return resultSet;
    }

    protected <T extends DATA> List<T> getListByFilter(KEY type, Predicate<MATCH_DATA> matcher) {
        return this.getListByFilter(this.getAllByType(type), matcher);
    }

    protected boolean hasItemMatchingFilter(Predicate<MATCH_DATA> matcher) {
        return this.hasItemMatchingFilter(this.getAll(), matcher);
    }

    protected boolean hasItemMatchingFilter(KEY type, Predicate<MATCH_DATA> matcher) {
        return this.hasItemMatchingFilter(this.getAllByType(type), matcher);
    }

    private ResultSet<DATA> getResultSetByFilter(Collection<DATA> source, Predicate<MATCH_DATA> matcher) {
        List values = this.getListByFilter(source, matcher);
        return this.createResultSet(values);
    }

    private <T extends DATA> List<T> getListByFilter(Collection<DATA> source, Predicate<MATCH_DATA> matcher) {
        List toReturn;
        if (source != null && !source.isEmpty()) {
            toReturn = new LinkedList();
            Iterator<DATA> iterator = source.iterator();
            while (iterator.hasNext()) {
                DATA data = iterator.next();
                if (this.isValid(data)) {
                    MATCH_DATA toMatch = this.asMatcherData(data);
                    if (!matcher.apply(toMatch)) continue;
                    toReturn.add(data);
                    continue;
                }
                iterator.remove();
            }
        } else {
            toReturn = Collections.emptyList();
        }
        return toReturn;
    }

    private boolean hasItemMatchingFilter(Collection<DATA> source, Predicate<MATCH_DATA> matcher) {
        boolean result = false;
        if (source != null && !source.isEmpty()) {
            Iterator<DATA> iterator = source.iterator();
            while (iterator.hasNext()) {
                DATA data = iterator.next();
                if (this.isValid(data)) {
                    MATCH_DATA toMatch = this.asMatcherData(data);
                    if (!matcher.apply(toMatch)) continue;
                    result = true;
                    break;
                }
                iterator.remove();
            }
        }
        return result;
    }

    protected boolean isValid(DATA data) {
        return true;
    }

    protected abstract MATCH_DATA asMatcherData(DATA var1);

    public String toString() {
        return "FilterableCollection [mapSize=" + this.map.size() + "]";
    }
}

