/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.attribute;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.core.ds.Attribute;
import org.eclipse.osee.orcs.core.ds.ResourceNameResolver;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactImpl;

public class AttributeResourceNameResolver
implements ResourceNameResolver {
    private static final int MAX_NAME_SIZE = 60;
    private final Attribute<?> attribute;

    public AttributeResourceNameResolver(Attribute<?> attribute) {
        this.attribute = attribute;
    }

    @Override
    public String getStorageName() {
        ArtifactToken identity = this.attribute.getContainer();
        String guid = identity.getGuid();
        Conditions.checkExpressionFailOnTrue((!GUID.isValid((CharSequence)guid) ? 1 : 0) != 0, (String)"Artifact has an invalid guid [%s]", (Object[])new Object[]{guid});
        return guid;
    }

    @Override
    public String getInternalFileName() {
        ArtifactToken identity = this.attribute.getContainer();
        StringBuilder builder = new StringBuilder();
        try {
            String name = identity.getName();
            if (name.length() > 60) {
                name = name.substring(0, 60);
            }
            builder.append(URLEncoder.encode(name, "UTF-8"));
            builder.append(".");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        builder.append(this.getStorageName());
        String fileTypeExtension = null;
        if (identity instanceof ArtifactImpl) {
            fileTypeExtension = ((ArtifactImpl)identity).getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Extension, null);
        }
        if (!Strings.isValid(fileTypeExtension)) {
            fileTypeExtension = this.attribute.getAttributeType().getFileExtension();
        }
        if (Strings.isValid(fileTypeExtension)) {
            builder.append(".");
            builder.append(fileTypeExtension);
        }
        return builder.toString();
    }
}

