/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.applicability;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.FileTypeApplicabilityData;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.orcs.core.internal.applicability.BatFileProcessor;
import org.eclipse.osee.orcs.core.internal.applicability.BlockApplicabilityOps;
import org.eclipse.osee.orcs.core.internal.applicability.TagNotPlacedCorrectlyException;

public class BatStagingCreator {
    private final BlockApplicabilityOps orcsApplicability;
    private final Map<String, FileTypeApplicabilityData> fileTypeApplicabilityDataMap;
    private final Pattern validFileExtensions;
    private final boolean commentNonApplicableBlocks;

    public BatStagingCreator(BlockApplicabilityOps orcsApplicability, Map<String, FileTypeApplicabilityData> fileTypeApplicabilityData, Pattern validFileExtensions, boolean commentNonApplicableBlocks) {
        this.orcsApplicability = orcsApplicability;
        this.fileTypeApplicabilityDataMap = fileTypeApplicabilityData;
        this.validFileExtensions = validFileExtensions;
        this.commentNonApplicableBlocks = commentNonApplicableBlocks;
    }

    public File processDirectory(XResultData results, File inFile, File stageFileParent, Set<String> filesToExclude) {
        boolean isDirectory;
        OseeLog.log(this.getClass(), (Level)Level.FINEST, (String)("BatStagingCreator::processDirectory => Started file: " + inFile.getPath()));
        if (results.isErrors()) {
            return null;
        }
        HashSet<String> excludedFiles = new HashSet<String>();
        excludedFiles.addAll(filesToExclude);
        String inFileName = inFile.getName();
        if (!(this.isExcluded(inFileName, excludedFiles) || (isDirectory = inFile.isDirectory()) && inFileName.startsWith("."))) {
            File stageFile = new File(stageFileParent, inFileName);
            if (isDirectory) {
                if (!stageFile.exists() && !stageFile.mkdir()) {
                    results.warningf("Unable to create stage directory for %s\n", new Object[]{inFile.getPath()});
                    return null;
                }
                ArrayList<File> children = new ArrayList<File>();
                children.addAll(Arrays.asList(inFile.listFiles()));
                ConcurrentSkipListSet<File> stagedChildren = new ConcurrentSkipListSet<File>();
                stagedChildren.addAll(Arrays.asList(stageFile.listFiles()));
                Set<String> filesInConfig = this.processConfig(results, children, stageFile);
                excludedFiles.addAll(filesInConfig);
                ExecutorService executor = Executors.newFixedThreadPool(2);
                for (File child : children) {
                    Runnable task = () -> {
                        File stagedFile = this.processDirectory(results, child, stageFile, excludedFiles);
                        if (stagedFile != null) {
                            stagedChildren.remove(stagedFile);
                        }
                    };
                    executor.execute(task);
                }
                executor.shutdown();
                try {
                    executor.awaitTermination(3600L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    results.warningf("A thread was interrupted while processing a subdirectory of %s\n", new Object[]{inFile.getPath()});
                }
                for (File fileToRemove : stagedChildren) {
                    try {
                        Files.walk(fileToRemove.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                    catch (IOException iOException) {
                        results.warningf("An exception occured while cleaning up unstaged files under %s\n", new Object[]{inFile.getPath()});
                    }
                }
                if (!excludedFiles.isEmpty()) {
                    this.orcsApplicability.addFileApplicabilityEntry(stageFile.getPath(), excludedFiles);
                }
            } else {
                try {
                    boolean isNew;
                    boolean tagProcessed = false;
                    File outFile = new File(stageFile.toPath() + ".tmp");
                    if (this.validFileExtensions.matcher(inFileName).matches()) {
                        FileTypeApplicabilityData fileTypeApplicabilityData = this.fileTypeApplicabilityDataMap.get(Lib.getExtension((String)inFile.getName()).toLowerCase());
                        try {
                            tagProcessed = new BatFileProcessor(this.orcsApplicability, fileTypeApplicabilityData, false, this.commentNonApplicableBlocks).processFile(inFile, outFile);
                        }
                        catch (TagNotPlacedCorrectlyException ex) {
                            OseeLog.log(this.getClass(), (Level)Level.FINEST, (String)("BatStagingCreator::processDirectory => TagNotPlacedCorrectlyException thrown in file: " + inFile.getPath()));
                            OseeLog.log(this.getClass(), (Level)Level.FINEST, (String)("BatStagingCreator::processDirectory => TagNotPlacedCorrectlyException details: " + ex.toString()));
                            results.warning("Tag was not placed correctly in file: " + inFile.getPath() + ". This file will not be processed.");
                            return stageFile;
                        }
                        catch (Exception ex) {
                            OseeLog.log(this.getClass(), (Level)Level.FINEST, (String)("BatStagingCreator::processDirectory => Exception thrown in file: " + inFile.getPath()));
                            OseeLog.log(this.getClass(), (Level)Level.FINEST, (String)("BatStagingCreator::processDirectory => Exception details: " + ex.toString()));
                            results.error(ex.toString());
                            return stageFile;
                        }
                    }
                    if (isNew = this.isStageFileNew(stageFile, outFile)) {
                        if (!tagProcessed) {
                            OseeLog.log(this.getClass(), (Level)Level.FINEST, (String)("BatStagingCreator::processDirectory: Creating link " + stageFile.toPath() + " with " + inFile.toPath()));
                            Files.createLink(stageFile.toPath(), inFile.toPath());
                        } else {
                            stageFile.delete();
                            outFile.setReadOnly();
                            com.google.common.io.Files.move((File)outFile, (File)stageFile);
                        }
                    }
                    if (outFile.exists()) {
                        outFile.delete();
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(this.getClass(), (Level)Level.FINEST, (String)("BatStagingCreator::processDirectory: Exception in " + inFile.getPath()));
                    OseeLog.log(this.getClass(), (Level)Level.FINEST, (String)("BatStagingCreator::processDirectory: Exception details" + ex.toString()));
                    results.warningf("Exception %s in file %s\n", new Object[]{ex.toString(), inFile.getPath()});
                }
            }
            return stageFile;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStageFileNew(File stageFile, File outFile) throws IOException {
        if (!stageFile.exists()) {
            return true;
        }
        if (!outFile.exists()) {
            return false;
        }
        if (stageFile.length() != outFile.length()) {
            return true;
        }
        boolean isFileNew = false;
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            BufferedReader stageReader = Files.newBufferedReader(stageFile.toPath());
            try {
                try (BufferedReader outReader = Files.newBufferedReader(outFile.toPath());){
                    String outLine;
                    String stageLine;
                    while ((stageLine = stageReader.readLine()) != null && (outLine = outReader.readLine()) != null) {
                        if (stageLine.equals(outLine)) continue;
                        isFileNew = true;
                    }
                }
                if (stageReader == null) return isFileNew;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (stageReader == null) throw throwable;
                stageReader.close();
                throw throwable;
            }
            stageReader.close();
            return isFileNew;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private Set<String> processConfig(XResultData results, List<File> children, File stageFile) {
        HashSet<String> filesToExclude = new HashSet<String>();
        File configFile = null;
        for (File child : children) {
            String fileName = child.getName();
            if (!fileName.equals(".fileApplicability")) continue;
            configFile = child;
            FileTypeApplicabilityData fileTypeApplicabilityData = this.fileTypeApplicabilityDataMap.get(Lib.getExtension((String)configFile.getName()).toLowerCase());
            Pattern tagPattern = fileTypeApplicabilityData.getCommentedTagPattern();
            try {
                Throwable throwable = null;
                Object var13_14 = null;
                try {
                    FileReader file = new FileReader(configFile);
                    try {
                        try (BufferedReader reader = new BufferedReader(file);){
                            String readLine;
                            while ((readLine = reader.readLine()) != null) {
                                if (tagPattern.matcher(readLine).matches() || readLine.isEmpty()) continue;
                                filesToExclude.add(readLine);
                            }
                            File stagedConfig = new File(stageFile, configFile.getName());
                            new BatFileProcessor(this.orcsApplicability, fileTypeApplicabilityData, true, this.commentNonApplicableBlocks).processFile(configFile, stagedConfig);
                            Throwable throwable2 = null;
                            Object var18_23 = null;
                            try (BufferedReader reader2 = new BufferedReader(new FileReader(stagedConfig));){
                                while ((readLine = reader2.readLine()) != null) {
                                    if (tagPattern.matcher(readLine).matches() || readLine.isEmpty()) continue;
                                    filesToExclude.remove(readLine);
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                            stagedConfig.delete();
                        }
                        if (file == null) break;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (file != null) {
                            file.close();
                        }
                        throw throwable;
                    }
                    file.close();
                    break;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                results.warningf("Exception %s with file %s\n", new Object[]{ex.toString(), configFile.getPath()});
                return new HashSet<String>();
            }
        }
        children.remove(configFile);
        return filesToExclude;
    }

    private boolean isExcluded(String inFileName, Set<String> excludedFiles) {
        if (excludedFiles.contains(inFileName)) {
            return true;
        }
        for (String excludedName : excludedFiles) {
            Pattern excludePattern;
            if (!excludedName.contains("*") || !(excludePattern = Pattern.compile("^(" + (excludedName = excludedName.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*").replaceAll("\\!", "")) + ")$")).matcher(inFileName).matches()) continue;
            return true;
        }
        return false;
    }
}

