/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.cache.admin;

import java.util.concurrent.TimeUnit;
import org.eclipse.osee.framework.jdk.core.type.Pair;

public class CacheConfiguration {
    private static final int DEFAULT_UNSET = -1;
    private static final Pair<Long, TimeUnit> UNSET_EXPIRATION = new Pair((Object)-1L, (Object)TimeUnit.NANOSECONDS);
    private int initialCapacity = -1;
    private long maxSize = -1L;
    private Pair<Long, TimeUnit> expireAfterAccess = UNSET_EXPIRATION;
    private Pair<Long, TimeUnit> expireAfterWrite = UNSET_EXPIRATION;
    private Pair<Long, TimeUnit> refreshAfterWrite = UNSET_EXPIRATION;

    private CacheConfiguration() {
    }

    public static CacheConfiguration newConfiguration() {
        return new CacheConfiguration();
    }

    public boolean hasInitialCapacity() {
        return this.initialCapacity >= 0;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public boolean hasMaximumSize() {
        return this.maxSize >= 0L;
    }

    public void setMaximumSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public boolean isExpireAfterAccess() {
        return !UNSET_EXPIRATION.equals(this.expireAfterAccess);
    }

    public void setExpireAfterAccess(long duration, TimeUnit timeUnit) {
        this.expireAfterAccess = new Pair((Object)duration, (Object)timeUnit);
    }

    public boolean isExpireAfterWrite() {
        return !UNSET_EXPIRATION.equals(this.expireAfterWrite);
    }

    public void setExpireAfterWrite(long duration, TimeUnit timeUnit) {
        this.expireAfterWrite = new Pair((Object)duration, (Object)timeUnit);
    }

    public boolean isRefreshAfterWrite() {
        return !UNSET_EXPIRATION.equals(this.refreshAfterWrite);
    }

    public void setRefreshAfterWrite(long duration, TimeUnit timeUnit) {
        this.refreshAfterWrite = new Pair((Object)duration, (Object)timeUnit);
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public long getMaximumSize() {
        return this.maxSize;
    }

    public Pair<Long, TimeUnit> getExpireAfterAccess() {
        return this.expireAfterAccess;
    }

    public Pair<Long, TimeUnit> getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public Pair<Long, TimeUnit> getRefreshAfterWrite() {
        return this.refreshAfterWrite;
    }
}

