/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.duplicate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.clone.CloneData;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.workflow.util.DuplicateWorkflowAsIsOperation;
import org.eclipse.osee.ats.core.workflow.util.IDuplicateWorkflowListener;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class CloneTeamWorkflowOperation
implements IDuplicateWorkflowListener {
    private final CloneData data;
    private final AtsApi atsApi;
    private final IDuplicateWorkflowListener duplicateListener;
    private final IAtsTeamWorkflow teamWf;

    public CloneTeamWorkflowOperation(IAtsTeamWorkflow teamWf, IDuplicateWorkflowListener duplicateListener, CloneData cloneData, AtsApi atsApi) {
        this.teamWf = teamWf;
        this.duplicateListener = duplicateListener;
        this.data = cloneData;
        this.atsApi = atsApi;
    }

    public CloneData run() {
        ArrayList<IDuplicateWorkflowListener> listeners = new ArrayList<IDuplicateWorkflowListener>();
        if (this.duplicateListener != null) {
            listeners.add(this.duplicateListener);
        }
        listeners.add(this);
        boolean newAction = this.data.isCreateNewAction();
        String newTitle = this.data.getTitle();
        DuplicateWorkflowAsIsOperation dupOp = new DuplicateWorkflowAsIsOperation(Arrays.asList(this.teamWf), false, newTitle, AtsApiService.get().getUserService().getCurrentUser(), AtsApiService.get(), "Clone from " + this.teamWf.toStringWithId(), newAction, listeners);
        AtsUser orig = this.data.getOriginator();
        dupOp.setOriginator(orig);
        String desc = this.data.getDesc();
        if (Strings.isInValid((String)desc)) {
            desc = this.teamWf.getDescription();
        }
        dupOp.setDescription(desc);
        dupOp.setAssignees(this.data.getAssignees());
        dupOp.setChangeType(this.data.getChangeType());
        dupOp.setPriority(this.data.getPriority());
        dupOp.setPoints(this.data.getPoints());
        dupOp.run();
        if (this.data.getResults().isSuccess()) {
            this.data.setNewTeamWf(dupOp.getResults().get(this.teamWf).getArtifactId());
        }
        return this.data;
    }

    @Override
    public boolean handleChanges(IAtsTeamWorkflow newTeamWf, IAtsChangeSet changes) {
        if (this.data.getTargetedVersion() == null) {
            this.atsApi.getVersionService().setTargetedVersion(newTeamWf, null, changes);
        } else {
            this.atsApi.getVersionService().setTargetedVersion(newTeamWf, this.data.getTargetedVersion(), changes);
        }
        if (this.data.getSprint() == null) {
            this.atsApi.getAgileService().setSprint(newTeamWf, null, changes);
        } else {
            this.atsApi.getAgileService().setSprint(newTeamWf, this.data.getSprint(), changes);
        }
        IAgileTeam aTeam = this.atsApi.getAgileService().getAgileTeam((IAtsWorkItem)this.teamWf);
        if (aTeam != null) {
            Collection featureGroups = this.atsApi.getAgileService().getAgileFeatureGroups(aTeam);
            block0: for (String featureStr : this.data.getFeatures()) {
                for (IAgileFeatureGroup grp : featureGroups) {
                    if (!grp.getName().equals(featureStr)) continue;
                    changes.relate((Object)grp, AtsRelationTypes.AgileFeatureToItem_AtsItem, (Object)newTeamWf);
                    continue block0;
                }
            }
        }
        return true;
    }
}

