/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.task;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.commit.CommitConfigItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.api.task.CreateTasksOption;
import org.eclipse.osee.ats.api.task.IAtsTaskProvider;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.task.create.ChangeReportOptionsToTeam;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskData;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskMatch;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskMatchResult;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskMatchType;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskNameProviderToken;
import org.eclipse.osee.ats.api.task.create.ChangeReportTaskTeamWfData;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinition;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinitionBuilder;
import org.eclipse.osee.ats.api.task.create.IAtsChangeReportTaskNameProvider;
import org.eclipse.osee.ats.api.task.create.StaticTaskDefinition;
import org.eclipse.osee.ats.api.task.related.AutoGenVersion;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.core.task.ChangeReportTasksUtil;
import org.eclipse.osee.ats.core.task.CreateTasksOperation;
import org.eclipse.osee.ats.core.task.CreateTasksWorkflow;
import org.eclipse.osee.ats.core.task.internal.AtsTaskProviderCollector;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.result.table.XResultTable;
import org.eclipse.osee.framework.jdk.core.result.table.XResultTableColumn;
import org.eclipse.osee.framework.jdk.core.result.table.XResultTableDataType;
import org.eclipse.osee.framework.jdk.core.result.table.XResultTableRow;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class CreateChangeReportTasksOperation {
    private final AtsTaskDefToken taskDefToken;
    private final AtsApi atsApi;
    private final ChangeReportTaskData crtd;
    private static final String TASK_GEN_TAG = "taskgen";

    public CreateChangeReportTasksOperation(ChangeReportTaskData crtd, AtsApi atsApi, IAtsChangeSet changes) {
        this.crtd = crtd;
        this.taskDefToken = crtd.getTaskDefToken();
        this.atsApi = atsApi;
        if (changes != null) {
            this.crtd.setChanges(changes);
        }
    }

    public ChangeReportTaskData run() {
        XResultData rd = this.crtd.getResults();
        rd.log(String.valueOf(this.crtd.getOperationName()) + "\n");
        try {
            if (this.crtd.getHostTeamWf() == null || this.crtd.getHostTeamWf().isInvalid()) {
                rd.error("No Host Team Workflow specified.\n");
                return this.crtd;
            }
            final IAtsTeamWorkflow hostTeamWf = this.atsApi.getQueryService().getTeamWf((ArtifactId)this.crtd.getHostTeamWf());
            if (hostTeamWf == null) {
                rd.error("No Host Team Workflow can be found.\n");
                return this.crtd;
            }
            if (!this.crtd.isReportOnly() && hostTeamWf.getTags().contains("finalTaskgen")) {
                rd.log("Final Task Generation has already been run.");
                return this.crtd;
            }
            this.crtd.getIdToTeamWf().put(hostTeamWf.getId(), hostTeamWf);
            rd.logf("Creating from host Team Wf %s\n", new Object[]{hostTeamWf.toStringWithId()});
            CreateTasksDefinitionBuilder taskSetDefinition = this.atsApi.getTaskSetDefinitionProviderService().getTaskSetDefinition(this.taskDefToken);
            if (taskSetDefinition == null) {
                rd.errorf("No CreateTasksDefinition found for Task Def id %s\n", new Object[]{this.taskDefToken.toStringWithId()});
                return this.crtd;
            }
            CreateTasksDefinition setDef = taskSetDefinition.getCreateTasksDef();
            if (!setDef.getHelper().isApplicable((IAtsWorkItem)hostTeamWf, this.atsApi)) {
                rd.logf("CreateTaskSetDefinition not applicable for %s", new Object[]{hostTeamWf.toStringWithId()});
                return this.crtd;
            }
            rd.logf("Creating tasks for task definition %s\n", new Object[]{setDef.toStringWithId()});
            this.crtd.setSetDef(setDef);
            IAtsProgram program = this.atsApi.getProgramService().getProgram((IAtsWorkItem)hostTeamWf);
            IAtsTeamDefinition fromSiblingTeamDef = this.getFromSiblingTeamDef(setDef, program, rd);
            if (!this.atsApi.getProgramService().getTeamDefs(program).contains(fromSiblingTeamDef)) {
                rd.logf("Host Team Wf Team Definition %s does not belong to Program %s Team Definitions; skipping", new Object[]{hostTeamWf.getTeamDefinition().toStringWithId(), program.toStringWithId()});
                return this.crtd;
            }
            IAtsTeamWorkflow chgRptTeamWf = null;
            if (this.crtd.getChgRptTeamWf().isValid()) {
                chgRptTeamWf = this.atsApi.getQueryService().getTeamWf((ArtifactId)this.crtd.getHostTeamWf());
            } else {
                IAtsTeamDefinition fromSiblingTeamD = this.getFromSiblingTeamDef(setDef, program, rd);
                Collection siblings = this.atsApi.getWorkItemService().getSiblings(hostTeamWf, fromSiblingTeamD);
                if (siblings.size() > 1 && siblings.contains(hostTeamWf)) {
                    chgRptTeamWf = hostTeamWf;
                }
                if (chgRptTeamWf == null) {
                    if (siblings.size() > 1 || siblings.isEmpty()) {
                        rd.errorf("Expected one source sibling workflow, found %s\n", new Object[]{siblings});
                        return this.crtd;
                    }
                    chgRptTeamWf = (IAtsTeamWorkflow)siblings.iterator().next();
                }
            }
            rd.logf("Using Change Report Team Wf %s\n", new Object[]{chgRptTeamWf.toStringWithId()});
            this.crtd.getIdToTeamWf().put(chgRptTeamWf.getId(), chgRptTeamWf);
            this.crtd.setChgRptTeamWf(chgRptTeamWf.getStoreObject());
            this.crtd.setActionId((ArtifactId)chgRptTeamWf.getParentAction().getStoreObject());
            ChangeReportTasksUtil.getBranchOrCommitChangeData(this.crtd, setDef);
            if (this.crtd.getResults().isErrors()) {
                return this.crtd;
            }
            List toSiblingTeamDatas = setDef.getChgRptOptions().getToSiblingTeamDatas();
            if (toSiblingTeamDatas.isEmpty()) {
                rd.errorf("No sibling team defs found for id %s\n", new Object[]{this.taskDefToken.toStringWithId()});
                return this.crtd;
            }
            rd.logf("For Sibling Team AIs [%s]\n", new Object[]{Collections.toString((String)", ", (Iterable)toSiblingTeamDatas)});
            boolean reportOnly = this.crtd.isReportOnly() || this.getTaskDefinition().getChgRptOptions().getCreateOptions().contains(CreateTasksOption.ReportOnly);
            this.crtd.setReportOnly(reportOnly);
            rd.logf("Report Only %s\n", new Object[]{reportOnly});
            IAtsChangeSet changes = null;
            if (!reportOnly) {
                String useComment = this.crtd.getCommitComment();
                if (Strings.isInvalid((String)useComment)) {
                    rd.errorf("Commit comment can not be invalid for %s", new Object[]{this.crtd.toString()});
                    return this.crtd;
                }
                rd.logf("\nCommitting with comment [%s]\n", new Object[]{useComment});
                changes = this.atsApi.createChangeSet(this.crtd.getCommitComment(), this.crtd.getAsUser());
            }
            for (ChangeReportOptionsToTeam toSiblingTeamDef : toSiblingTeamDatas) {
                IAtsChangeReportTaskNameProvider nameProvider;
                IAtsTeamDefinition toTeamDef = this.getToTeamDef(setDef, program, rd, toSiblingTeamDef);
                if (toTeamDef == null) {
                    rd.errorf("\n\nCan't determine toTeamDef from Team Def or Work Type %s\n", new Object[]{toSiblingTeamDef});
                    return this.crtd;
                }
                rd.logf("\n\nHandling Team %s\n", new Object[]{toTeamDef.toStringWithId()});
                ChangeReportTaskTeamWfData crttwd = new ChangeReportTaskTeamWfData();
                this.crtd.addChangeReportData(crttwd);
                crttwd.setReportOnly(reportOnly);
                crttwd.setRd(rd);
                crttwd.setChgRptTeamWf(chgRptTeamWf.getStoreObject());
                crttwd.setDestTeamDef(toTeamDef.getStoreObject());
                WorkType workType = WorkType.None;
                Collection workTypes = toTeamDef.getWorkTypes();
                if (workTypes != null) {
                    if (workTypes.contains(WorkType.Code) || toTeamDef.getName().contains("Code")) {
                        workType = WorkType.Code;
                    } else if (workTypes.contains(WorkType.Test) || toTeamDef.getName().contains("Test")) {
                        workType = WorkType.Test;
                    }
                }
                if (workType == WorkType.None) {
                    rd.errorf("\n\nCan't determine Work Type from Team Def or Name %s\n", new Object[]{toTeamDef.toStringWithId()});
                    return this.crtd;
                }
                crttwd.setWorkType(workType);
                IAtsVersion targetedVersion = this.atsApi.getVersionService().getTargetedVersion((IAtsWorkItem)chgRptTeamWf);
                if (targetedVersion == null || targetedVersion.isInvalid()) {
                    rd.errorf("Targeted Version is invalid for Host Team Workflow %s\n", new Object[]{chgRptTeamWf.toStringWithAtsId()});
                    return this.crtd;
                }
                IAtsActionableItem ai = this.getToSiblingAi(setDef, program, rd, toSiblingTeamDef);
                if (ai == null || ai.isInvalid()) {
                    rd.errorf("Actionable Item  %s is invalid for team %s or work type %s\n", new Object[]{toSiblingTeamDef.getAiId(), toSiblingTeamDef.getTeamId(), toSiblingTeamDef.getWorkType()});
                    return this.crtd;
                }
                ChangeReportTaskNameProviderToken nameProviderId = toSiblingTeamDef.getNameProviderId();
                if (nameProviderId == null) {
                    nameProviderId = ChangeReportTaskNameProviderToken.DefaultChangeReportOptionsNameProvider;
                }
                if ((nameProvider = this.atsApi.getTaskService().getChangeReportOptionNameProvider(nameProviderId)) == null) {
                    this.crtd.getResults().errorf("Can't find IAtsChangeReportTaskNameProvider for provider id %s", new Object[]{nameProviderId.toStringWithId()});
                    return this.crtd;
                }
                if (this.crtd.getWorkOrParentBranchId().isInvalid()) {
                    this.crtd.getResults().log("No Working or Parent Branch; Nothing to do");
                    return this.crtd;
                }
                Map idToArtifact = nameProvider.getTasksComputedAsNeeded(this.crtd, crttwd, this.atsApi);
                this.addIfDebug("============== Task Computed As Needed ================================\n", new Object[0]);
                for (ChangeReportTaskMatch taskMatch : crttwd.getTaskMatches()) {
                    this.addIfDebug("[%s]\n", taskMatch.toString().replaceFirst("mapped to task none", ""));
                }
                this.addIfDebug("=======================================================================\n", new Object[0]);
                if (crttwd.getTaskMatches().isEmpty()) {
                    rd.success("No Tasks to Generate", new Object[0]);
                    continue;
                }
                IAtsTeamWorkflow destTeamWf = ChangeReportTasksUtil.getDestTeamWfOrNull(crttwd, workType, this.atsApi, chgRptTeamWf, toTeamDef);
                NewTaskData newTaskData = NewTaskData.create((NewTaskSet)crttwd.getNewTaskSet(), (IAtsTeamWorkflow)destTeamWf);
                if (destTeamWf == null) {
                    if (changes != null) {
                        CreateTasksWorkflow workflowCreator = new CreateTasksWorkflow(hostTeamWf.getName(), (Collection<CreateTasksOption>)setDef.getChgRptOptions().getCreateOptions(), true, reportOnly, crttwd.getRd(), changes, new Date(), AtsCoreUsers.SYSTEM_USER, chgRptTeamWf, new CommitConfigItem(targetedVersion, this.atsApi), crttwd.getWorkType(), null, null);
                        workflowCreator.setActionableItem(ai);
                        workflowCreator.getNewActionListeners().add(new INewActionListener(){

                            public void teamCreated(IAtsAction action, IAtsTeamWorkflow teamWf, IAtsChangeSet changes) {
                                changes.setSoleAttributeValue((IAtsWorkItem)teamWf, (AttributeTypeToken)CoreAttributeTypes.Name, hostTeamWf.getName());
                            }
                        });
                        destTeamWf = workflowCreator.createMissingWorkflow();
                        rd.success("Created Destination Team Wf %s\n", new Object[]{destTeamWf.toStringWithId()});
                    } else {
                        rd.logf("Need to Create Destination Team Wf for team %s with name [%s]\n", new Object[]{toTeamDef.toStringWithId(), hostTeamWf.getName()});
                    }
                } else {
                    rd.logf("Using existing Destination Team Wf %s\n", new Object[]{destTeamWf.toStringWithId()});
                }
                if (changes != null) {
                    this.atsApi.getVersionService().setTargetedVersion(destTeamWf, targetedVersion, changes);
                }
                if (changes != null && this.atsApi.getRelationResolver().areNotRelated((IAtsObject)chgRptTeamWf, AtsRelationTypes.Derive_To, (IAtsObject)destTeamWf)) {
                    changes.relate((Object)chgRptTeamWf, AtsRelationTypes.Derive_To, (Object)destTeamWf);
                }
                if (destTeamWf != null) {
                    crttwd.setDestTeamWf(destTeamWf.getStoreObject());
                    this.crtd.getIdToTeamWf().put(destTeamWf.getId(), destTeamWf);
                    this.crtd.getDestTeamWfs().add(ArtifactToken.valueOf((long)destTeamWf.getStoreObject().getId(), (String)destTeamWf.getName(), (BranchToken)this.atsApi.getAtsBranch()));
                    for (AttributeTypeToken attrType : this.crtd.getSetDef().getChgRptOptions().getCopyAttrTypes()) {
                        List destValues;
                        List sourceValues = this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)chgRptTeamWf, attrType);
                        if (Collections.isEqual((Collection)sourceValues, (Collection)(destValues = this.atsApi.getAttributeResolver().getAttributesToStringList((IAtsObject)destTeamWf, attrType)))) continue;
                        this.crtd.getResults().success("Addition additional attr [%s]", new Object[]{String.valueOf(attrType.toStringWithId()) + "\n"});
                        if (changes == null) continue;
                        changes.setAttributeValuesAsStrings((IAtsObject)destTeamWf, attrType, sourceValues);
                    }
                }
                ChangeReportTasksUtil.determinExistingTaskMatchType(idToArtifact, this.crtd, crttwd, setDef, workType, destTeamWf);
                HashSet<String> addModTaskNames = new HashSet<String>();
                HashSet<String> deletedTaskNames = new HashSet<String>();
                Date createdDate = new Date();
                Collection taskMatches = crttwd.getTaskMatches();
                for (ChangeReportTaskMatch taskMatch : taskMatches) {
                    ChangeReportTaskMatchType matchType = taskMatch.getMatchType();
                    if (matchType == ChangeReportTaskMatchType.Match) {
                        boolean autoGen = this.atsApi.getTaskService().isAutoGen(taskMatch.getTaskWf());
                        boolean deReferenced = this.atsApi.getTaskService().isAutoGenDeReferenced(taskMatch.getTaskWf());
                        if (!autoGen || deReferenced) {
                            this.crtd.getResults().success(ChangeReportTaskMatchResult.TaskExistsNeedsDereference.getName(), new Object[]{taskMatch.getTaskWf().toStringWithId()});
                            taskMatch.setMatchResult(ChangeReportTaskMatchResult.TaskExistsNeedsDereference);
                            if (changes == null) continue;
                            this.atsApi.getTaskService().removeDeReferencedNote(taskMatch.getTaskWf(), changes);
                            continue;
                        }
                        this.crtd.getResults().logf(ChangeReportTaskMatchResult.TaskExistsNoChangeNeeded.getName(), new Object[]{taskMatch.getTaskWf().toStringWithId()});
                        taskMatch.setMatchResult(ChangeReportTaskMatchResult.TaskExistsNoChangeNeeded);
                        continue;
                    }
                    if (matchType == ChangeReportTaskMatchType.ChgRptTskCompAsNeeded) {
                        if (addModTaskNames.contains(taskMatch.getTaskName())) continue;
                        this.crtd.getResults().success(ChangeReportTaskMatchResult.CreateNewChgRptTask.getName(), new Object[]{taskMatch.getTaskName()});
                        this.addToNewTaskData(this.crtd, crttwd, taskMatch, createdDate);
                        addModTaskNames.add(taskMatch.getTaskName());
                        taskMatch.setMatchResult(ChangeReportTaskMatchResult.CreateNewChgRptTask);
                        continue;
                    }
                    if (matchType == ChangeReportTaskMatchType.StaticTskCompAsNeeded) {
                        if (addModTaskNames.contains(taskMatch.getTaskName())) continue;
                        this.crtd.getResults().success(ChangeReportTaskMatchResult.CreateNewStaticTask.getName(), new Object[]{taskMatch.getTaskName()});
                        this.addToNewTaskData(this.crtd, crttwd, taskMatch, createdDate);
                        addModTaskNames.add(taskMatch.getTaskName());
                        taskMatch.setMatchResult(ChangeReportTaskMatchResult.CreateNewStaticTask);
                        continue;
                    }
                    if (matchType == ChangeReportTaskMatchType.AdditionalTskCompAsNeeded) {
                        this.crtd.getResults().success(ChangeReportTaskMatchResult.CreateNewAdditionalTask.getName(), new Object[]{taskMatch.getTaskName()});
                        this.addToNewTaskData(this.crtd, crttwd, taskMatch, createdDate);
                        addModTaskNames.add(taskMatch.getTaskName());
                        taskMatch.setMatchResult(ChangeReportTaskMatchResult.CreateNewAdditionalTask);
                        continue;
                    }
                    if (matchType == ChangeReportTaskMatchType.TaskRefAttrMissing || matchType == ChangeReportTaskMatchType.TaskRefAttrButNoRefChgArt) {
                        if (deletedTaskNames.contains(taskMatch.getTaskName())) continue;
                        this.crtd.getResults().success(ChangeReportTaskMatchResult.NoMatchArtTaskCanBeDeleted.getName(), new Object[]{taskMatch.getTaskWf().toStringWithId()});
                        taskMatch.setMatchResult(ChangeReportTaskMatchResult.NoMatchArtTaskCanBeDeleted);
                        if (!reportOnly) {
                            if (changes == null) {
                                this.crtd.getResults().errorf("AtsChangeSet can not be null.", new Object[0]);
                            } else {
                                this.atsApi.getTaskService().addDeReferencedNote(taskMatch.getTaskWf(), changes);
                            }
                        }
                        deletedTaskNames.add(taskMatch.getTaskName());
                        continue;
                    }
                    this.crtd.getResults().errorf(ChangeReportTaskMatchResult.UnhandledMatchType.getName(), new Object[]{taskMatch.getMatchType().name()});
                    taskMatch.setMatchResult(ChangeReportTaskMatchResult.UnhandledMatchType);
                }
                if (!reportOnly && !((NewTaskData)crttwd.getNewTaskSet().getNewTaskDatas().iterator().next()).getTasks().isEmpty()) {
                    crttwd.getNewTaskSet().setAsUserId(this.crtd.getAsUser().getUserId());
                    crttwd.getNewTaskSet().setCommitComment("Create Change Report Tasks");
                    if (destTeamWf != null) {
                        newTaskData.setTeamWfId(destTeamWf.getId());
                    }
                    CreateTasksOperation operation = new CreateTasksOperation(crttwd.getNewTaskSet(), this.atsApi);
                    operation.setIdToTeamWf(this.crtd.getIdToTeamWf());
                    operation.validate();
                    if (this.crtd.getResults().isSuccess()) {
                        operation.run(changes);
                        if (this.crtd.getResults().isErrors()) {
                            return this.crtd;
                        }
                    }
                }
                XResultTable table = new XResultTable();
                rd.getTables().add(table);
                if (destTeamWf != null) {
                    table.setName(String.valueOf(destTeamWf.getTeamDefinition().getName()) + " - " + destTeamWf.toStringWithId());
                } else {
                    table.setName(String.valueOf(toTeamDef.getName()) + " - <new team wf>");
                }
                List columns = table.getColumns();
                columns.add(new XResultTableColumn(Columns.ChgRptArtName.name(), Columns.ChgRptArtName.name(), 200, XResultTableDataType.String));
                columns.add(new XResultTableColumn(Columns.ChgRptArtId.name(), Columns.ChgRptArtId.name(), 80, XResultTableDataType.Integer));
                columns.add(new XResultTableColumn(Columns.ChgRptArtType.name(), Columns.ChgRptArtType.name(), 200, XResultTableDataType.String));
                columns.add(new XResultTableColumn(Columns.ComputedTaskName.name(), Columns.ComputedTaskName.name(), 200, XResultTableDataType.String));
                columns.add(new XResultTableColumn(Columns.MatchType.name(), Columns.MatchType.name(), 200, XResultTableDataType.String));
                columns.add(new XResultTableColumn(Columns.Action.name(), Columns.Action.name(), 200, XResultTableDataType.String));
                for (ChangeReportTaskMatch taskMatch : crttwd.getTaskMatches()) {
                    String safeName = "";
                    if (taskMatch.getChgRptArt().isValid()) {
                        safeName = this.atsApi.getStoreService().getSafeName(taskMatch.getChgRptArt(), this.crtd.getWorkOrParentBranchId());
                    }
                    table.getRows().add(new XResultTableRow(new String[]{taskMatch.getChgRptArtName(), taskMatch.getChgRptArt().getIdString(), safeName, taskMatch.getTaskName(), taskMatch.getMatchType().name(), taskMatch.getMatchResult() != null ? taskMatch.getMatchResult().getDisplayName() : "None"}));
                }
            }
            if (reportOnly) {
                return this.crtd;
            }
            if (changes != null) {
                if (this.crtd.isFinalTaskGen()) {
                    changes.addTag((IAtsObject)hostTeamWf, "finalTaskgen");
                    this.crtd.getResults().logf("Setting %s\n", new Object[]{"finalTaskgen"});
                }
                TransactionToken transId = changes.executeIfNeeded();
                this.crtd.getResults().log("\n");
                if (transId != null && transId.isValid()) {
                    this.crtd.setTransaction((TransactionId)transId);
                    this.crtd.setIds(changes.getIds());
                    this.crtd.getResults().success("Tasks Updated\n", new Object[0]);
                } else {
                    this.crtd.getResults().success("No Changes Needed\n", new Object[0]);
                }
            }
        }
        catch (Exception ex) {
            this.crtd.results.errorf("Exception creating tasks %s", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
        return this.crtd;
    }

    private void addIfDebug(String format, Object ... data) {
        if (this.crtd.isDebug()) {
            this.crtd.getResults().logf(format, data);
        }
    }

    private IAtsActionableItem getToSiblingAi(CreateTasksDefinition setDef, IAtsProgram program, XResultData rd, ChangeReportOptionsToTeam toSiblingTeamDef) {
        IAtsActionableItem toSiblingAi = null;
        toSiblingAi = Strings.isNumeric((String)toSiblingTeamDef.getAiId()) ? this.atsApi.getActionableItemService().getActionableItem(toSiblingTeamDef.getAiId()) : this.getAiFromWorkType(setDef, program, rd, toSiblingTeamDef.getWorkType());
        return toSiblingAi;
    }

    private IAtsActionableItem getAiFromWorkType(CreateTasksDefinition setDef, IAtsProgram program, XResultData rd, WorkType workType) {
        if (workType == null) {
            rd.errorf("Team Definition and Work Type invalid in CreateTaskDefinition\n", new Object[0]);
            return null;
        }
        Collection ais = this.atsApi.getProgramService().getAis(program, workType);
        if (ais.size() == 0) {
            rd.errorf("No Actionable Item of Work Type [%s] found\n", new Object[]{setDef.getChgRptOptions().getFromSiblingTeamDefWorkType()});
            return null;
        }
        if (ais.size() > 1) {
            for (IAtsActionableItem ai : ais) {
                if (!ai.hasTag(TASK_GEN_TAG)) continue;
                return ai;
            }
            rd.errorf("Multiple Actionable Item of Work Type [%s] found, only one should be\n", new Object[]{setDef.getChgRptOptions().getFromSiblingTeamDefWorkType()});
            return null;
        }
        return (IAtsActionableItem)ais.iterator().next();
    }

    private IAtsTeamDefinition getToTeamDef(CreateTasksDefinition setDef, IAtsProgram program, XResultData rd, ChangeReportOptionsToTeam toSiblingTeamDef) {
        TeamDefinition toTeamDef = null;
        if (Strings.isNumeric((String)toSiblingTeamDef.getTeamId())) {
            toTeamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById(ArtifactId.valueOf((String)toSiblingTeamDef.getTeamId()));
        } else {
            WorkType workType = toSiblingTeamDef.getWorkType();
            toTeamDef = this.getTeamDefFromWorkType(setDef, program, rd, workType);
        }
        return toTeamDef;
    }

    private IAtsTeamDefinition getFromSiblingTeamDef(CreateTasksDefinition setDef, IAtsProgram program, XResultData rd) {
        ArtifactToken fromTeamDefTok = setDef.getChgRptOptions().getFromSiblingTeamDef();
        TeamDefinition fromTeamDef = null;
        if (fromTeamDefTok == null) {
            WorkType workType = setDef.getChgRptOptions().getFromSiblingTeamDefWorkType();
            fromTeamDef = this.getTeamDefFromWorkType(setDef, program, rd, workType);
        } else {
            fromTeamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById((ArtifactId)fromTeamDefTok);
        }
        return fromTeamDef;
    }

    private IAtsTeamDefinition getTeamDefFromWorkType(CreateTasksDefinition setDef, IAtsProgram program, XResultData rd, WorkType workType) {
        if (workType == null) {
            rd.errorf("Team Definition and Work Type invalid in CreateTaskDefinition\n", new Object[0]);
            return null;
        }
        Collection teamDefs = this.atsApi.getProgramService().getTeamDefs(program, workType);
        if (teamDefs.size() == 0) {
            rd.errorf("No Team Definitions of Work Type [%s] found\n", new Object[]{setDef.getChgRptOptions().getFromSiblingTeamDefWorkType()});
            return null;
        }
        if (teamDefs.size() > 1) {
            for (IAtsTeamDefinition teamDef : teamDefs) {
                if (!teamDef.hasTag(TASK_GEN_TAG)) continue;
                return teamDef;
            }
            rd.errorf("Multiple Team Definitions of Work Type [%s] found, only one should be\n", new Object[]{setDef.getChgRptOptions().getFromSiblingTeamDefWorkType()});
            return null;
        }
        return (IAtsTeamDefinition)teamDefs.iterator().next();
    }

    private void addToNewTaskData(ChangeReportTaskData crtd, ChangeReportTaskTeamWfData crttwd, ChangeReportTaskMatch taskMatch, Date createdDate) {
        JaxAtsTask task = new JaxAtsTask();
        task.setName(taskMatch.getTaskName());
        if (taskMatch.getMatchType() == ChangeReportTaskMatchType.StaticTskCompAsNeeded) {
            StaticTaskDefinition createTaskDef = taskMatch.getCreateTaskDef();
            LinkedList<ArtifactId> assigneeeAccountIds = new LinkedList<ArtifactId>();
            for (Long id : createTaskDef.getAssigneeAccountIds()) {
                assigneeeAccountIds.add(ArtifactId.valueOf((Long)id));
            }
            task.setAssigneeAccountIds(assigneeeAccountIds);
            if (Strings.isValid((String)createTaskDef.getDescription())) {
                task.setDescription(createTaskDef.getDescription());
            }
            if (Strings.isValid((String)createTaskDef.getRelatedToState())) {
                task.setRelatedToState(createTaskDef.getRelatedToState());
            }
        } else if (taskMatch.getMatchType() == ChangeReportTaskMatchType.AdditionalTskCompAsNeeded) {
            task.setAssigneeAccountIds(Arrays.asList(SystemUser.UnAssigned));
            task.setDescription("see title");
        } else if (taskMatch.getMatchType() == ChangeReportTaskMatchType.ChgRptTskCompAsNeeded) {
            if (taskMatch.isChgRptArtValid()) {
                task.addAttribute((AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactName, (Object)taskMatch.getChgRptArtName());
                task.addAttribute((AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactDeleted, (Object)taskMatch.isChgRptArtDeleted());
                task.addAttribute((AttributeTypeToken)AtsAttributeTypes.TaskToChangedArtifactReference, (Object)ArtifactId.create((Id)taskMatch.getChgRptArt()));
            }
            task.setAssigneeUserIds(Arrays.asList(AtsCoreUsers.UNASSIGNED_USER.getUserId()));
        } else {
            crtd.getResults().errorf("Un-handled MatchType [%s]...Aborting\n", new Object[]{taskMatch.getMatchType().name()});
            return;
        }
        task.setCreatedDate(createdDate);
        task.setCreatedByUserId(AtsCoreUsers.SYSTEM_USER.getUserId());
        AutoGenVersion ver = null;
        List<IAtsTaskProvider> taskProviders = AtsTaskProviderCollector.getTaskProviders();
        for (IAtsTaskProvider provider : taskProviders) {
            ver = provider.getAutoGenTaskVersionToSet(crtd, crttwd, taskMatch);
            if (ver != null) break;
        }
        if (ver == null) {
            crtd.getResults().errorf("No provider configured to set TaskAutoGenVersion, aborting...", new Object[0]);
            return;
        }
        task.addAttribute((AttributeTypeToken)AtsAttributeTypes.TaskAutoGenVersion, (Object)ver.getName());
        task.addAttribute((AttributeTypeToken)AtsAttributeTypes.TaskAutoGen, (Object)true);
        for (IAtsTaskProvider provider : AtsTaskProviderCollector.getTaskProviders()) {
            provider.addToAutoGeneratingTask(crtd, crttwd, taskMatch, task);
        }
        ((NewTaskData)crttwd.getNewTaskSet().getNewTaskDatas().iterator().next()).getTasks().add(task);
    }

    protected CreateTasksDefinition getTaskDefinition() {
        return this.atsApi.getTaskSetDefinitionProviderService().getTaskSetDefinition(this.taskDefToken).getCreateTasksDef();
    }

    protected Collection<AttributeTypeId> getAttributeTypesToIgnore() {
        return Collections.castAll((Collection)this.getTaskDefinition().getChgRptOptions().getNotAttributeTypes());
    }

    public static enum Columns {
        ChgRptArtId,
        ChgRptArtType,
        ChgRptArtName,
        ComputedTaskName,
        MatchType,
        Action;

    }
}

