/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.review;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationEventFactory;
import org.eclipse.osee.ats.api.notify.AtsNotifyType;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewRoleManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.PeerToPeerReviewState;
import org.eclipse.osee.ats.api.review.ReviewRequiredMinimum;
import org.eclipse.osee.ats.api.review.ReviewRole;
import org.eclipse.osee.ats.api.review.ReviewRoleType;
import org.eclipse.osee.ats.api.review.UserRole;
import org.eclipse.osee.ats.api.review.UserRoleError;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.user.IAtsUserService;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAttributeResolver;
import org.eclipse.osee.ats.api.workdef.WidgetStatus;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class UserRoleManager
implements IAtsPeerReviewRoleManager {
    protected static final String ROLE_ITEM_TAG = "Role";
    private final Matcher roleMatcher = Pattern.compile("<Role>(.*?)</Role>", 40).matcher("");
    protected final IAtsUserService userService;
    protected final IAttributeResolver attrResolver;
    protected final IAtsPeerToPeerReview peerRev;
    protected final AtsApi atsApi;
    private final CountingMap<ReviewRole> actualCountMap;
    private final CountingMap<ReviewRoleType> actualTypeCountMap;
    private final Map<ReviewRoleType, Integer> expectedRoleTypeMap;
    private final Map<ReviewRole, Integer> expectedRoleMap;
    private final List<ReviewRequiredMinimum> reviewRequiredMinimums;
    private List<UserRole> roles;

    public UserRoleManager(IAtsPeerToPeerReview peerRev, AtsApi atsApi) {
        this.atsApi = atsApi;
        this.attrResolver = atsApi.getAttributeResolver();
        this.userService = atsApi.getUserService();
        this.peerRev = peerRev;
        this.expectedRoleTypeMap = peerRev.getWorkDefinition().getReviewRoleTypeMap();
        this.expectedRoleMap = peerRev.getWorkDefinition().getReviewRoleMap();
        this.reviewRequiredMinimums = peerRev.getWorkDefinition().getReviewRequiredMinimums();
        this.actualTypeCountMap = new CountingMap();
        for (UserRole userRole : this.getUserRoles()) {
            this.actualTypeCountMap.put((Object)userRole.getRole().getReviewRoleType());
        }
        this.actualCountMap = new CountingMap();
        for (UserRole userRole : this.getUserRoles()) {
            this.actualCountMap.put((Object)userRole.getRole());
        }
    }

    public void ensureLoaded() {
        if (this.roles == null) {
            this.roles = new ArrayList<UserRole>();
            if (this.attrResolver != null) {
                for (String xml : this.attrResolver.getAttributesToStringList((IAtsObject)this.peerRev, (AttributeTypeToken)AtsAttributeTypes.Role)) {
                    this.roleMatcher.reset(xml);
                    while (this.roleMatcher.find()) {
                        UserRole item = new UserRole(this.roleMatcher.group(), this.peerRev.getWorkDefinition());
                        this.roles.add(item);
                    }
                }
            }
        }
    }

    public List<UserRole> getUserRoles() {
        this.ensureLoaded();
        return this.roles;
    }

    public List<UserRole> getUserRoles(ReviewRole role) {
        ArrayList<UserRole> roles = new ArrayList<UserRole>();
        for (UserRole uRole : this.getUserRoles()) {
            if (!uRole.getRole().equals((Object)role)) continue;
            roles.add(uRole);
        }
        return roles;
    }

    public List<AtsUser> getRoleUsers(ReviewRole role) {
        ArrayList<AtsUser> users = new ArrayList<AtsUser>();
        for (UserRole uRole : this.getUserRoles()) {
            if (!uRole.getRole().equals((Object)role) || users.contains(this.userService.getUserByUserId(uRole.getUserId()))) continue;
            users.add(this.userService.getUserByUserId(uRole.getUserId()));
        }
        return users;
    }

    public List<AtsUser> getRoleUsers(Collection<UserRole> roles) {
        ArrayList<AtsUser> users = new ArrayList<AtsUser>();
        for (UserRole uRole : roles) {
            if (users.contains(this.userService.getUserByUserId(uRole.getUserId()))) continue;
            users.add(this.userService.getUserByUserId(uRole.getUserId()));
        }
        return users;
    }

    public UserRoleError validateRoleTypeMinimums(StateDefinition fromStateDef, IAtsPeerReviewRoleManager roleMgr) {
        UserRoleError rError = this.validateRoleMinimums();
        UserRoleError reqError = this.validateReviewRequiredMinimums();
        if (!rError.getName().equals(UserRoleError.None.name())) {
            return rError;
        }
        if (!reqError.getName().equals(UserRoleError.None.name())) {
            return reqError;
        }
        if (fromStateDef.getName().equals(PeerToPeerReviewState.Review.getName()) || fromStateDef.getName().equals(PeerToPeerReviewState.Meeting.getName())) {
            for (UserRole uRole : roleMgr.getUserRoles()) {
                if (uRole.getHoursSpent() != null) continue;
                return UserRoleError.HoursSpentMustBeEnteredForEachRole;
            }
        }
        return UserRoleError.None;
    }

    public UserRoleError validateReviewRequiredMinimums() {
        return this.validateReviewRequiredMinimum(this.peerRev, this.reviewRequiredMinimums);
    }

    public UserRoleError validateReviewRequiredMinimum(IAtsPeerToPeerReview peerRev, List<ReviewRequiredMinimum> reviewRequiredMinimums) {
        StringBuilder userRoleError = new StringBuilder();
        for (ReviewRequiredMinimum reviewRequiredMinimum : reviewRequiredMinimums) {
            int actualCount;
            if (peerRev.getParentTeamWorkflow() == null || reviewRequiredMinimum.getParentTeamDef() == null || !peerRev.getParentTeamWorkflow().getTeamDefinition().equals(reviewRequiredMinimum.getParentTeamDef()) || (actualCount = this.actualCountMap.get((Object)reviewRequiredMinimum.getReviewRole())) >= reviewRequiredMinimum.getMin()) continue;
            userRoleError.append(String.format("Must have minimum of %s [%s], not %s. \n", reviewRequiredMinimum.getMin(), reviewRequiredMinimum.getReviewRole().getName(), actualCount).toString());
        }
        if (userRoleError.toString().isEmpty()) {
            return UserRoleError.None;
        }
        return new UserRoleError("MustMeetMinimumRole", userRoleError.toString(), WidgetStatus.Invalid_Incompleted);
    }

    private UserRoleError validateRoleMinimums() {
        for (Map.Entry<ReviewRole, Integer> expectedEntry : this.expectedRoleMap.entrySet()) {
            int expectedCount;
            ReviewRole role = expectedEntry.getKey();
            int actualCount = this.actualCountMap.get((Object)role);
            if (role.equals((Object)ReviewRole.Reviewer)) {
                actualCount += this.actualCountMap.get((Object)ReviewRole.ModeratorReviewer);
            }
            if (role.equals((Object)ReviewRole.Moderator)) {
                actualCount += this.actualCountMap.get((Object)ReviewRole.ModeratorReviewer);
            }
            if (actualCount >= (expectedCount = expectedEntry.getValue().intValue())) continue;
            return new UserRoleError("MustMeetMinimumRoleType", String.format("Must have minimum of %s [%s], not %s", expectedCount, expectedEntry.getKey(), actualCount), WidgetStatus.Invalid_Incompleted);
        }
        return UserRoleError.None;
    }

    public boolean isMinimumForRoleCountValid(ReviewRoleType reviewType) {
        int expectedRoleTypeMapCount;
        int n = expectedRoleTypeMapCount = this.expectedRoleTypeMap.get(reviewType) == null ? 0 : this.expectedRoleTypeMap.get(reviewType);
        return this.actualTypeCountMap.get((Object)reviewType) >= expectedRoleTypeMapCount;
    }

    public void addOrUpdateUserRole(UserRole userRole, IAtsChangeSet changes) {
        List<UserRole> roleItems = this.getUserRoles();
        boolean found = false;
        for (UserRole uRole : roleItems) {
            if (!userRole.equals((Object)uRole)) continue;
            uRole.update(userRole, this.peerRev.getWorkDefinition());
            found = true;
        }
        if (!found) {
            roleItems.add(userRole);
            if (!this.peerRev.getAssignees().contains(UserRoleManager.getUser(userRole, this.atsApi))) {
                changes.addAssignee((IAtsWorkItem)this.peerRev, UserRoleManager.getUser(userRole, this.atsApi));
            }
            for (UserRole uRole : roleItems) {
                AtsUser user = this.atsApi.getUserService().getUserByUserId(uRole.getUserId());
                changes.addAssignee((IAtsWorkItem)this.peerRev, user);
            }
        }
    }

    public void removeUserRole(UserRole userRole) {
        List<UserRole> roleItems = this.getUserRoles();
        roleItems.remove(userRole);
    }

    private List<UserRole> getStoredUserRoles() {
        ArrayList<UserRole> storedUserRoles = new ArrayList<UserRole>();
        for (IAttribute attr : this.atsApi.getAttributeResolver().getAttributes((IAtsObject)this.peerRev, (AttributeTypeToken)AtsAttributeTypes.Role)) {
            UserRole storedRole = new UserRole((String)attr.getValue(), this.peerRev.getWorkDefinition());
            storedUserRoles.add(storedRole);
        }
        return storedUserRoles;
    }

    public void saveToArtifact(IAtsChangeSet changes) {
        try {
            List<UserRole> storedUserRoles = this.getStoredUserRoles();
            for (IAttribute attr : this.atsApi.getAttributeResolver().getAttributes((IAtsObject)this.peerRev, (AttributeTypeToken)AtsAttributeTypes.Role)) {
                UserRole storedRole = new UserRole((String)attr.getValue(), this.peerRev.getWorkDefinition());
                for (UserRole pItem : this.getUserRoles()) {
                    if (!pItem.equals((Object)storedRole)) continue;
                    changes.setAttribute((IAtsWorkItem)this.peerRev, (AttributeId)attr, (Object)AXml.addTagData((String)ROLE_ITEM_TAG, (String)pItem.toXml()));
                }
            }
            List<UserRole> userRoles = this.getUserRoles();
            List<UserRole> updatedStoredUserRoles = this.getStoredUserRoles();
            for (UserRole delUserRole : Collections.setComplement(updatedStoredUserRoles, userRoles)) {
                for (IAttribute attr : this.atsApi.getAttributeResolver().getAttributes((IAtsObject)this.peerRev, (AttributeTypeToken)AtsAttributeTypes.Role)) {
                    UserRole storedRole = new UserRole((String)attr.getValue(), this.peerRev.getWorkDefinition());
                    if (!storedRole.equals((Object)delUserRole)) continue;
                    changes.deleteAttribute((IAtsWorkItem)this.peerRev, attr);
                }
            }
            for (UserRole newRole : Collections.setComplement(userRoles, updatedStoredUserRoles)) {
                changes.addAttribute((IAtsObject)this.peerRev, (AttributeTypeToken)AtsAttributeTypes.Role, (Object)AXml.addTagData((String)ROLE_ITEM_TAG, (String)newRole.toXml()));
            }
            this.atsApi.getReviewService().updateHoursSpentRoles(this.peerRev, changes);
            this.validateUserRolesCompleted(storedUserRoles, userRoles, changes);
        }
        catch (OseeCoreException ex) {
            this.atsApi.getLogger().error((Throwable)ex, "Can't create ats review role document", new Object[0]);
        }
    }

    private void validateUserRolesCompleted(List<UserRole> currentUserRoles, List<UserRole> newUserRoles, IAtsChangeSet changes) {
        int numCurrentCompleted = 0;
        int numNewCompleted = 0;
        for (UserRole role : newUserRoles) {
            if (!role.getRole().getReviewRoleType().equals((Object)ReviewRoleType.Reviewer)) continue;
            if (!role.isCompleted()) {
                return;
            }
            ++numNewCompleted;
        }
        for (UserRole role : currentUserRoles) {
            if (!role.getRole().getReviewRoleType().equals((Object)ReviewRoleType.Reviewer) || !role.isCompleted()) continue;
            ++numCurrentCompleted;
        }
        if (numNewCompleted != numCurrentCompleted) {
            try {
                changes.addWorkItemNotificationEvent(AtsNotificationEventFactory.getWorkItemNotificationEvent((AtsUser)this.atsApi.getUserService().getCurrentUser(), (IAtsWorkItem)this.peerRev, (AtsNotifyType[])new AtsNotifyType[]{AtsNotifyType.Peer_Reviewers_Completed}));
            }
            catch (OseeCoreException ex) {
                this.atsApi.getLogger().error((Throwable)ex, "Error adding ATS Notification Event", new Object[0]);
            }
        }
    }

    public static AtsUser getUser(UserRole item, AtsApi atsApi) {
        return atsApi.getUserService().getUserByUserId(item.getUserId());
    }

    public WorkDefinition getWorkDefinition() {
        return this.peerRev.getWorkDefinition();
    }
}

