/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.core.column.model.AtsCoreCodeColumn;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class UserArtIdColumn
extends AtsCoreCodeColumn {
    private final AtsCoreCodeColumnToken colToken;

    public UserArtIdColumn(AtsCoreCodeColumnToken colToken, AtsApi atsApi) {
        super(colToken, atsApi);
        this.colToken = colToken;
    }

    @Override
    protected String getText(IAtsObject atsObject) throws Exception {
        AtsUser user;
        if (atsObject instanceof IAtsWorkItem && (user = UserArtIdColumn.getUserArtIdName(this.colToken.getAttrType(), atsObject, this.atsApi)) != null) {
            return user.getName();
        }
        return null;
    }

    public static AtsUser getUserArtIdName(AttributeTypeToken attrType, Object obj, AtsApi atsApi) {
        if (obj instanceof IAtsWorkItem) {
            String userArtId;
            if (attrType.isLong()) {
                Long userArtId2 = (Long)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)((IAtsWorkItem)obj), attrType, (Object)0L);
                if (userArtId2 > 0L) {
                    return atsApi.getUserService().getUserById(ArtifactId.valueOf((Long)userArtId2));
                }
            } else if (attrType.isArtifactId()) {
                ArtifactId userArtId3 = (ArtifactId)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)((IAtsWorkItem)obj), attrType, (Object)ArtifactId.SENTINEL);
                if (userArtId3.isValid()) {
                    return atsApi.getUserService().getUserById(userArtId3);
                }
            } else if (attrType.isString() && Strings.isNumeric((String)(userArtId = (String)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)((IAtsWorkItem)obj), attrType, null)))) {
                return atsApi.getUserService().getUserById(ArtifactId.valueOf((String)userArtId));
            }
            return null;
        }
        return null;
    }
}

