/*********************************************************************
 * Copyright (c) 2023 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.testscript;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.testscript.internal.TestCaseToken;

/**
 * @author Stephen J. Molaro
 */
public interface TestCaseApi {

   TestCaseToken get(BranchId branch, ArtifactId scriptDefTypeId);

   Collection<TestCaseToken> getAll(BranchId branch);

   Collection<TestCaseToken> getAll(BranchId branch, ArtifactId viewId);

   Collection<TestCaseToken> getAll(BranchId branch, AttributeTypeId orderByAttribute);

   Collection<TestCaseToken> getAll(BranchId branch, ArtifactId viewId, AttributeTypeId orderByAttribute);

   Collection<TestCaseToken> getAll(BranchId branch, long pageNum, long pageSize);

   Collection<TestCaseToken> getAll(BranchId branch, ArtifactId viewId, long pageNum, long pageSize);

   Collection<TestCaseToken> getAll(BranchId branch, long pageNum, long pageSize, AttributeTypeId orderByAttribute);

   Collection<TestCaseToken> getAll(BranchId branch, ArtifactId viewId, long pageNum, long pageSize,
      AttributeTypeId orderByAttribute);

   Collection<TestCaseToken> getAllByFilter(BranchId branch, String filter);

   Collection<TestCaseToken> getAllByFilter(BranchId branch, ArtifactId viewId, String filter);

   Collection<TestCaseToken> getAllByFilter(BranchId branch, String filter, AttributeTypeId orderByAttribute);

   Collection<TestCaseToken> getAllByFilter(BranchId branch, ArtifactId viewId, String filter,
      AttributeTypeId orderByAttribute);

   Collection<TestCaseToken> getAllByFilter(BranchId branch, String filter, long pageNum, long pageSize);

   Collection<TestCaseToken> getAllByFilter(BranchId branch, ArtifactId viewId, String filter, long pageNum,
      long pageSize);

   Collection<TestCaseToken> getAllByFilter(BranchId branch, String filter, long pageNum, long pageSize,
      AttributeTypeId orderByAttribute);

   Collection<TestCaseToken> getAllByFilter(BranchId branch, ArtifactId viewId, String filter, long pageNum,
      long pageSize, AttributeTypeId orderByAttribute);

   int getCountWithFilter(BranchId branch, ArtifactId viewId, String filter);
}
