/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.api.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileTeam;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.config.AtsViews;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.program.JaxProgram;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.ColorColumns;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.framework.core.data.ArtifactId;

public class AtsConfigurations {
    private AtsViews views = new AtsViews();
    private ColorColumns colorColumns = new ColorColumns();
    ArtifactId topActionableItem;
    ArtifactId topTeamDefinition;
    private Collection<String> validStateNames = new ArrayList<String>();
    private Map<Long, ActionableItem> idToAi = new HashMap<Long, ActionableItem>();
    private Map<Long, TeamDefinition> idToTeamDef = new HashMap<Long, TeamDefinition>();
    private Map<Long, Version> idToVersion = new HashMap<Long, Version>();
    private Map<Long, AtsUser> idToUser = new HashMap<Long, AtsUser>();
    private Map<String, AtsUser> loginIdToUser = new HashMap<String, AtsUser>();
    private Map<Long, JaxProgram> idToProgram = new HashMap<Long, JaxProgram>();
    private Map<Long, JaxAgileTeam> idToAgileTeam = new HashMap<Long, JaxAgileTeam>();
    private Map<Long, JaxAgileFeatureGroup> idToAgileFeature = new HashMap<Long, JaxAgileFeatureGroup>();
    private Map<String, Long> userIdToUserArtId = new HashMap<String, Long>();
    private Map<String, Long> userNameToUserArtId = new HashMap<String, Long>();
    private Map<Long, Long> teamDefToAgileTeam = new HashMap<Long, Long>();
    private Map<Long, Long> teamDefToProgram = new HashMap<Long, Long>();
    private Map<Long, Long> featureToAgileTeam = new HashMap<Long, Long>();
    private Map<String, String> atsConfig = new HashMap<String, String>();

    public AtsViews getViews() {
        return this.views;
    }

    public void setViews(AtsViews views) {
        this.views = views;
    }

    public ColorColumns getColorColumns() {
        return this.colorColumns;
    }

    public void setColorColumns(ColorColumns colorColumns) {
        this.colorColumns = colorColumns;
    }

    @JsonIgnore
    public Collection<AtsUser> getUsers() {
        return this.idToUser.values();
    }

    public Collection<String> getValidStateNames() {
        return this.validStateNames;
    }

    public void setValidStateNames(Collection<String> validStateNames) {
        this.validStateNames = validStateNames;
    }

    public Map<Long, ActionableItem> getIdToAi() {
        return this.idToAi;
    }

    public void setIdToAi(Map<Long, ActionableItem> idToAi) {
        this.idToAi = idToAi;
    }

    public Map<Long, TeamDefinition> getIdToTeamDef() {
        return this.idToTeamDef;
    }

    public void setIdToTeamDef(Map<Long, TeamDefinition> idToTeamDef) {
        this.idToTeamDef = idToTeamDef;
    }

    public Map<Long, Version> getIdToVersion() {
        return this.idToVersion;
    }

    public void setIdToVersion(Map<Long, Version> idToVersion) {
        this.idToVersion = idToVersion;
    }

    public ArtifactId getTopActionableItem() {
        return this.topActionableItem;
    }

    public void setTopActionableItem(ArtifactId topActionableItem) {
        this.topActionableItem = topActionableItem;
    }

    public ArtifactId getTopTeamDefinition() {
        return this.topTeamDefinition;
    }

    public void setTopTeamDefinition(ArtifactId topTeamDefinition) {
        this.topTeamDefinition = topTeamDefinition;
    }

    public void addTeamDef(TeamDefinition teamDef) {
        this.idToTeamDef.put(teamDef.getId(), teamDef);
    }

    public void addAi(ActionableItem ai) {
        this.idToAi.put(ai.getId(), ai);
    }

    public void addVersion(Version version) {
        this.idToVersion.put(version.getId(), version);
    }

    public TeamDefinition getTeamDef(IAtsTeamDefinition teamDef) {
        if (teamDef instanceof TeamDefinition) {
            return (TeamDefinition)teamDef;
        }
        return this.idToTeamDef.get(teamDef.getId());
    }

    public Map<Long, AtsUser> getIdToUser() {
        return this.idToUser;
    }

    public void setIdToUser(Map<Long, AtsUser> idToUser) {
        this.idToUser = idToUser;
    }

    public void addUser(AtsUser user) {
        this.idToUser.put(user.getId(), user);
        this.userIdToUserArtId.put(user.getUserId(), user.getArtifactId().getId());
        this.userNameToUserArtId.put(user.getName(), user.getArtifactId().getId());
        for (String loginId : user.getLoginIds()) {
            this.loginIdToUser.put(loginId, user);
        }
    }

    public Map<String, Long> getUserIdToUserArtId() {
        return this.userIdToUserArtId;
    }

    public void setUserIdToUserArtId(Map<String, Long> userIdToUserArtId) {
        this.userIdToUserArtId = userIdToUserArtId;
    }

    public Map<String, Long> getUserNameToUserArtId() {
        return this.userNameToUserArtId;
    }

    public void setUserNameToUserArtId(Map<String, Long> userNameToUserArtId) {
        this.userNameToUserArtId = userNameToUserArtId;
    }

    public Map<String, String> getAtsConfig() {
        return this.atsConfig;
    }

    public void setAtsConfig(Map<String, String> atsConfig) {
        this.atsConfig = atsConfig;
    }

    public void addAtsConfig(String key, String value) {
        this.atsConfig.put(key, value);
    }

    @JsonIgnore
    public String getConfigValue(String key) {
        return this.atsConfig.get(key);
    }

    public Map<Long, Long> getTeamDefToAgileTeam() {
        return this.teamDefToAgileTeam;
    }

    public void setTeamDefToAgileTeam(Map<Long, Long> teamDefToAgileTeam) {
        this.teamDefToAgileTeam = teamDefToAgileTeam;
    }

    public Map<Long, JaxAgileTeam> getIdToAgileTeam() {
        return this.idToAgileTeam;
    }

    public void setIdToAgileTeam(Map<Long, JaxAgileTeam> idToAgileTeam) {
        this.idToAgileTeam = idToAgileTeam;
    }

    public Map<Long, JaxAgileFeatureGroup> getIdToAgileFeature() {
        return this.idToAgileFeature;
    }

    public void setIdToAgileFeature(Map<Long, JaxAgileFeatureGroup> idToAgileFeature) {
        this.idToAgileFeature = idToAgileFeature;
    }

    public Map<Long, Long> getFeatureToAgileTeam() {
        return this.featureToAgileTeam;
    }

    public void setFeatureToAgileTeam(Map<Long, Long> featureToAgileTeam) {
        this.featureToAgileTeam = featureToAgileTeam;
    }

    public Map<Long, JaxProgram> getIdToProgram() {
        return this.idToProgram;
    }

    public void setIdToProgram(Map<Long, JaxProgram> idToProgram) {
        this.idToProgram = idToProgram;
    }

    public Map<Long, Long> getTeamDefToProgram() {
        return this.teamDefToProgram;
    }

    public void setTeamDefToProgram(Map<Long, Long> teamDefToProgram) {
        this.teamDefToProgram = teamDefToProgram;
    }

    public Map<String, AtsUser> getLoginIdToUser() {
        return this.loginIdToUser;
    }

    public void setLoginIdToUser(Map<String, AtsUser> loginIdToUser) {
        this.loginIdToUser = loginIdToUser;
    }
}

