/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.tracker;

import org.apache.aries.util.tracker.InternalRecursiveBundleTracker;
import org.apache.aries.util.tracker.hook.BundleHookBundleTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public final class RecursiveBundleTracker {
    private static final int COMPOSITE_BUNDLE_MASK = 62;
    private final BundleTracker tracker;
    private final BundleTracker compositeTracker;

    public RecursiveBundleTracker(BundleContext context, int stateMask, BundleTrackerCustomizer customizer) {
        if ((stateMask & 0x3E) != 62) {
            throw new IllegalArgumentException();
        }
        BundleTracker tracker = null;
        try {
            tracker = new BundleHookBundleTracker(context, stateMask, customizer);
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.compositeTracker = RecursiveBundleTracker.areMultipleFrameworksAvailable(context) ? new InternalRecursiveBundleTracker(context, stateMask, customizer, tracker == null) : null;
        if (tracker == null && this.compositeTracker == null) {
            tracker = new BundleTracker(context, stateMask, customizer);
        }
        this.tracker = tracker;
    }

    private static boolean areMultipleFrameworksAvailable(BundleContext context) {
        ServiceReference sr = context.getServiceReference("org.osgi.service.framework.CompositeBundleFactory");
        return sr != null;
    }

    public void open() {
        if (this.tracker != null) {
            this.tracker.open();
        }
        if (this.compositeTracker != null) {
            this.compositeTracker.open();
        }
    }

    public void close() {
        if (this.tracker != null) {
            this.tracker.close();
        }
        if (this.compositeTracker != null) {
            this.compositeTracker.close();
        }
    }
}

