/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.jdk.core.util.time.GlobalTime;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.jdbc.JdbcTransaction;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.accessor.UpdatePreviousTxCurrent;
import org.eclipse.osee.orcs.db.internal.callable.CreateBranchDatabaseTxCallable;

public final class BranchCopyTxCallable
extends JdbcTransaction {
    private final CreateBranchData branchData;
    private static final String SELECT_ADDRESSING = "SELECT gamma_id, mod_type, app_id FROM osee_txs txs WHERE txs.branch_id = ? AND txs.transaction_id = ?";
    private final JdbcClient jdbcClient;
    private final IdentityManager idManager;
    private final UserService userService;
    private final OrcsTokenService tokenService;
    private final Long buildVersionId;

    public BranchCopyTxCallable(JdbcClient jdbcClient, IdentityManager idManager, UserService userService, CreateBranchData branchData, Long buildVersionId, OrcsTokenService tokenService) {
        this.jdbcClient = jdbcClient;
        this.branchData = branchData;
        this.idManager = idManager;
        this.userService = userService;
        this.tokenService = tokenService;
        this.buildVersionId = buildVersionId;
    }

    public void handleTxWork(JdbcConnection connection) {
        new CreateBranchDatabaseTxCallable(this.jdbcClient, this.idManager, this.userService, this.branchData, this.buildVersionId, this.tokenService).handleTxWork(connection);
        Timestamp timestamp = GlobalTime.GreenwichMeanTimestamp();
        TransactionId nextTransactionId = this.idManager.getNextTransactionId();
        String creationComment = this.branchData.getCreationComment();
        this.jdbcClient.runPreparedUpdate(connection, OseeDb.TX_DETAILS_TABLE.getInsertSql(), new Object[]{this.branchData.getBranch(), nextTransactionId, this.userService.getUser(), timestamp, creationComment, TransactionDetailsType.NonBaselined.getId(), -1, OseeCodeVersion.getVersionId()});
        this.populateTransaction(0.3, connection, nextTransactionId, this.branchData.getParentBranch(), this.branchData.getSavedTransaction());
        UpdatePreviousTxCurrent updater = new UpdatePreviousTxCurrent(this.jdbcClient, connection, this.branchData.getBranch());
        updater.updateTxNotCurrentsFromTx(nextTransactionId);
    }

    private void populateTransaction(double workAmount, JdbcConnection connection, TransactionId intoTx, BranchId parentBranch, TransactionId copyTxId) {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        HashSet<Long> gammas = new HashSet<Long>(100000);
        this.populateAddressingToCopy(connection, data, intoTx, gammas, SELECT_ADDRESSING, parentBranch, copyTxId);
        if (!data.isEmpty()) {
            this.jdbcClient.runBatchUpdate(connection, OseeDb.TXS_TABLE.getInsertSql(), data);
        }
    }

    private void populateAddressingToCopy(JdbcConnection connection, List<Object[]> data, TransactionId baseTxId, HashSet<Long> gammas, String query, Object ... parameters) {
        try (JdbcStatement chStmt = this.jdbcClient.getStatement(connection);){
            chStmt.runPreparedQueryWithMaxFetchSize(query, parameters);
            while (chStmt.next()) {
                Long gamma = chStmt.getLong("gamma_id");
                if (gammas.contains(gamma)) continue;
                ModificationType modType = ModificationType.valueOf((long)chStmt.getInt("mod_type"));
                Long app_id = chStmt.getLong("app_id");
                TxCurrent txCurrent = TxCurrent.getCurrent((ModificationType)modType);
                data.add(new Object[]{this.branchData.getBranch(), gamma, baseTxId, txCurrent, modType, app_id});
                gammas.add(gamma);
            }
        }
    }
}

