/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.IAtsDecisionReview;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLog;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.ats.core.model.impl.AtsObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class WorkItem
extends AtsObject
implements IAtsWorkItem {
    protected final ArtifactToken artifact;
    private IAtsLog atsLog;
    protected final AtsApi atsApi;
    protected final Log logger;
    IAtsTeamWorkflow parentTeamWf;
    IAtsAction parentAction;
    private final ArtifactTypeToken artifactType;
    private WorkDefinition workDef;

    public WorkItem(Log logger, AtsApi atsApi, ArtifactToken artifact, ArtifactTypeToken artifactType) {
        super(artifact.getName(), artifact.getId());
        this.logger = logger;
        this.atsApi = atsApi;
        this.artifact = artifact;
        this.artifactType = artifactType;
        this.setStoreObject(artifact);
    }

    @Override
    public String getDescription() {
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.Description, (Object)"");
    }

    public List<AtsUser> getAssignees() {
        return this.atsApi.getWorkItemService().getAssignees((IAtsWorkItem)this);
    }

    public String getAtsId() {
        try {
            return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.AtsId, (Object)this.getIdString());
        }
        catch (OseeCoreException oseeCoreException) {
            return null;
        }
    }

    public IAtsTeamWorkflow getParentTeamWorkflow() {
        if (this.isTeamWorkflow()) {
            return (IAtsTeamWorkflow)this;
        }
        if (this.parentTeamWf == null) {
            ArtifactReadable teamArt = ArtifactReadable.SENTINEL;
            if (this.isTeamWorkflow()) {
                teamArt = this.artifact;
            } else if (this.isReview()) {
                teamArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)this.artifact, AtsRelationTypes.TeamWorkflowToReview_TeamWorkflow);
            } else if (this.isTask()) {
                teamArt = this.atsApi.getRelationResolver().getRelatedOrSentinel((ArtifactId)this.artifact, AtsRelationTypes.TeamWfToTask_TeamWorkflow);
            }
            if (teamArt.isValid()) {
                this.parentTeamWf = this.atsApi.getWorkItemService().getTeamWf((ArtifactToken)teamArt);
            }
        }
        return this.parentTeamWf;
    }

    public IAtsAction getParentAction() {
        if (this.parentAction == null) {
            Collection results;
            ArtifactToken actionArt = null;
            IAtsTeamWorkflow teamWf = this.getParentTeamWorkflow();
            if (teamWf != null && !(results = this.atsApi.getRelationResolver().getRelated((ArtifactId)teamWf.getStoreObject(), AtsRelationTypes.ActionToWorkflow_Action)).isEmpty()) {
                actionArt = (ArtifactToken)results.iterator().next();
            }
            if (actionArt != null) {
                this.parentAction = this.atsApi.getWorkItemService().getAction(actionArt);
            }
        }
        return this.parentAction;
    }

    public boolean isReview() {
        return this instanceof IAtsAbstractReview;
    }

    public boolean isGoal() {
        return this instanceof IAtsGoal;
    }

    public IAtsLog getLog() {
        if (this.atsLog == null) {
            try {
                this.atsLog = this.atsApi.getLogFactory().getLogLoaded((IAtsWorkItem)this, this.atsApi.getAttributeResolver());
            }
            catch (OseeCoreException ex) {
                this.logger.error((Throwable)ex, "Error getting Log for artifact[%s]", new Object[]{this.artifact});
            }
        }
        return this.atsLog;
    }

    public WorkDefinition getWorkDefinition() {
        if (this.workDef == null) {
            this.workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((IAtsWorkItem)this);
        }
        return this.workDef;
    }

    public StateDefinition getStateDefinition() {
        String currentStateName = this.atsApi.getWorkItemService().getCurrentStateName((IAtsWorkItem)this);
        if (currentStateName == null) {
            return null;
        }
        return this.getWorkDefinition().getStateByName(currentStateName);
    }

    public StateDefinition getStateDefinitionByName(String name) {
        return this.getWorkDefinition().getStateByName(name);
    }

    public boolean isTask() {
        return this instanceof IAtsTask;
    }

    public boolean isTeamWorkflow() {
        return this instanceof IAtsTeamWorkflow;
    }

    @Override
    public ArtifactToken getStoreObject() {
        super.getStoreObject();
        return this.atsApi.getQueryService().getArtifact((ArtifactId)this.artifact);
    }

    public AtsUser getCreatedBy() {
        String userId = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.CreatedBy, null);
        return this.atsApi.getUserService().getUserByUserId(userId);
    }

    public Date getCreatedDate() {
        return (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.CreatedDate, null);
    }

    public AtsUser getCompletedBy() {
        String userId = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.CompletedBy, null);
        return this.atsApi.getUserService().getUserByUserId(userId);
    }

    public AtsUser getCancelledBy() {
        String userId = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.CancelledBy, null);
        return this.atsApi.getUserService().getUserByUserId(userId);
    }

    public String getCompletedFromState() {
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.CompletedFromState, null);
    }

    public String getCancelledFromState() {
        return (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.CancelledFromState, null);
    }

    public String getArtifactTypeName() {
        return this.artifactType.getName();
    }

    public Date getCompletedDate() {
        return (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.CompletedDate, null);
    }

    public Date getCancelledDate() {
        return (Date)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.CancelledDate, null);
    }

    public String getCancelledReason() {
        String ret = this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.CancelledReason, "");
        if (Strings.isInValid((String)ret)) {
            ret = this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.CancelledReasonEnum, "");
        }
        return ret;
    }

    public boolean isInWork() {
        return this.getCurrentStateType().isWorking();
    }

    public boolean isCompleted() {
        return ((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, (Object)StateType.Working.name())).equals(StateType.Completed.name());
    }

    public boolean isCompletedOrCancelled() {
        return this.isCompleted() || this.isCancelled();
    }

    public boolean isCancelled() {
        return ((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)this, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, (Object)StateType.Working.name())).equals(StateType.Cancelled.name());
    }

    public List<AtsUser> getImplementers() {
        return this.atsApi.getImplementerService().getImplementers((IAtsObject)this);
    }

    public boolean isDecisionReview() {
        return this instanceof IAtsDecisionReview;
    }

    public boolean isPeerReview() {
        return this instanceof IAtsPeerToPeerReview;
    }

    public void clearCaches() {
        this.parentAction = null;
        this.atsLog = null;
        this.atsApi.getWorkDefinitionService().internalClearWorkDefinition((IAtsWorkItem)this);
    }

    public String getCurrentStateName() {
        return this.atsApi.getWorkItemService().getCurrentStateName((IAtsWorkItem)this);
    }

    public StateType getCurrentStateType() {
        return StateType.valueOf((String)((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)this.artifact, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, (Object)StateType.Working.name())));
    }

    public IStateToken getCurrentState() {
        return this.getWorkDefinition().getStateByName(this.getCurrentStateName());
    }

    public AtsUser getUserByUserId(String userId) {
        return AtsApiService.get().getUserService().getUserByUserId(userId);
    }
}

