/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workdef.operations;

import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.workdef.model.CompositeLayoutItem;
import org.eclipse.osee.ats.api.workdef.model.LayoutItem;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WidgetDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class ValidateWorkDefinitionsOperation {
    private final AtsApi atsApi;

    public ValidateWorkDefinitionsOperation(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData run() {
        XResultData rd = new XResultData();
        this.validateWidgetsAndAttrs(rd);
        this.validateWorkDefReferences(rd);
        this.validateNoMissingWorkDefRefs(rd);
        return rd;
    }

    private void validateNoMissingWorkDefRefs(XResultData rd) {
        rd.log("\n\nValidating Missing Work Definition Reference attrs...");
        for (ArtifactToken art : this.atsApi.getQueryService().createQuery(WorkItemType.TeamWorkflow, new WorkItemType[0]).andNotExists((AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference).getResultArtifacts().getList()) {
            rd.errorf("Work Def Ref NOT exists for Id = %s\n", new Object[]{art.getIdString()});
        }
    }

    private void validateWorkDefReferences(XResultData rd) {
        rd.log("\n\nValidating (tx_current==1) Work Definition Reference attrs...");
        List query = this.atsApi.getQueryService().query("SELECT DISTINCT(attr.value) FROM osee_attribute attr, osee_txs txs WHERE \ntxs.branch_id = 570 and attr.gamma_id = txs.gamma_id \nAND txs.tx_current = 1 AND attr.ATTR_TYPE_ID = " + AtsAttributeTypes.WorkflowDefinitionReference.getIdString(), new Object[0]);
        for (Map entry : query) {
            String idStr = (String)entry.values().iterator().next();
            Long id = Long.valueOf(idStr);
            WorkDefinition workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition(id);
            if (workDef == null) {
                rd.errorf("Work Def Id = %s - InValid\n", new Object[]{idStr});
                continue;
            }
            rd.logf("Work Def Id = %s - Valid\n", new Object[]{idStr});
        }
    }

    private void validateWidgetsAndAttrs(XResultData rd) {
        rd.log("Validating Work Definition widgets and widget attrs...");
        for (WorkDefinition workDef : this.atsApi.getWorkDefinitionService().getAllWorkDefinitions()) {
            rd.logf("Validating workDef [%s]\n", new Object[]{workDef.getName()});
            rd.logf("--- Validating header\n", new Object[0]);
            for (LayoutItem layoutItem : workDef.getHeaderDef().getLayoutItems()) {
                this.validateLayoutItem(layoutItem, rd);
            }
            for (StateDefinition stateDef : workDef.getStates()) {
                rd.logf("--- Validating state [%s]\n", new Object[]{stateDef.getName()});
                for (LayoutItem layoutItem : stateDef.getLayoutItems()) {
                    this.validateLayoutItem(layoutItem, rd);
                }
            }
        }
    }

    private void validateLayoutItem(LayoutItem layoutItem, XResultData rd) {
        if (layoutItem instanceof WidgetDefinition) {
            WidgetDefinition widgetDef = (WidgetDefinition)layoutItem;
            AttributeTypeToken attrTypeTok = widgetDef.getAttributeType();
            if (attrTypeTok != null) {
                AttributeTypeGeneric attrType = this.atsApi.tokenService().getAttributeType(attrTypeTok.getId());
                if (attrType == null) {
                    rd.errorf("------ Type %s for widget %s is not valid.\n", new Object[]{attrTypeTok.toStringWithId(), widgetDef.toStringWithId()});
                } else {
                    rd.logf("------ Type %s for widget %s\n", new Object[]{attrTypeTok.isValid() ? attrTypeTok.toStringWithId() : "N/A", widgetDef.toStringWithId()});
                }
            }
        } else if (layoutItem instanceof CompositeLayoutItem) {
            CompositeLayoutItem comp = (CompositeLayoutItem)layoutItem;
            for (LayoutItem compLayoutItem : comp.getLayoutItems()) {
                this.validateLayoutItem(compLayoutItem, rd);
            }
        }
    }
}

