/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.column.AtsColumnTokensDefault;
import org.eclipse.osee.ats.api.column.AtsCoreCodeColumnToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.model.AtsCoreCodeColumn;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;

public class PercentCompleteTasksColumn
extends AtsCoreCodeColumn {
    public PercentCompleteTasksColumn(AtsApi atsApi) {
        super((AtsCoreCodeColumnToken)AtsColumnTokensDefault.PercentCompleteTasksColumn, atsApi);
    }

    @Override
    public String getText(IAtsObject atsObject) throws Exception {
        if (atsObject.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow, AtsArtifactTypes.Action})) {
            return String.valueOf(PercentCompleteTasksColumn.getPercentCompleteFromTasks(atsObject, this.atsApi));
        }
        return "";
    }

    public static int getPercentCompleteFromTasks(IAtsObject atsObject, AtsApi atsApi) {
        if (atsObject.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
            IAtsAction action = (IAtsAction)atsObject;
            double percent = 0.0;
            for (IAtsTeamWorkflow teamWf : action.getTeamWorkflows()) {
                if (teamWf.isCancelled()) continue;
                percent += (double)PercentCompleteTasksColumn.getPercentCompleteFromTasks(teamWf, atsApi);
            }
            if (percent == 0.0) {
                return 0;
            }
            Double rollPercent = percent / (double)action.getTeamWorkflows().size();
            return rollPercent.intValue();
        }
        if (atsObject.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            return PercentCompleteTasksColumn.getPercentCompleteFromTasks((IAtsTeamWorkflow)atsObject, atsApi);
        }
        return 0;
    }

    public static int getPercentCompleteFromTasks(IAtsTeamWorkflow teamWf, AtsApi atsApi) {
        int spent = 0;
        int result = 0;
        Collection tasks = atsApi.getTaskService().getTasks(teamWf);
        for (IAtsTask task : tasks) {
            spent += atsApi.getWorkItemMetricsService().getPercentCompleteTotal((IAtsObject)task);
        }
        if (spent > 0) {
            result = spent / tasks.size();
        }
        return result;
    }
}

