/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.jdk.core.util.Lib;

public class BacklogOperations {
    private final AtsApi atsApi;

    public BacklogOperations(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public XResultData sort(ArtifactToken backlog, String comment) {
        XResultData rd = new XResultData();
        try {
            ElapsedTime time = new ElapsedTime("Sort Backlog", false, false);
            IAgileBacklog bLog = this.atsApi.getAgileService().getAgileBacklog((ArtifactId)backlog);
            time.logPoint("Load Backlog");
            Collection items = this.atsApi.getAgileService().getItems(bLog);
            time.logPoint("Load Items");
            ArrayList<IAgileItem> sItems = new ArrayList<IAgileItem>();
            for (IAgileItem aItem : items) {
                if (aItem == null) {
                    rd.errorf("Backlog item == null\n", new Object[0]);
                    continue;
                }
                sItems.add(aItem);
            }
            time.logPoint("Start Sort");
            Collections.sort(sItems, new NoSprintCompCancelledComparator(rd).thenComparing(new NoSprintCompCancelledComparator(rd).thenComparing(new SprintComparator(rd)).thenComparing(new CompCancelledComparator(rd))));
            time.logPoint("End Sort");
            ArrayList<ArtifactToken> arts = new ArrayList<ArtifactToken>();
            for (IAgileItem aItem : sItems) {
                arts.add(aItem.getStoreObject());
            }
            time.logPoint("Commit");
            IAtsChangeSet changes = this.atsApi.createChangeSet(comment);
            changes.setRelationsAndOrder((Object)backlog, AtsRelationTypes.Goal_Member, arts);
            time.logPoint("Commit End");
            TransactionToken transaction = changes.executeIfNeeded();
            rd.setTxId(transaction.getIdString());
            time.end();
        }
        catch (Exception ex) {
            rd.errorf("Error: Exception sorting backlog %s: %s", new Object[]{backlog.toStringWithId(), Lib.exceptionToString((Exception)ex)});
        }
        return rd;
    }

    private class CompCancelledComparator
    implements Comparator<IAgileItem> {
        private final XResultData rd;

        public CompCancelledComparator(XResultData rd) {
            this.rd = rd;
        }

        @Override
        public int compare(IAgileItem a1, IAgileItem a2) {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                try {
                                    IAgileSprint sprint1 = BacklogOperations.this.atsApi.getAgileService().getSprint(a1);
                                    IAgileSprint sprint2 = BacklogOperations.this.atsApi.getAgileService().getSprint(a2);
                                    if (sprint1 != null || sprint2 != null) break block7;
                                    return 0;
                                }
                                catch (Exception ex) {
                                    this.rd.errorf("SprintComparator exception: %s\n", new Object[]{Lib.exceptionToString((Exception)ex)});
                                    return 0;
                                }
                            }
                            if (!a1.getCurrentStateType().isCancelled()) break block8;
                            return -1;
                        }
                        if (!a2.getCurrentStateType().isCancelled()) break block9;
                        return 1;
                    }
                    if (!a1.getCurrentStateType().isCompleted()) break block10;
                    return -1;
                }
                if (!a2.getCurrentStateType().isCompleted()) break block11;
                return 1;
            }
            return -1 * a1.getCurrentStateName().compareTo(a2.getCurrentStateName());
        }
    }

    private class NoSprintCompCancelledComparator
    implements Comparator<IAgileItem> {
        private final XResultData rd;

        public NoSprintCompCancelledComparator(XResultData rd) {
            this.rd = rd;
        }

        @Override
        public int compare(IAgileItem a1, IAgileItem a2) {
            IAgileSprint sprint2;
            block6: {
                IAgileSprint sprint1;
                block5: {
                    sprint1 = BacklogOperations.this.atsApi.getAgileService().getSprint(a1);
                    sprint2 = BacklogOperations.this.atsApi.getAgileService().getSprint(a2);
                    if (sprint1 != null || !a1.getCurrentStateType().isCompletedOrCancelled() || sprint2 != null || !a2.getCurrentStateType().isCompletedOrCancelled()) break block5;
                    return 0;
                }
                if (sprint1 != null || !a1.getCurrentStateType().isCompletedOrCancelled()) break block6;
                return -1;
            }
            try {
                if (sprint2 == null && a2.getCurrentStateType().isCompletedOrCancelled()) {
                    return 1;
                }
            }
            catch (Exception ex) {
                this.rd.errorf("NoSprintCompCancelledComparator exception: %s\n", new Object[]{Lib.exceptionToString((Exception)ex)});
            }
            return 0;
        }
    }

    private class SprintComparator
    implements Comparator<IAgileItem> {
        private final XResultData rd;

        public SprintComparator(XResultData rd) {
            this.rd = rd;
        }

        @Override
        public int compare(IAgileItem a1, IAgileItem a2) {
            IAgileSprint sprint2;
            IAgileSprint sprint1;
            block7: {
                block6: {
                    block5: {
                        try {
                            sprint1 = BacklogOperations.this.atsApi.getAgileService().getSprint(a1);
                            sprint2 = BacklogOperations.this.atsApi.getAgileService().getSprint(a2);
                            if (sprint1 != null || sprint2 != null) break block5;
                            return 0;
                        }
                        catch (Exception ex) {
                            this.rd.errorf("SprintComparator exception: %s\n", new Object[]{Lib.exceptionToString((Exception)ex)});
                            return 0;
                        }
                    }
                    if (sprint1 != null) break block6;
                    return 1;
                }
                if (sprint2 != null) break block7;
                return -1;
            }
            return sprint1.getName().compareTo(sprint2.getName());
        }
    }
}

