/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.testscript.ScriptSetApi;
import org.eclipse.osee.testscript.ScriptSetEndpoint;
import org.eclipse.osee.testscript.internal.ScriptSetToken;

public class ScriptSetEndpointImpl
implements ScriptSetEndpoint {
    private final ScriptSetApi scriptSetApi;
    private final BranchId branch;

    public ScriptSetEndpointImpl(BranchId branch, ScriptSetApi scriptProgramApi) {
        this.scriptSetApi = scriptProgramApi;
        this.branch = branch;
    }

    @Override
    public Collection<ScriptSetToken> getAllScriptSets(String filter, ArtifactId viewId, long pageNum, long pageSize, AttributeTypeToken orderByAttributeType, boolean activeOnly) {
        ArtifactId artifactId = viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        if (Strings.isValid((String)filter)) {
            return this.scriptSetApi.getAllByFilter(this.branch, viewId, filter, pageNum, pageSize, (AttributeTypeId)orderByAttributeType, activeOnly);
        }
        return this.scriptSetApi.getAll(this.branch, viewId, pageNum, pageSize, (AttributeTypeId)orderByAttributeType, activeOnly);
    }

    @Override
    public ScriptSetToken getScriptProgram(ArtifactId ScriptProgramId) {
        return this.scriptSetApi.get(this.branch, ScriptProgramId);
    }

    @Override
    public int getCount(String filter, ArtifactId viewId) {
        return this.scriptSetApi.getCountWithFilter(this.branch, viewId, filter);
    }
}

