/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;
import org.eclipse.osee.testscript.internal.ScriptResultToken;

public class ScriptDefToken
extends ArtifactAccessorResultWithoutGammas {
    public static final ScriptDefToken SENTINEL = new ScriptDefToken();
    private final Comparator<Date> dateComparator = new DateComparator();
    private String fullScriptName;
    private Date executionDate;
    private String executionEnvironment;
    private String machine;
    private String revision;
    private String repositoryType;
    private String team;
    private String lastAuthor;
    private Date lastModified;
    private String modifiedFlag;
    private String repositoryUrl;
    private String property;
    private String notes;
    private boolean safety;
    private boolean scheduled;
    private Date scheduledTime;
    private String scheduledMachine;
    private String statusBy;
    private Date statusDate;
    private String subsystem;
    private String description;
    private String latestProcessorId;
    private Date latestExecutionDate;
    private String latestExecutionEnvironment;
    private String latestMachineName;
    private int latestPassedCount;
    private int latestFailedCount;
    private int latestInteractiveCount;
    private boolean latestScriptAborted;
    private int latestElapsedTime;
    private String latestResult;
    private int latestScriptHealth;
    private String latestExecutedBy;
    private String latestUserId;
    private String latestUserName;
    private List<ScriptResultToken> scriptResults;

    public ScriptDefToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public ScriptDefToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setFullScriptName(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ScriptName, ""));
        this.setExecutionDate((Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ExecutionDate, (Object)new Date()));
        this.setExecutionEnvironment(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ExecutionEnvironment, ""));
        this.setMachineName(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.MachineName, ""));
        this.setRevision(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Revision, ""));
        this.setRepositoryType(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.RepositoryType, ""));
        this.setTeam(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.TeamName, ""));
        this.setLastAuthor(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.LastAuthor, ""));
        this.setLastModified((Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.LastModifiedDate, (Object)new Date()));
        this.setModifiedFlag(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ModifiedFlag, ""));
        this.setRepositoryUrl(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.RepositoryUrl, ""));
        this.setProperty(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.PropertyKey, ""));
        this.setNotes(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Notes, ""));
        this.setSafety((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Safety, (Object)false));
        this.setScheduled((Boolean)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Scheduled, (Object)false));
        this.setScheduledTime((Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ScheduledTime, (Object)new Date()));
        this.setScheduledMachine(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ScheduledMachine, ""));
        this.setStatusBy(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.StatusBy, ""));
        this.setStatusDate((Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.StatusDate, (Object)new Date()));
        this.setSubsystem(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.ScriptSubsystem, ""));
        this.setDescription(art.getSoleAttributeAsString((AttributeTypeToken)CoreAttributeTypes.Description, ""));
        this.setScriptResults(art.getRelated(CoreRelationTypes.TestScriptDefToTestScriptResults_TestScriptResults).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).sorted(Comparator.comparing(this::getExecutionDateByAttr, this.dateComparator)).filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new ScriptResultToken((ArtifactReadable)a)).collect(Collectors.toList()));
        if (!this.getScriptResults().isEmpty()) {
            ScriptResultToken resultToken = this.getScriptResults().get(0);
            this.setLatestProcessorId(resultToken.getProcessorId());
            this.setLatestExecutionDate(resultToken.getExecutionDate());
            this.setLatestExecutionEnvironment(resultToken.getExecutionEnvironment());
            this.setMachineName(resultToken.getMachineName());
            this.setLatestPassedCount(resultToken.getPassedCount());
            this.setLatestFailedCount(resultToken.getFailedCount());
            this.setLatestInteractiveCount(resultToken.getInteractiveCount());
            this.setLatestScriptAborted(resultToken.getScriptAborted());
            this.setLatestElapsedTime(resultToken.getElapsedTime());
            this.setLatestResult(resultToken.getResult());
            this.setLatestScriptHealth(resultToken.getScriptHealth());
            this.setLatestExecutedBy(resultToken.getExecutedBy());
            this.setLatestUserId(resultToken.getUserId());
            this.setLatestUserName(resultToken.getUserName());
        }
    }

    public ScriptDefToken(Long id, String name) {
        super(id, name);
        this.setFullScriptName("");
        this.setExecutionDate(new Date());
        this.setExecutionEnvironment("");
        this.setMachineName("");
        this.setRevision("");
        this.setRepositoryType("");
        this.setTeam("");
        this.setLastAuthor("");
        this.setLastModified(new Date());
        this.setModifiedFlag("");
        this.setRepositoryUrl("");
        this.setProperty("");
        this.setNotes("");
        this.setSafety(false);
        this.setScheduled(false);
        this.setScheduledTime(new Date());
        this.setScheduledMachine("");
        this.setStatusBy("");
        this.setStatusDate(new Date());
        this.setSubsystem("");
        this.setDescription("");
        this.setScriptResults(new ArrayList<ScriptResultToken>());
        this.setLatestProcessorId("");
        this.setLatestExecutionDate(new Date());
        this.setLatestExecutionEnvironment("");
        this.setMachineName("");
        this.setLatestPassedCount(0);
        this.setLatestFailedCount(0);
        this.setLatestInteractiveCount(0);
        this.setLatestScriptAborted(false);
        this.setLatestElapsedTime(0);
        this.setLatestResult("");
        this.setLatestScriptHealth(0);
        this.setLatestExecutedBy("");
        this.setLatestUserId("");
        this.setLatestUserName("");
    }

    public ScriptDefToken() {
    }

    public String getFullScriptName() {
        return this.fullScriptName;
    }

    public void setFullScriptName(String fullScriptName) {
        this.fullScriptName = fullScriptName;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(Date executionDate) {
        this.executionDate = executionDate;
    }

    public String getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public void setExecutionEnvironment(String executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public String getMachineName() {
        return this.machine;
    }

    public void setMachineName(String machine) {
        this.machine = machine;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String getRepositoryType() {
        return this.repositoryType;
    }

    public void setRepositoryType(String repositoryType) {
        this.repositoryType = repositoryType;
    }

    public String getTeam() {
        return this.team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public String getLastAuthor() {
        return this.lastAuthor;
    }

    public void setLastAuthor(String lastAuthor) {
        this.lastAuthor = lastAuthor;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getModified() {
        return this.modifiedFlag;
    }

    public void setModifiedFlag(String modified) {
        this.modifiedFlag = modified;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean getSafety() {
        return this.safety;
    }

    public void setSafety(boolean safety) {
        this.safety = safety;
    }

    public boolean getScheduled() {
        return this.scheduled;
    }

    public void setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
    }

    public Date getScheduledTime() {
        return this.scheduledTime;
    }

    public void setScheduledTime(Date scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public String getScheduledMachine() {
        return this.scheduledMachine;
    }

    public void setScheduledMachine(String scheduledMachine) {
        this.scheduledMachine = scheduledMachine;
    }

    public String getStatusBy() {
        return this.statusBy;
    }

    public void setStatusBy(String statusBy) {
        this.statusBy = statusBy;
    }

    public Date getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Date statusDate) {
        this.statusDate = statusDate;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        this.subsystem = subsystem;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLatestProcessorId() {
        return this.latestProcessorId;
    }

    public void setLatestProcessorId(String latestProcessorId) {
        this.latestProcessorId = latestProcessorId;
    }

    public Date getLatestExecutionDate() {
        return this.latestExecutionDate;
    }

    public void setLatestExecutionDate(Date latestExecutionDate) {
        this.latestExecutionDate = latestExecutionDate;
    }

    public String getLatestExecutionEnvironment() {
        return this.latestExecutionEnvironment;
    }

    public void setLatestExecutionEnvironment(String latestExecutionEnvironment) {
        this.latestExecutionEnvironment = latestExecutionEnvironment;
    }

    public String getLatestMachineName() {
        return this.latestMachineName;
    }

    public void setLatestMachineName(String latestMachine) {
        this.latestMachineName = latestMachine;
    }

    public int getLatestPassedCount() {
        return this.latestPassedCount;
    }

    public void setLatestPassedCount(int latestPassedCount) {
        this.latestPassedCount = latestPassedCount;
    }

    public int getLatestFailedCount() {
        return this.latestFailedCount;
    }

    public void setLatestFailedCount(int latestFailedCount) {
        this.latestFailedCount = latestFailedCount;
    }

    public int getLatestInteractiveCount() {
        return this.latestInteractiveCount;
    }

    public void setLatestInteractiveCount(int latestInteractiveCount) {
        this.latestInteractiveCount = latestInteractiveCount;
    }

    public boolean getLatestScriptAborted() {
        return this.latestScriptAborted;
    }

    public void setLatestScriptAborted(boolean latestScriptAborted) {
        this.latestScriptAborted = latestScriptAborted;
    }

    public int getLatestElapsedTime() {
        return this.latestElapsedTime;
    }

    public void setLatestElapsedTime(int latestElapsedTime) {
        this.latestElapsedTime = latestElapsedTime;
    }

    public String getLatestResult() {
        return this.latestResult;
    }

    public void setLatestResult(String latestResult) {
        this.latestResult = latestResult;
    }

    public int getLatestScriptHealth() {
        return this.latestScriptHealth;
    }

    public void setLatestScriptHealth(int latestScriptHealth) {
        this.latestScriptHealth = latestScriptHealth;
    }

    public String getLatestExecutedBy() {
        return this.latestExecutedBy;
    }

    public void setLatestExecutedBy(String latestExecutedBy) {
        this.latestExecutedBy = latestExecutedBy;
    }

    public String getLatestUserId() {
        return this.latestUserId;
    }

    public void setLatestUserId(String latestUserId) {
        this.latestUserId = latestUserId;
    }

    public String getLatestUserName() {
        return this.latestUserName;
    }

    public void setLatestUserName(String latestUserName) {
        this.latestUserName = latestUserName;
    }

    public List<ScriptResultToken> getScriptResults() {
        return this.scriptResults;
    }

    public void setScriptResults(List<ScriptResultToken> scriptResults) {
        this.scriptResults = scriptResults;
    }

    public CreateArtifact createArtifact(String key) {
        HashMap<Object, String> values = new HashMap<Object, String>();
        values.put(CoreAttributeTypes.Description, this.getDescription());
        values.put(CoreAttributeTypes.ExecutionDate, Long.toString(this.getExecutionDate().getTime()));
        values.put(CoreAttributeTypes.ExecutionEnvironment, this.getExecutionEnvironment());
        values.put(CoreAttributeTypes.LastAuthor, this.getLastAuthor());
        values.put(CoreAttributeTypes.LastModifiedDate, Long.toString(this.getLastModified().getTime()));
        values.put(CoreAttributeTypes.MachineName, this.getMachineName());
        values.put(CoreAttributeTypes.ModifiedFlag, this.getModified());
        values.put(CoreAttributeTypes.Notes, this.getNotes());
        values.put(CoreAttributeTypes.PropertyKey, this.getProperty());
        values.put(CoreAttributeTypes.RepositoryType, this.getRepositoryType());
        values.put(CoreAttributeTypes.RepositoryUrl, this.getRepositoryUrl());
        values.put(CoreAttributeTypes.Revision, this.getRevision());
        values.put(CoreAttributeTypes.Safety, Boolean.toString(this.getSafety()));
        values.put(CoreAttributeTypes.Scheduled, Boolean.toString(this.getScheduled()));
        values.put(CoreAttributeTypes.ScheduledMachine, this.getScheduledMachine());
        values.put(CoreAttributeTypes.ScheduledTime, Long.toString(this.getScheduledTime().getTime()));
        values.put(CoreAttributeTypes.ScriptName, this.getFullScriptName());
        values.put(CoreAttributeTypes.ScriptSubsystem, this.getSubsystem());
        values.put(CoreAttributeTypes.StatusBy, this.getStatusBy());
        values.put(CoreAttributeTypes.StatusDate, Long.toString(this.getStatusDate().getTime()));
        values.put(CoreAttributeTypes.TeamName, this.getTeam());
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.TestScriptDef.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.TestScriptDef.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }

    public Date getExecutionDateByAttr(ArtifactReadable art) {
        return (Date)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ExecutionDate);
    }

    public class DateComparator
    implements Comparator<Date> {
        @Override
        public int compare(Date date1, Date date2) {
            if (date1 == null && date2 == null) {
                return 0;
            }
            if (date1 == null) {
                return 1;
            }
            if (date2 == null) {
                return -1;
            }
            return date1.compareTo(date2);
        }
    }
}

