/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.testscript.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.accessor.types.ArtifactAccessorResultWithoutGammas;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeInteger;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.rest.model.transaction.Attribute;
import org.eclipse.osee.orcs.rest.model.transaction.CreateArtifact;
import org.eclipse.osee.testscript.internal.ErrorEntryToken;

public class LoggingSummaryToken
extends ArtifactAccessorResultWithoutGammas {
    public static final LoggingSummaryToken SENTINEL = new LoggingSummaryToken();
    private int summaryId;
    private int startNumber;
    private int informationalCount;
    private int minorCount;
    private int seriousCount;
    private int criticalCount;
    private int exceptionCount;
    private List<ErrorEntryToken> errorEntries;

    public LoggingSummaryToken(ArtifactToken art) {
        this((ArtifactReadable)art);
    }

    public LoggingSummaryToken(ArtifactReadable art) {
        super(art);
        this.setId(art.getId());
        this.setName(art.getName());
        this.setSummaryId((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.SummaryId, (Object)-1));
        this.setStartNumber((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.StartNumber, (Object)0));
        this.setInformationalCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.InformationalCount, (Object)0));
        this.setMinorCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.MinorCount, (Object)0));
        this.setSeriousCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.SeriousCount, (Object)0));
        this.setCriticalCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.CriticalCount, (Object)0));
        this.setExceptionCount((Integer)art.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.ExceptionCount, (Object)0));
        this.setErrorEntries(art.getRelated(CoreRelationTypes.LoggingSummaryToErrorEntry_ErrorEntry).getList().stream().filter(a -> a.getExistingAttributeTypes().isEmpty()).map(a -> new ErrorEntryToken((ArtifactReadable)a)).collect(Collectors.toList()));
    }

    public LoggingSummaryToken(Long id, String name) {
        super(id, name);
        this.setSummaryId(-1);
        this.setStartNumber(0);
        this.setInformationalCount(0);
        this.setMinorCount(0);
        this.setSeriousCount(0);
        this.setCriticalCount(0);
        this.setExceptionCount(0);
        this.setErrorEntries(new LinkedList<ErrorEntryToken>());
    }

    public LoggingSummaryToken() {
    }

    public int getSummaryId() {
        return this.summaryId;
    }

    public void setSummaryId(int summaryId) {
        this.summaryId = summaryId;
    }

    public int getStartNumber() {
        return this.startNumber;
    }

    public void setStartNumber(int startNumber) {
        this.startNumber = startNumber;
    }

    public int getInformationalCount() {
        return this.informationalCount;
    }

    public void setInformationalCount(int informationalCount) {
        this.informationalCount = informationalCount;
    }

    public int getMinorCount() {
        return this.minorCount;
    }

    public void setMinorCount(int minorCount) {
        this.minorCount = minorCount;
    }

    public int getSeriousCount() {
        return this.seriousCount;
    }

    public void setSeriousCount(int seriousCount) {
        this.seriousCount = seriousCount;
    }

    public int getCriticalCount() {
        return this.criticalCount;
    }

    public void setCriticalCount(int criticalCount) {
        this.criticalCount = criticalCount;
    }

    public int getExceptionCount() {
        return this.exceptionCount;
    }

    public void setExceptionCount(int exceptionCount) {
        this.exceptionCount = exceptionCount;
    }

    public List<ErrorEntryToken> getErrorEntries() {
        return this.errorEntries;
    }

    public void setErrorEntries(List<ErrorEntryToken> errorEntries) {
        this.errorEntries = errorEntries;
    }

    public CreateArtifact createArtifact(String key) {
        HashMap<AttributeTypeInteger, String> values = new HashMap<AttributeTypeInteger, String>();
        values.put(CoreAttributeTypes.SummaryId, Integer.toString(this.getSummaryId()));
        values.put(CoreAttributeTypes.StartNumber, Integer.toString(this.getStartNumber()));
        values.put(CoreAttributeTypes.InformationalCount, Integer.toString(this.getInformationalCount()));
        values.put(CoreAttributeTypes.MinorCount, Integer.toString(this.getMinorCount()));
        values.put(CoreAttributeTypes.SeriousCount, Integer.toString(this.getSeriousCount()));
        values.put(CoreAttributeTypes.CriticalCount, Integer.toString(this.getCriticalCount()));
        values.put(CoreAttributeTypes.ExceptionCount, Integer.toString(this.getExceptionCount()));
        CreateArtifact art = new CreateArtifact();
        art.setName(this.getName());
        art.setTypeId(CoreArtifactTypes.LoggingSummary.getIdString());
        LinkedList<Attribute> attrs = new LinkedList<Attribute>();
        for (AttributeTypeToken type : CoreArtifactTypes.LoggingSummary.getValidAttributeTypes()) {
            String value = (String)values.get(type);
            if (Strings.isInValid((String)value)) continue;
            Attribute attr = new Attribute(type.getIdString());
            attr.setValue(Arrays.asList(value));
            attrs.add(attr);
        }
        art.setAttributes(attrs);
        art.setkey(key);
        return art;
    }
}

