/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;

public class HealthUtils {
    private static final String GET_VALUE_SQL = "Select OSEE_VALUE FROM osee_info where OSEE_KEY = ?";
    public static final String OSEE_HEALTH_SERVERS_KEY = "osee.health.servers";
    public static final String OSEE_HEALTH_BALANCERS_KEY = "osee.health.balancers";
    public static final String OSEE_HEALTH_CURL_SERVER = "osee.health.curl.server";
    private static String errorMsg = "";

    private HealthUtils() {
    }

    public static String getOseeInfoValue(JdbcClient jdbcClient, String key) {
        String toReturn = (String)jdbcClient.fetch((Object)"", GET_VALUE_SQL, new Object[]{key});
        return toReturn;
    }

    public static List<String> getServers(JdbcClient jdbcClient) {
        ArrayList<String> servers = new ArrayList<String>();
        String serversStr = HealthUtils.getOseeInfoValue(jdbcClient, OSEE_HEALTH_SERVERS_KEY);
        serversStr = serversStr.replaceAll(" ", "");
        String[] stringArray = serversStr.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String server = stringArray[n2];
            servers.add(server);
            ++n2;
        }
        return servers;
    }

    public static List<String> getBalancers(JdbcClient jdbcClient) {
        ArrayList<String> balancers = new ArrayList<String>();
        String balancersStr = HealthUtils.getOseeInfoValue(jdbcClient, OSEE_HEALTH_BALANCERS_KEY);
        balancersStr = balancersStr.replaceAll(" ", "");
        String[] stringArray = balancersStr.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String balancer = stringArray[n2];
            balancers.add(balancer);
            ++n2;
        }
        return balancers;
    }

    public static String getImage(String imageName, String url) {
        return String.format("<a href=\"%s\" target=_blank><img src=\"/server/health/images/%s\"></img></a>", url, imageName);
    }

    public static boolean isCurlServerSet(JdbcClient jdbcClient) {
        String curlServer = HealthUtils.getOseeInfoValue(jdbcClient, OSEE_HEALTH_CURL_SERVER);
        return Strings.isValid((String)curlServer);
    }

    public static String getCurlExecUrl(String cmd, JdbcClient jdbcClient) {
        String curlServer = HealthUtils.getOseeInfoValue(jdbcClient, OSEE_HEALTH_CURL_SERVER);
        if (Strings.isInValid((String)curlServer)) {
            return "osee.health.curl.server not set in osee_info";
        }
        String urlStr = HealthUtils.getCurlUrl(curlServer, cmd);
        return urlStr;
    }

    public static String runCurlExecFromCurlServer(String cmd, JdbcClient jdbcClient, String auth) {
        String curlServer = HealthUtils.getOseeInfoValue(jdbcClient, OSEE_HEALTH_CURL_SERVER);
        if (Strings.isInValid((String)curlServer)) {
            return null;
        }
        String rStr = "";
        try {
            String urlStr = HealthUtils.getCurlUrl(curlServer, cmd);
            String results = HealthUtils.makeHttpRequestWithStringResult(urlStr, auth);
            if (results.contains("<html>cmd [ps -ef]")) {
                rStr = results;
            }
        }
        catch (Exception ex) {
            rStr = Lib.exceptionToString((Exception)ex);
        }
        return rStr;
    }

    private static String getCurlUrl(String curlServer, String cmd) {
        return String.format("http://%s/server/health/exec?cmd=%s", curlServer, cmd);
    }

    public static boolean isUrlReachable(String urlStr, String authId) {
        HealthUtils.clearErrorMsg();
        HttpURLConnection conn = null;
        try {
            URL url = new URL(urlStr);
            SSLContext sslContext = HealthUtils.getSSLContext();
            conn = (HttpURLConnection)url.openConnection();
            if (conn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(sslContext.getSocketFactory());
            }
            conn.setDoInput(true);
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Connection", "keep-alive");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Authorization", "Basic " + authId);
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            int responseCode = conn.getResponseCode();
            boolean bl = responseCode >= 200 && responseCode < 300;
            return bl;
        }
        catch (Exception ex) {
            HealthUtils.setErrorMsg("Exception occurred: " + ex.getMessage());
            return false;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String makeHttpRequestWithStringResult(String urlStr, String authId) {
        HealthUtils.clearErrorMsg();
        StringBuilder response = new StringBuilder();
        HttpURLConnection conn = null;
        try {
            try {
                URL url = new URL(urlStr);
                SSLContext sslContext = HealthUtils.getSSLContext();
                conn = (HttpURLConnection)url.openConnection();
                if (conn instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(sslContext.getSocketFactory());
                }
                conn.setDoInput(true);
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Connection", "keep-alive");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("Authorization", "Basic " + authId);
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                int responseCode = conn.getResponseCode();
                if (responseCode == 401) {
                    HealthUtils.setErrorMsg("401 Unauthorized error. AuthId: " + authId + ". ");
                }
                Throwable throwable = null;
                Object var8_16 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));){
                    String responseLine;
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException | KeyManagementException | NoSuchAlgorithmException ex) {
                block30: {
                    try {
                        Throwable throwable = null;
                        Object var6_10 = null;
                        try {
                            StringWriter sw = new StringWriter();
                            try {
                                try (PrintWriter pw = new PrintWriter(sw);){
                                    String stackTrace = sw.toString();
                                    HealthUtils.setErrorMsg("Exception occurred: " + ex.getMessage() + "\nStackTrace:\n" + stackTrace);
                                }
                                if (sw == null) break block30;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                if (sw == null) throw throwable;
                                sw.close();
                                throw throwable;
                            }
                            sw.close();
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                                throw throwable;
                            }
                            if (throwable == throwable4) throw throwable;
                            throwable.addSuppressed(throwable4);
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {
                        HealthUtils.setErrorMsg("StringWriter exception occurred: " + ex.getMessage());
                    }
                }
                if (conn == null) return response.toString();
                conn.disconnect();
                return response.toString();
            }
        }
        catch (Throwable throwable) {
            if (conn == null) throw throwable;
            conn.disconnect();
            throw throwable;
        }
        if (conn == null) return response.toString();
        conn.disconnect();
        return response.toString();
    }

    /*
     * Exception decompiling
     */
    public static <T> T makeHttpRequest(String urlStr, String authId, Class<T> responseType, T defaultValue) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SSLContext getSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        return sslContext;
    }

    public static void setErrorMsg(String message) {
        if (!errorMsg.isEmpty()) {
            errorMsg = String.valueOf(errorMsg) + "\n";
        }
        errorMsg = String.valueOf(errorMsg) + message;
    }

    public static void clearErrorMsg() {
        errorMsg = "";
    }

    public static String getErrorMsg() {
        return errorMsg;
    }
}

