/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.osee.activity.api.ActivityEntry;
import org.eclipse.osee.framework.core.data.CoreActivityTypes;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsApi;

public class HealthUsage {
    private final JdbcClient jdbcClient;
    private final OrcsApi orcsApi;
    private final List<User> allUsers = new ArrayList<User>();
    private final List<Session> allSessions = new ArrayList<Session>();
    private final Map<String, List<User>> versionTypeMap = new HashMap<String, List<User>>();
    private final Map<String, List<User>> versionNameMap = new HashMap<String, List<User>>();
    private String errorMsg = "";

    public HealthUsage(OrcsApi orcsApi, JdbcClient jdbcClient) {
        this.orcsApi = orcsApi;
        this.jdbcClient = jdbcClient;
    }

    public void calculateUsage() {
        Collection<ActivityEntry> entries = this.getUsageLogEntries();
        for (ActivityEntry entry : entries) {
            UserToken userTok = this.orcsApi.userService().getUser(entry.getAccountId());
            User user = new User(userTok.getName(), userTok.getEmail(), userTok.getUserId(), entry.getAccountId());
            if (!this.allUsers.stream().anyMatch(u -> u.getUserId() == user.getUserId())) {
                this.allUsers.add(user);
            }
            try {
                List<Object> users;
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = objectMapper.readTree(entry.getMessageArgs().substring(entry.getMessageArgs().indexOf("{")));
                String version = jsonNode.get("version").asText();
                String clientAddress = jsonNode.get("clientAddress").asText();
                String clientMachineName = jsonNode.get("clientMachineName").asText();
                String port = jsonNode.get("port").asText();
                String sessionId = jsonNode.get("sessionId").asText();
                Session session = new Session(user, entry.getStartTimestamp().toString(), version, sessionId, clientAddress, clientMachineName, port);
                this.allSessions.add(session);
                if (this.versionNameMap.containsKey(version)) {
                    users = this.versionNameMap.get(version);
                    if (!users.stream().anyMatch(u -> u.getUserId() == user.getUserId())) {
                        users.add(user);
                    }
                } else {
                    users = new ArrayList<User>();
                    users.add(user);
                    this.versionNameMap.put(version, users);
                }
                if (version.contains("-")) {
                    version = version.substring(version.indexOf("-"));
                }
                if (this.versionTypeMap.containsKey(version)) {
                    users = this.versionTypeMap.get(version);
                    if (users.stream().anyMatch(u -> u.getUserId() == user.getUserId())) continue;
                    users.add(user);
                    continue;
                }
                users = new ArrayList();
                users.add(user);
                this.versionTypeMap.put(version, users);
            }
            catch (Exception e) {
                this.errorMsg = String.valueOf(this.errorMsg) + "\n" + e.getMessage();
            }
        }
    }

    private Date getDatePreviousMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        return calendar.getTime();
    }

    private Collection<ActivityEntry> getUsageLogEntries() {
        Date date = this.getDatePreviousMonth();
        String query = "select * from osee_activity where type_id = " + CoreActivityTypes.IDE.getIdString() + " and trunc(start_timestamp) > '" + DateUtil.get((Date)date, (String)"dd_MMM_yyyy") + "' and msg_args like '%Session Created%' order by start_timestamp desc";
        ArrayList<ActivityEntry> logMsgs = new ArrayList<ActivityEntry>();
        Consumer<JdbcStatement> consumer = stmt -> {
            ActivityEntry entry = new ActivityEntry(Long.valueOf(stmt.getLong(1)));
            entry.setAccountId(Long.valueOf(stmt.getLong("account_id")));
            entry.setClientId(Long.valueOf(stmt.getLong("client_id")));
            entry.setDuration(Long.valueOf(stmt.getLong("duration")));
            entry.setMessageArgs(stmt.getString("msg_args"));
            entry.setParentId(Long.valueOf(stmt.getLong("parent_id")));
            entry.setServerId(Long.valueOf(stmt.getLong("server_id")));
            entry.setStartTime(Long.valueOf(stmt.getLong("start_time")));
            entry.setStartTimestamp(stmt.getTimestamp("start_timestamp"));
            entry.setStatus(Integer.valueOf(stmt.getInt("status")));
            entry.setTypeId(Long.valueOf(stmt.getLong("type_id")));
            logMsgs.add(entry);
        };
        this.jdbcClient.runQuery(consumer, query, new Object[0]);
        return logMsgs;
    }

    public List<User> getAllUsers() {
        return this.allUsers;
    }

    public List<Session> getAllSessions() {
        return this.allSessions;
    }

    public Map<String, List<User>> getVersionTypeMap() {
        return this.versionTypeMap;
    }

    public Map<String, List<User>> getVersionNameMap() {
        return this.versionNameMap;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public class Session {
        private final User user;
        private final String date;
        private final String version;
        private final String sessionId;
        private final String clientAddress;
        private final String clientMachineName;
        private final String port;

        public Session(User user, String date, String version, String sessionId, String clientAddress, String clientMachineName, String port) {
            this.user = user;
            this.date = date;
            this.version = version;
            this.sessionId = sessionId;
            this.port = port;
            this.clientAddress = clientAddress;
            this.clientMachineName = clientMachineName;
        }

        public User getUser() {
            return this.user;
        }

        public String getDate() {
            return this.date;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getClientAddress() {
            return this.clientAddress;
        }

        public String getClientMachineName() {
            return this.clientMachineName;
        }

        public String getPort() {
            return this.port;
        }
    }

    public class User {
        private final String name;
        private final String email;
        private final String userId;
        private final Long accountId;

        public User(String name, String email, String userId, Long accountId) {
            this.name = name;
            this.email = email;
            this.userId = userId;
            this.accountId = accountId;
        }

        public String getName() {
            return this.name;
        }

        public String getEmail() {
            return this.email;
        }

        public String getUserId() {
            return this.userId;
        }

        public Long getAccountId() {
            return this.accountId;
        }
    }
}

