/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal.health.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.osee.jdbc.JdbcDbType;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsApi;

public class HealthSql {
    private OrcsApi orcsApi;
    private String errorMsg = "";
    private long pageNum;
    private long pageSize;
    private String orderByName;
    private String orderByDirection;
    private final List<SqlMonitoringMetric> sqls = new ArrayList<SqlMonitoringMetric>();

    public HealthSql(OrcsApi orcsApi, long pageNum, long pageSize, String orderByName, String orderByDirection) {
        this.orcsApi = orcsApi;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.orderByName = orderByName;
        this.orderByDirection = orderByDirection;
    }

    public HealthSql(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void querySqlHealth() {
        if (this.orcsApi.getJdbcService().getClient().getDbType().equals((Object)JdbcDbType.oracle)) {
            List<String> password = this.getPassword();
            if (password.size() == 1) {
                String setRoleQuery = "SET ROLE osee_health IDENTIFIED BY " + password.get(0);
                this.orcsApi.getJdbcService().getClient().runCall(setRoleQuery, new Object[0]);
                String selectFromMonitoringQuery = "SELECT * FROM (SELECT 100 * ELAPSED_TIME / SUM(ELAPSED_TIME) OVER () PERCENT, ELAPSED_TIME, SQL_FULLTEXT, SQL_ID, CHILD_NUMBER, EXECUTIONS, ELAPSED_TIME_AVG, row_number() OVER (" + this.handleOrderBy() + ") rn FROM OSEE_SQL_MONITORING) monitor " + this.handlePagination();
                Consumer<JdbcStatement> consumer = stmt -> this.sqls.add(new SqlMonitoringMetric(stmt.getString("SQL_FULLTEXT"), stmt.getString("ELAPSED_TIME"), stmt.getString("EXECUTIONS"), stmt.getString("ELAPSED_TIME_AVG"), Double.toString(stmt.getDouble("PERCENT"))));
                this.orcsApi.getJdbcService().getClient().runQuery(consumer, selectFromMonitoringQuery, new Object[0]);
                String unsetRoleQuery = "SET ROLE ALL EXCEPT osee_health";
                this.orcsApi.getJdbcService().getClient().runCall(unsetRoleQuery, new Object[0]);
            }
        } else if (this.orcsApi.getJdbcService().getClient().getDbType().equals((Object)JdbcDbType.postgresql)) {
            String pgStatsQuery = "select round(( 100 * total_exec_time / sum(total_exec_time) over ())::numeric, 2) as PERCENT, total_exec_time as ELAPSED_TIME, calls as EXECUTIONS, (total_exec_time / calls) as ELAPSED_TIME_AVG, query as SQL_FULLTEXT, mean_exec_time, stddev_exec_time from pg_stat_statements " + this.handleOrderBy() + " " + this.handlePagination();
            Consumer<JdbcStatement> consumer = stmt -> this.sqls.add(new SqlMonitoringMetric(stmt.getString("SQL_FULLTEXT"), stmt.getString("ELAPSED_TIME"), stmt.getString("EXECUTIONS"), stmt.getString("ELAPSED_TIME_AVG"), stmt.getString("PERCENT")));
            this.orcsApi.getJdbcService().getClient().runQuery(consumer, pgStatsQuery, new Object[0]);
        } else {
            this.errorMsg = "Using unsupported database";
        }
        if (this.orderByName.equals("percent")) {
            if (this.orderByDirection.equals("asc")) {
                Collections.sort(this.sqls, Comparator.comparingDouble(obj -> Double.parseDouble(obj.getPercent())));
            } else {
                Collections.sort(this.sqls, Comparator.comparing(obj -> Double.parseDouble(obj.getPercent()), Comparator.reverseOrder()));
            }
        }
    }

    private List<String> getPassword() {
        ArrayList<String> password = new ArrayList<String>();
        Consumer<JdbcStatement> consumer = stmt -> password.add(stmt.getString("OSEE_VALUE"));
        String selectPasswordQuery = "SELECT OSEE_VALUE FROM OSEE_INFO WHERE OSEE_KEY = 'osee.health.view.password'";
        this.orcsApi.getJdbcService().getClient().runQuery(consumer, selectPasswordQuery, new Object[0]);
        return password;
    }

    public String handlePagination() {
        Long tempLowerBound = (this.pageNum - 1L) * this.pageSize;
        Long lowerBound = tempLowerBound == 0L ? tempLowerBound : tempLowerBound + 1L;
        Long upperBound = tempLowerBound == 0L ? lowerBound + this.pageSize : lowerBound + this.pageSize - 1L;
        if (this.orcsApi.getJdbcService().getClient().getDbType().equals((Object)JdbcDbType.oracle)) {
            return "WHERE rn BETWEEN " + lowerBound + " AND " + upperBound;
        }
        if (this.orcsApi.getJdbcService().getClient().getDbType().equals((Object)JdbcDbType.postgresql)) {
            return "LIMIT " + this.pageSize + " OFFSET " + lowerBound;
        }
        return "";
    }

    private String handleOrderBy() {
        String orderByString = "ORDER BY ";
        switch (this.orderByName) {
            case "elapsedTime": {
                orderByString = String.valueOf(orderByString) + "ELAPSED_TIME ";
                break;
            }
            case "sqlText": {
                orderByString = String.valueOf(orderByString) + "SQL_FULLTEXT ";
                break;
            }
            case "executions": {
                orderByString = String.valueOf(orderByString) + "EXECUTIONS ";
                break;
            }
            case "elapsedTimeAverage": {
                orderByString = String.valueOf(orderByString) + "ELAPSED_TIME_AVG ";
                break;
            }
            default: {
                orderByString = String.valueOf(orderByString) + "ELAPSED_TIME ";
            }
        }
        switch (this.orderByDirection) {
            case "asc": {
                orderByString = String.valueOf(orderByString) + "ASC";
                break;
            }
            case "desc": {
                orderByString = String.valueOf(orderByString) + "DESC";
                break;
            }
            default: {
                orderByString = String.valueOf(orderByString) + "DESC";
            }
        }
        return orderByString;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public List<SqlMonitoringMetric> getSqls() {
        return this.sqls;
    }

    public class SqlMonitoringMetric {
        private String sqlText = "";
        private String elapsedTime = "";
        private String executions = "";
        private String elapsedTimeAverage = "";
        private String percent = "";

        public SqlMonitoringMetric(String sqlText, String elapsedTime, String executions, String elapsedTimeAverage, String percent) {
            this.sqlText = sqlText;
            this.elapsedTime = elapsedTime;
            this.executions = executions;
            this.elapsedTimeAverage = elapsedTimeAverage;
            this.percent = percent;
        }

        public String getSqlText() {
            return this.sqlText;
        }

        public String getElapsedTime() {
            return this.elapsedTime;
        }

        public String getExecutions() {
            return this.executions;
        }

        public String getElapsedTimeAverage() {
            return this.elapsedTimeAverage;
        }

        public String getPercent() {
            return this.percent;
        }
    }
}

