/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTokenWithIcon;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.ArtifactWithRelations;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeReadable;
import org.eclipse.osee.framework.core.data.AttributeTypeJoin;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.TupleTypeImpl;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.util.ArtifactSearchOptions;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.MultipleItemsExist;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.resource.management.IResourceLocator;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.OrcsAdmin;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.QueryType;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.rest.internal.AttributeEndpointImpl;
import org.eclipse.osee.orcs.rest.internal.DeleteFromAllTablesWithGammaId;
import org.eclipse.osee.orcs.rest.internal.HtmlWriter;
import org.eclipse.osee.orcs.rest.internal.search.artifact.dsl.DslFactory;
import org.eclipse.osee.orcs.rest.internal.search.artifact.dsl.SearchQueryBuilder;
import org.eclipse.osee.orcs.rest.model.ArtifactEndpoint;
import org.eclipse.osee.orcs.rest.model.AttributeEndpoint;
import org.eclipse.osee.orcs.rest.model.TxBuilderInput;
import org.eclipse.osee.orcs.rest.model.search.artifact.RequestType;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchMatch;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchRequest;
import org.eclipse.osee.orcs.rest.model.search.artifact.SearchResponse;
import org.eclipse.osee.orcs.search.ArtifactTable;
import org.eclipse.osee.orcs.search.ArtifactTableOptions;
import org.eclipse.osee.orcs.search.Match;
import org.eclipse.osee.orcs.search.QueryBuilder;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ArtifactEndpointImpl
implements ArtifactEndpoint {
    private final OrcsApi orcsApi;
    private final BranchId branch;
    private final UriInfo uriInfo;
    private final OrcsTokenService tokenService;

    public ArtifactEndpointImpl(OrcsApi orcsApi, BranchId branch, UriInfo uriInfo) {
        this.orcsApi = orcsApi;
        this.uriInfo = uriInfo;
        this.branch = branch;
        this.tokenService = orcsApi.tokenService();
    }

    public List<ArtifactReadable> getSearchResults(String search, ArtifactId viewId, List<ArtifactTypeToken> artifactTypes, List<AttributeTypeToken> attributeTypes, boolean exactMatch, boolean searchById, long pageNum, long pageSize) {
        return this.getSearchQueryBuilder(search, viewId, artifactTypes, attributeTypes, exactMatch, searchById, pageNum, pageSize).asArtifacts();
    }

    public List<ArtifactTokenWithIcon> getSearchResultTokens(String search, ArtifactId viewId, List<ArtifactTypeToken> artifactTypes, List<AttributeTypeToken> attributeTypes, boolean exactMatch, boolean searchById, long pageNum, long pageSize) {
        return this.getSearchQueryBuilder(search, viewId, artifactTypes, attributeTypes, exactMatch, searchById, pageNum, pageSize).asArtifactTokens().stream().map(a -> new ArtifactTokenWithIcon(a)).collect(Collectors.toList());
    }

    public int getSearchResultCount(String search, ArtifactId viewId, List<ArtifactTypeToken> artifactTypes, List<AttributeTypeToken> attributeTypes, boolean exactMatch, boolean searchById) {
        return this.getSearchQueryBuilder(search, viewId, artifactTypes, attributeTypes, exactMatch, searchById, 0L, 0L).getCount();
    }

    private QueryBuilder getSearchQueryBuilder(String search, ArtifactId viewId, List<ArtifactTypeToken> artifactTypes, List<AttributeTypeToken> attributeTypes, boolean exactMatch, boolean searchById, long pageNum, long pageSize) {
        viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch, viewId);
        if (searchById && Strings.isNumeric((String)search)) {
            return query.andId(ArtifactId.valueOf((String)search));
        }
        if (!artifactTypes.isEmpty()) {
            query.andTypeEquals(artifactTypes);
        }
        if (Strings.isValid((String)search)) {
            LinkedList<QueryOption> options = new LinkedList<QueryOption>();
            if (exactMatch) {
                options.addAll(Arrays.asList(QueryOption.EXACT_MATCH_OPTIONS));
            } else {
                options.addAll(Arrays.asList(QueryOption.CONTAINS_MATCH_OPTIONS));
            }
            query = !attributeTypes.isEmpty() ? query.and(attributeTypes, search, (QueryOption[])options.toArray(QueryOption[]::new)) : query.and(Arrays.asList(QueryBuilder.ANY_ATTRIBUTE_TYPE), search, (QueryOption[])options.toArray(QueryOption[]::new));
        }
        query.setOrderByAttribute((AttributeTypeToken)CoreAttributeTypes.Name);
        if (pageNum != 0L && pageSize != 0L) {
            query = query.isOnPage(pageNum, pageSize);
        }
        return query;
    }

    public SearchResponse getSearchWithMatrixParams(SearchRequest params) {
        long startTime = System.currentTimeMillis();
        SearchQueryBuilder searchQueryBuilder = DslFactory.createQueryBuilder(this.orcsApi);
        QueryBuilder builder = searchQueryBuilder.build(this.orcsApi.getQueryFactory(), params);
        builder.includeDeletedArtifacts(params.isIncludeDeleted());
        if (params.getFromTx().isGreaterThan((Id)TransactionId.valueOf((int)0))) {
            builder.fromTransaction(params.getFromTx());
        }
        SearchResponse result = new SearchResponse();
        RequestType request = params.getRequestType();
        if (request != null) {
            switch (request) {
                case COUNT: {
                    int total = builder.getCount();
                    result.setTotal(total);
                    break;
                }
                case IDS: {
                    List ids = builder.asArtifactIds();
                    result.setIds(ids);
                    result.setTotal(ids.size());
                    break;
                }
                case MATCHES: {
                    ResultSet matches = builder.getMatches();
                    LinkedList<SearchMatch> searchMatches = new LinkedList<SearchMatch>();
                    LinkedList<ArtifactId> matchIds = new LinkedList<ArtifactId>();
                    for (Match match : matches) {
                        ArtifactId artId = (ArtifactId)match.getItem();
                        matchIds.add(artId);
                        for (AttributeReadable attribute : match.getElements()) {
                            List locations = match.getLocation((Object)attribute);
                            searchMatches.add(new SearchMatch(artId, (AttributeId)attribute, locations));
                        }
                    }
                    result.setIds(matchIds);
                    result.setMatches(searchMatches);
                    result.setTotal(searchMatches.size());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        result.setSearchRequest(params);
        result.setSearchTime(System.currentTimeMillis() - startTime);
        return result;
    }

    public String getRootChildrenAsHtml() {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch);
        ArtifactReadable rootArtifact = query.andIsHeirarchicalRootArtifact().getArtifact();
        HtmlWriter writer = new HtmlWriter(this.uriInfo, this.orcsApi);
        return writer.toHtml(rootArtifact.getChildren());
    }

    public String getArtifactAsHtml(ArtifactId artifactId) {
        HtmlWriter writer = new HtmlWriter(this.uriInfo, this.orcsApi);
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch);
        return writer.toHtml((Iterable<? extends Object>)query.andId(artifactId).getResults());
    }

    public ArtifactReadable getArtifactAsJson(@PathParam(value="artifactId") ArtifactId artifactId, @DefaultValue(value="-1") @QueryParam(value="view") ArtifactId view) {
        return this.orcsApi.getQueryFactory().fromBranch(this.branch, view).andId(artifactId).asArtifact();
    }

    public ArtifactToken getArtifactToken(ArtifactId artifactId) {
        return this.orcsApi.getQueryFactory().fromBranch(this.branch).andId(artifactId).asArtifactToken();
    }

    public ArtifactToken getArtifactTokenOrSentinel(ArtifactId artifactId) {
        return this.orcsApi.getQueryFactory().fromBranch(this.branch).andId(artifactId).asArtifactTokenOrSentinel();
    }

    public AttributeEndpoint getAttributes(ArtifactId artifactId) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch);
        return new AttributeEndpointImpl(artifactId, this.branch, this.orcsApi, query, this.uriInfo);
    }

    private <T> T getArtifactXByAttribute(QueryBuilder query, AttributeTypeToken attributeType, String value, boolean exists, ArtifactTypeToken artifactType, Supplier<T> queryMethod) {
        if (artifactType.isValid()) {
            query.andIsOfType(new ArtifactTypeToken[]{artifactType});
        }
        if (attributeType.isValid()) {
            if (exists) {
                query.andAttributeIs(attributeType, value);
            } else {
                query.andNotExists(attributeType, value);
            }
        }
        return queryMethod.get();
    }

    public List<ArtifactToken> getArtifactTokensByAttribute(AttributeTypeToken attributeType, String value, boolean exists, ArtifactTypeToken artifactType) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch);
        return this.getArtifactXByAttribute(query, attributeType, value, exists, artifactType, () -> ((QueryBuilder)query).asArtifactTokens());
    }

    public List<ArtifactId> getArtifactIdsByAttribute(AttributeTypeToken attributeType, String value, boolean exists, ArtifactTypeToken artifactType) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch);
        return this.getArtifactXByAttribute(query, attributeType, value, exists, artifactType, () -> ((QueryBuilder)query).asArtifactIds());
    }

    public List<Map<String, Object>> getArtifactMaps(AttributeTypeToken attributeType, String representation, String value, boolean exists, ArtifactTypeToken artifactType, ArtifactId view) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch, view);
        return this.getArtifactXByAttribute(query, attributeType, value, exists, artifactType, () -> ((QueryBuilder)query).asArtifactMaps());
    }

    public List<ArtifactToken> getArtifactTokensByType(ArtifactTypeToken artifactType) {
        return this.orcsApi.getQueryFactory().fromBranch(this.branch).andTypeEquals(new ArtifactTypeToken[]{artifactType}).asArtifactTokens();
    }

    public List<ArtifactToken> expGetArtifactTokens(ArtifactTypeToken artifactType, ArtifactId parent, ArtifactId view) {
        QueryBuilder subQuery = new QueryData(QueryType.SELECT, this.orcsApi.tokenService()).followFork(CoreRelationTypes.InterfaceMessagePubNode_Node, artifactType, null).follow(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage).follow(CoreRelationTypes.InterfaceSubMessageContent_Structure).follow(CoreRelationTypes.InterfaceStructureContent_DataElement).follow(CoreRelationTypes.InterfaceElementPlatformType_PlatformType);
        List results = this.orcsApi.getQueryFactory().fromBranch(BranchId.valueOf((Long)9031454494668930248L)).andId(ArtifactId.valueOf((int)200255)).followFork(CoreRelationTypes.InterfaceConnectionNode_Node, CoreArtifactTypes.InterfaceNode, null).followFork(CoreRelationTypes.InterfaceConnectionMessage_Message, CoreArtifactTypes.InterfaceMessage, subQuery).asArtifacts();
        System.out.println(results.toString());
        return null;
    }

    public List<ArtifactToken> getChangedArtifactTokens(ArtifactId view, AttributeTypeJoin typeJoin, String commentPattern) {
        return this.orcsApi.getQueryFactory().fromBranch(this.branch, view).andTxComment(commentPattern, typeJoin).asArtifactTokens();
    }

    public List<ArtifactId> getArtifactIdsByType(ArtifactTypeToken artifactType) {
        return this.orcsApi.getQueryFactory().fromBranch(this.branch).andTypeEquals(new ArtifactTypeToken[]{artifactType}).asArtifactIds();
    }

    public List<ArtifactToken> getArtifactTokensByApplicability(ApplicabilityId appId) {
        return this.orcsApi.getQueryFactory().fromBranch(this.branch, appId).asArtifactTokens();
    }

    public List<ArtifactToken> createArtifacts(BranchId branch, ArtifactTypeToken artifactType, ArtifactId parent, List<String> names) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "rest - create artifacts");
        List tokens = tx.createArtifacts(artifactType, parent, names);
        tx.commit();
        return tokens;
    }

    public ArtifactToken createArtifact(BranchId branch, ArtifactTypeToken artifactType, ArtifactId parent, String name) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "rest - create artifact");
        ArtifactToken token = tx.createArtifact(parent, artifactType, name);
        tx.commit();
        return token;
    }

    public List<ArtifactToken> changeArtifactType(BranchId branch, ArtifactTypeToken oldType, ArtifactTypeToken newType, List<String> names) {
        OrcsAdmin adminOps = this.orcsApi.getAdminOps();
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch);
        ArrayList<ArtifactToken> artifacts = new ArrayList<ArtifactToken>();
        for (String name : names) {
            try {
                artifacts.add(query.andTypeEquals(new ArtifactTypeToken[]{oldType}).andNameEquals(name).asArtifactToken());
            }
            catch (MultipleItemsExist ex) {
                throw new MultipleItemsExist(String.valueOf(ex.getLocalizedMessage()) + "  named " + name, new Object[0]);
            }
        }
        adminOps.changeArtifactTypeOutsideofHistory((ArtifactTypeId)newType, artifacts);
        return artifacts;
    }

    public TransactionToken deleteArtifact(BranchId branch, ArtifactId artifact) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "rest - delete artifact");
        tx.deleteArtifact(artifact);
        return tx.commit();
    }

    public Response purgeArtifact(BranchId branch, ArtifactId artifact) {
        this.orcsApi.userService().requireRole(new IUserGroupArtifactToken[]{CoreUserGroups.AccountAdmin});
        String uriQuery = "select distinct uri from osee_attribute where art_id = ? and uri is not null";
        ArrayList filesToDelete = new ArrayList();
        this.orcsApi.getJdbcService().getClient().runQuery(stmt -> {
            boolean bl = filesToDelete.add(stmt.getString("uri"));
        }, uriQuery, new Object[]{artifact.getId()});
        for (String loc : filesToDelete) {
            if (!loc.startsWith("attr:")) continue;
            IResourceLocator resourceLocator = this.orcsApi.getAdminOps().getResourceManager().getResourceLocator(loc);
            this.orcsApi.getAdminOps().getResourceManager().delete(resourceLocator);
            if (!this.orcsApi.getAdminOps().getResourceManager().exists(resourceLocator)) continue;
            Response.status((int)4, (String)("Failed to delete resource: " + loc));
        }
        ArrayList<Object[]> gammaIds = new ArrayList<Object[]>();
        ArrayList<Object> parameters = new ArrayList<Object>();
        String gammaQuery = "select gamma_id from osee_artifact where art_id = ? union all select gamma_id from osee_attribute where art_id = ? union all select gamma_id from osee_relation_link where a_art_id = ? union all select gamma_id from osee_relation_link where b_art_id = ? union all select gamma_id from osee_relation where a_art_id = ? union all select gamma_id from osee_relation where b_art_id = ? ";
        parameters.add(artifact.getId());
        parameters.add(artifact.getId());
        parameters.add(artifact.getId());
        parameters.add(artifact.getId());
        parameters.add(artifact.getId());
        parameters.add(artifact.getId());
        Field[] fieldArray = CoreTupleTypes.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            TupleTypeImpl tupleImpl = null;
            try {
                tupleImpl = (TupleTypeImpl)field.get(Object.class);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                return Response.status((int)4, (String)"Error parsing TupleTypes").build();
            }
            if (tupleImpl != null) {
                ParameterizedType pt = (ParameterizedType)field.getAnnotatedType().getType();
                int i = 0;
                while (i < pt.getActualTypeArguments().length) {
                    Type type = pt.getActualTypeArguments()[i];
                    if (type == ArtifactId.class) {
                        String table_name = tupleImpl.getClass().getSimpleName().equals("Tuple2TypeImpl") ? "osee_tuple2" : (tupleImpl.getClass().getSimpleName().equals("Tuple3TypeImpl") ? "osee_tuple3" : "osee_tuple4");
                        gammaQuery = String.valueOf(gammaQuery) + " union all select gamma_id from " + table_name + " where tuple_type = " + tupleImpl.getIdString() + " and e" + Integer.toString(i + 1) + " = ? ";
                        parameters.add(artifact.getId());
                    }
                    ++i;
                }
            }
            ++n2;
        }
        this.orcsApi.getJdbcService().getClient().runQuery(stmt -> {
            boolean bl = gammaIds.add(new Object[]{stmt.getLong("gamma_id")});
        }, gammaQuery, parameters.toArray());
        return DeleteFromAllTablesWithGammaId.deleteAllGammas(this.orcsApi.getJdbcService().getClient(), gammaQuery, parameters, gammaIds);
    }

    public TransactionToken deleteAttributesOfType(BranchId branch, ArtifactId artifact, ArtifactTypeToken artifactType, AttributeTypeToken attributeType) {
        ArrayList<ArtifactReadable> artifacts = new ArrayList<ArtifactReadable>();
        TransactionToken rtn = TransactionToken.SENTINEL;
        if (attributeType.isInvalid()) {
            return rtn;
        }
        String txComment = "Remove all attributes of type: " + attributeType.getName() + " from ";
        if (artifact.isValid()) {
            artifacts.add(this.orcsApi.getQueryFactory().fromBranch(branch).andId(artifact).asArtifactOrSentinel());
            txComment = String.valueOf(txComment) + " artifact: " + artifact.getIdString();
        } else if (artifactType.isValid()) {
            artifacts.addAll(this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{artifactType}).asArtifacts());
            txComment = String.valueOf(txComment) + " all artifacts of type: " + artifactType.getName();
        }
        if (!artifacts.isEmpty()) {
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, txComment);
            for (ArtifactReadable artifactToChange : artifacts) {
                tx.deleteAttributes((ArtifactId)artifactToChange, attributeType);
            }
            rtn = tx.commit();
        }
        return rtn;
    }

    public TransactionToken setSoleAttributeValue(BranchId branch, ArtifactId artifact, AttributeTypeToken attributeType, String value) {
        TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, "rest - setSoleAttributeValue");
        tx.setSoleAttributeFromString(artifact, attributeType, value);
        return tx.commit();
    }

    private QueryBuilder getQueryBuilder(ArtifactSearchOptions searchCriteria) {
        QueryBuilder fromBranch;
        QueryOption matchCase = QueryOption.getCaseType((boolean)searchCriteria.isCaseSensitive());
        QueryOption matchWordOrder = QueryOption.getTokenOrderType((boolean)searchCriteria.isMatchWordOrder());
        QueryOption matchExact = QueryOption.TOKEN_DELIMITER__ANY;
        if (searchCriteria.isExactMatch()) {
            matchCase = QueryOption.CASE__MATCH;
            matchWordOrder = QueryOption.TOKEN_MATCH_ORDER__MATCH;
            matchExact = QueryOption.TOKEN_DELIMITER__EXACT;
        }
        if (!searchCriteria.getArtIds().isEmpty()) {
            fromBranch = this.orcsApi.getQueryFactory().fromBranch(this.branch).andIds((Collection)searchCriteria.getArtIds());
        } else {
            fromBranch = searchCriteria.getView().isValid() ? this.orcsApi.getQueryFactory().fromBranch(this.branch, searchCriteria.getView()) : (searchCriteria.getApplic().isValid() ? this.orcsApi.getQueryFactory().fromBranch(this.branch, searchCriteria.getApplic()) : this.orcsApi.getQueryFactory().fromBranch(this.branch));
            if (!searchCriteria.getArtTypeIds().isEmpty()) {
                fromBranch.andIsOfType((Collection)searchCriteria.getArtTypeIds());
            }
            if (Strings.isValid((String)searchCriteria.getSearchString())) {
                if (searchCriteria.getAttrTypeIds().isEmpty()) {
                    List attrs = searchCriteria.getAttrTypeIds();
                    attrs.add(QueryBuilder.ANY_ATTRIBUTE_TYPE);
                    searchCriteria.setAttrTypeIds(attrs);
                }
                fromBranch.and((Collection)searchCriteria.getAttrTypeIds(), searchCriteria.getSearchString(), new QueryOption[]{matchCase, matchWordOrder, matchExact});
            }
        }
        if (searchCriteria.getIncludeDeleted().areDeletedAllowed()) {
            fromBranch.includeDeletedArtifacts();
        }
        return fromBranch;
    }

    public List<ArtifactId> findArtifactIds(ArtifactSearchOptions searchOptions) {
        return this.getQueryBuilder(searchOptions).asArtifactIds();
    }

    public List<ArtifactToken> findArtifactTokens(ArtifactSearchOptions searchOptions) {
        return this.getQueryBuilder(searchOptions).asArtifactTokens();
    }

    public ArtifactTable getArtifactTable(AttributeTypeToken attributeType, List<AttributeTypeToken> attributeColumns, String value, boolean exists, ArtifactTypeToken artifactType, ArtifactId view) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(this.branch, view);
        query.setTableOptions(new ArtifactTableOptions(attributeColumns));
        return this.getArtifactXByAttribute(query, attributeType, value, exists, artifactType, () -> ((QueryBuilder)query).asArtifactsTable());
    }

    public List<ArtifactReadable> getRelatedArtifactsTree(BranchId branch, ArtifactId artifact) {
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch);
        return query.andId(artifact).followAll().asArtifacts();
    }

    public ArtifactWithRelations getRelatedDirect(BranchId branch, ArtifactId artifact, ArtifactId viewId, boolean includeRelations) {
        viewId = viewId == null ? ArtifactId.SENTINEL : viewId;
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch(branch, viewId);
        query = query.andId(artifact);
        if (includeRelations) {
            query = query.followAll(Boolean.valueOf(true));
        }
        ArtifactReadable art = query.asArtifact();
        return new ArtifactWithRelations(art, this.tokenService, includeRelations);
    }

    public TxBuilderInput getTxBuilderInput(ArtifactTypeToken artifactTypeId) {
        return new TxBuilderInput(this.branch, this.orcsApi.getQueryFactory().fromBranch(this.branch).andIsOfType(new ArtifactTypeToken[]{artifactTypeId}).asArtifacts());
    }

    public List<List<ArtifactId>> getPathToArtifact(BranchId branch, ArtifactId artifactId, ArtifactId viewId) {
        ArrayList<Pair<ArtifactId, ArtifactId>> pairings = new ArrayList<Pair<ArtifactId, ArtifactId>>();
        ArrayList<ArtifactId> childArtIds = new ArrayList<ArtifactId>();
        Consumer<JdbcStatement> consumer = stmt -> {
            pairings.add(new Pair((Object)ArtifactId.valueOf((Long)stmt.getLong("b_art_id")), (Object)ArtifactId.valueOf((Long)stmt.getLong("a_art_id"))));
            childArtIds.add(ArtifactId.valueOf((Long)stmt.getLong("b_art_id")));
        };
        String query = "with " + this.orcsApi.getJdbcService().getClient().getDbType().getPostgresRecurse() + " allRels (a_art_id, b_art_id, gamma_id, rel_type) as (select a_art_id, b_art_id, txs.gamma_id, rel_type " + "from osee_txs txs, osee_relation rel " + "where txs.branch_id = ? and txs.tx_current = 1 and txs.gamma_id = rel.gamma_id " + this.orcsApi.getJdbcService().getClient().getDbType().getCteRecursiveUnion() + " select a_art_id, b_art_id, txs.gamma_id, rel_link_type_id rel_type " + "from osee_txs txs, osee_relation_link rel " + "where txs.branch_id = ? and txs.tx_current = 1 and txs.gamma_id = rel.gamma_id), " + "cte_query (b_art_id, a_art_id, rel_type) as ( " + "select b_art_id, a_art_id, rel_type " + "from allRels " + "where b_art_id = ? " + this.orcsApi.getJdbcService().getClient().getDbType().getCteRecursiveUnion() + " select e.b_art_id, e.a_art_id, e.rel_type " + "from allRels e " + "inner join cte_query c on c.a_art_id = e.b_art_id) " + "select * " + "from cte_query";
        this.orcsApi.getJdbcService().getClient().runQuery(consumer, query, new Object[]{branch, branch, artifactId});
        ArrayList<List<ArtifactId>> paths = new ArrayList<List<ArtifactId>>();
        while (childArtIds.contains(artifactId)) {
            paths.add(ArtifactEndpointImpl.findPath(artifactId, childArtIds, pairings));
            childArtIds.remove(artifactId);
            pairings.remove(new Pair((Object)((ArtifactId)((List)paths.get(paths.size() - 1)).get(0)), (Object)((ArtifactId)((List)paths.get(paths.size() - 1)).get(1))));
        }
        return paths;
    }

    private static List<ArtifactId> findPath(ArtifactId artId, List<ArtifactId> childArtIds, List<Pair<ArtifactId, ArtifactId>> pairings) {
        ArrayList<ArtifactId> path = new ArrayList<ArtifactId>();
        for (Pair<ArtifactId, ArtifactId> pair : pairings) {
            if (!((ArtifactId)pair.getFirst()).equals(artId)) continue;
            path.add((ArtifactId)pair.getFirst());
            if (childArtIds.contains(pair.getSecond())) {
                path.addAll(ArtifactEndpointImpl.findPath((ArtifactId)pair.getSecond(), childArtIds, pairings));
            } else {
                path.add((ArtifactId)pair.getSecond());
            }
            return path;
        }
        return path;
    }
}

