/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.model;

import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeDataTransfer;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;

@Path(value="{artifactId}/attribute")
public interface AttributeEndpoint {
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/html"})
    public String getAttributesAsHtml(@PathParam(value="artifactId") ArtifactId var1);

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="all")
    public List<AttributeDataTransfer> getAttributes(@PathParam(value="artifactId") ArtifactId var1);

    @GET
    @Consumes(value={"application/json"})
    @Path(value="{attributeId}")
    public Response getAttribute(@PathParam(value="attributeId") AttributeId var1);

    @GET
    @Consumes(value={"application/json"})
    @Path(value="{attributeId}/version/{transactionId}/text")
    public Response getAttributeWithGammaAsText(@PathParam(value="attributeId") AttributeId var1, @PathParam(value="transactionId") TransactionId var2);

    @GET
    @Consumes(value={"application/json"})
    @Path(value="{attributeId}/version/{transactionId}")
    public Response getAttributeWithGamma(@PathParam(value="attributeId") AttributeId var1, @PathParam(value="transactionId") TransactionId var2);

    @GET
    @Path(value="type")
    @Produces(value={"text/html"})
    public Response getAttributeTypes();

    @GET
    @Path(value="type/{attributeType}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/html"})
    public Response getAttributeTypeValues(@PathParam(value="attributeType") AttributeTypeToken var1);

    @GET
    @Path(value="type/{attributeType}/version/{transactionId}")
    @Consumes(value={"application/json"})
    @Produces(value={"text/html"})
    public Response getAttributeTypeValuesForTransaction(@PathParam(value="attributeType") AttributeTypeToken var1, @PathParam(value="transactionId") TransactionId var2);

    @GET
    @Path(value="{attributeId}/enums")
    @Produces(value={"application/json"})
    public Set<String> getAttributeEnums(@PathParam(value="attributeId") AttributeId var1);
}

