/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin.internal.validator;

import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.osee.account.admin.AccountField;
import org.eclipse.osee.account.admin.internal.validator.AbstractConfigurableValidator;
import org.eclipse.osee.account.admin.internal.validator.FieldValidator;
import org.eclipse.osee.account.admin.internal.validator.NoopValidator;
import org.eclipse.osee.account.admin.internal.validator.Validators;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class Validator {
    protected static final NoopValidator DEFAULT_VALIDATOR = new NoopValidator();
    private final Log logger;
    private final Map<AccountField, FieldValidator> validators;
    private Iterable<FieldValidator> ordered;

    public Validator(Log logger, Map<AccountField, FieldValidator> validators) {
        this.logger = logger;
        this.validators = validators;
    }

    public void configure(Map<String, Object> props) {
        this.logger.info("Start Validator Config Update...", new Object[0]);
        for (FieldValidator validator : this.validators.values()) {
            if (!(validator instanceof AbstractConfigurableValidator)) continue;
            AbstractConfigurableValidator configurable = (AbstractConfigurableValidator)validator;
            this.configure(configurable, props);
        }
        this.logger.info("Completed Validator Config Update", new Object[0]);
    }

    private void configure(AbstractConfigurableValidator configurable, Map<String, Object> props) {
        String patternString = configurable.getPatternFromConfig(props);
        if (Strings.isValid((String)patternString)) {
            try {
                Pattern customPattern = Pattern.compile(patternString);
                configurable.setCustomPattern(customPattern);
                this.logger.info("Configured validator [%s] with [%s]", new Object[]{configurable.getName(), customPattern.pattern()});
            }
            catch (Throwable th) {
                this.logger.error(th, "Error configuring validator [%s] - custom pattern[%s] was invalid.", new Object[]{configurable.getName(), patternString});
            }
        }
    }

    public FieldValidator getValidator(AccountField type) {
        FieldValidator validator = this.validators.get((Object)type);
        if (validator == null) {
            validator = DEFAULT_VALIDATOR;
        }
        return validator;
    }

    public boolean isValid(AccountField type, String value) {
        FieldValidator validator = this.getValidator(type);
        return validator.isValid(value);
    }

    public void validate(AccountField type, String value) {
        FieldValidator validator = this.getValidator(type);
        validator.validate(value);
    }

    public Iterable<FieldValidator> getOrdered() {
        if (this.ordered == null) {
            LinkedList<FieldValidator> list = new LinkedList<FieldValidator>(this.validators.values());
            list.add(DEFAULT_VALIDATOR);
            Collections.sort(list, Validators.VALIDATOR_PRIORITY_ORDER_COMPARATOR);
            this.ordered = list;
        }
        return this.ordered;
    }

    public AccountField guessFormatType(String value) {
        AccountField toReturn = AccountField.UNKNOWN;
        if (Strings.isValid((String)value)) {
            for (FieldValidator validator : this.getOrdered()) {
                if (!validator.isValid(value)) continue;
                toReturn = validator.getFieldType();
                break;
            }
        }
        return toReturn;
    }
}

