/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.ext;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.jaxrs.OseeWebApplicationException;
import org.eclipse.osee.jaxrs.server.internal.JaxRsUtils;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.ExceptionRegistryOperations;

class ThrowableToResponse {
    ThrowableToResponse() {
    }

    static Response toResponse(Throwable throwable, UriInfo uriInfo, ExceptionRegistryOperations exceptionRegistryOperations, Log logger) {
        Response.Status status;
        OseeWebApplicationException webAppException;
        if (throwable instanceof OseeWebApplicationException) {
            webAppException = (OseeWebApplicationException)throwable;
            status = webAppException.getErrorStatus();
        } else if (throwable instanceof WebApplicationException) {
            webAppException = (WebApplicationException)throwable;
            Response response = webAppException.getResponse();
            int statusCode = response.getStatus();
            status = Response.Status.fromStatusCode((int)statusCode);
            if (status == null) {
                status = JaxRsUtils.newStatusType(statusCode, Response.Status.Family.SERVER_ERROR, "unknown status code");
            }
        } else {
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        String url = uriInfo.getRequestUri().toASCIIString();
        String message = String.valueOf(url) + "\n" + Lib.exceptionToString((Throwable)throwable);
        if (exceptionRegistryOperations.okToLog(throwable)) {
            logger.errorNoFormat(throwable, (CharSequence)url);
        }
        return Response.status((Response.StatusType)status).entity((Object)message).header("osee-jaxrs-error-response", (Object)Boolean.TRUE).build();
    }
}

