/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactReadable;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.exception.OseeNotFoundException;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.core.model.dto.ChangeReportRowDto;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.ItemDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Compare;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.orcs.KeyValueOps;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.OseeDb;
import org.eclipse.osee.orcs.core.ds.TxDataStore;
import org.eclipse.osee.orcs.core.internal.transaction.TransactionBuilderImpl;
import org.eclipse.osee.orcs.core.internal.transaction.TxCallableFactory;
import org.eclipse.osee.orcs.core.internal.transaction.TxData;
import org.eclipse.osee.orcs.core.internal.transaction.TxDataManager;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.BranchQuery;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TransactionQuery;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class TransactionFactoryImpl
implements TransactionFactory {
    private final OrcsSession session;
    private final TxDataManager txDataManager;
    private final TxCallableFactory txCallableFactory;
    private final OrcsApi orcsApi;
    private final QueryFactory queryFactory;
    private final OrcsBranch orcsBranch;
    private final KeyValueOps keyValueOps;
    private final TxDataStore txDataStore;
    private final TransactionQuery transactionQuery;

    public TransactionFactoryImpl(OrcsSession session, TxDataManager txDataManager, TxCallableFactory txCallableFactory, OrcsApi orcsApi, OrcsBranch orcsBranch, KeyValueOps keyValueOps, TxDataStore txDataStore) {
        this.session = session;
        this.txDataManager = txDataManager;
        this.txCallableFactory = txCallableFactory;
        this.orcsApi = orcsApi;
        this.queryFactory = orcsApi.getQueryFactory();
        this.orcsBranch = orcsBranch;
        this.keyValueOps = keyValueOps;
        this.txDataStore = txDataStore;
        this.transactionQuery = this.queryFactory.transactionQuery();
    }

    public CancellableCallable<Integer> purgeTransaction(Collection<? extends TransactionId> transactions) {
        return this.txCallableFactory.purgeTransactions(this.session, transactions);
    }

    public TransactionBuilder createTransaction(BranchId branch, String comment) {
        Conditions.checkNotNull((Object)branch, (String)"branch");
        Conditions.checkNotNullOrEmpty((String)comment, (String)"comment");
        if (!((BranchQuery)this.queryFactory.branchQuery().andId(branch)).exists()) {
            throw new ItemDoesNotExist("BranchId %s does not exist", new Object[]{branch});
        }
        TxData txData = this.txDataManager.createTxData(this.session, branch);
        TransactionBuilderImpl orcsTxn = new TransactionBuilderImpl(this.txCallableFactory, this.txDataManager, txData, this.orcsApi, this.keyValueOps);
        orcsTxn.setComment(comment);
        orcsTxn.setAuthor(this.orcsApi.userService().getUser());
        return orcsTxn;
    }

    public TransactionBuilder createTransaction(BranchId branch, UserId author, String comment) {
        TxData txData = this.txDataManager.createTxData(this.session, branch);
        TransactionBuilderImpl orcsTxn = new TransactionBuilderImpl(this.txCallableFactory, this.txDataManager, txData, this.orcsApi, this.keyValueOps);
        orcsTxn.setComment(comment);
        if (author == null) {
            throw new OseeCoreException("In TransactionFactoryImpl.createTransaction, the parameter \"author\" is null which is dereferenced", new Object[0]);
        }
        UserToken user = this.orcsApi.userService().getUser(author.getId());
        orcsTxn.setAuthor(user);
        return orcsTxn;
    }

    public Callable<Void> setTransactionComment(TransactionId transaction, String comment) {
        return this.txCallableFactory.setTransactionComment(this.session, transaction, comment);
    }

    public List<ChangeItem> compareTxs(TransactionId txId1, TransactionId txId2) {
        TransactionReadable sourceTx = this.getTx(txId1);
        TransactionReadable destinationTx = this.getTx(txId2);
        try {
            return this.orcsBranch.compareBranch((TransactionToken)sourceTx, (TransactionToken)destinationTx);
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public List<ChangeItem> comparedToParent(BranchId branch) {
        BranchId parentBranch = ((Branch)((BranchQuery)this.queryFactory.branchQuery().andId(branch)).getResults().getExactlyOne()).getParentBranch();
        TransactionId sourceTx = (TransactionId)((TransactionQuery)this.transactionQuery.andIsHead(branch)).getResultsAsIds().getExactlyOne();
        TransactionId destionationTx = (TransactionId)((TransactionQuery)this.transactionQuery.andIsHead(parentBranch)).getResultsAsIds().getExactlyOne();
        return this.compareTxs(sourceTx, destionationTx);
    }

    public List<ChangeItem> comparedToPreviousTx(TransactionToken txId) {
        TransactionId startTx = (TransactionId)((TransactionQuery)this.transactionQuery.andIsPriorTx(txId)).getResultsAsIds().getExactlyOne();
        return this.compareTxs(startTx, (TransactionId)txId);
    }

    public boolean replaceWithBaselineTxVersion(BranchId branchId, TransactionId txId, ArtifactId artId, String comment) {
        boolean introduced = false;
        ArtifactReadable baselineArtifact = (ArtifactReadable)this.queryFactory.fromBranch(branchId).fromTransaction(txId).andId(artId).getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (!baselineArtifact.isValid()) {
            throw new OseeCoreException("%s Error - The baseline artifact was not found.", new Object[]{comment});
        }
        TransactionBuilder tx = this.createTransaction(branchId, comment);
        ArtifactReadable destination = (ArtifactReadable)this.queryFactory.fromBranch(branchId).includeDeletedArtifacts().andId(artId).getResults().getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        tx.replaceWithVersion(baselineArtifact, destination);
        tx.commit();
        introduced = true;
        return introduced;
    }

    public boolean purgeTxs(String txIds) {
        boolean modified = false;
        ArrayList<String> insertTxStatements = new ArrayList<String>();
        ArrayList impactedGammaIds = new ArrayList();
        ArrayList<Long> unusedGammas = new ArrayList<Long>();
        List txsToDelete = Collections.fromString((String)txIds, TransactionId::valueOf);
        String recoveryFileNamePrefix = "purgeTxs_";
        for (TransactionId txIdToDelete : txsToDelete) {
            BranchId branchId = this.orcsApi.getTransactionFactory().getTx(txIdToDelete).getBranch();
            this.orcsApi.getJdbcService().getClient().runQuery(stmt -> {
                boolean bl = insertTxStatements.add(stmt.getString("insertString"));
            }, OseeDb.TX_DETAILS_TABLE.getSelectInsertString(" where branch_id = ? and transaction_id = ?"), new Object[]{branchId, txIdToDelete});
            this.orcsApi.getJdbcService().getClient().runQuery(stmt -> {
                boolean bl = insertTxStatements.add(stmt.getString("insertString"));
            }, OseeDb.TXS_TABLE.getSelectInsertString(" where branch_id = ? and transaction_id = ?"), new Object[]{branchId, txIdToDelete});
            this.orcsApi.getJdbcService().getClient().runQuery(stmt -> {
                boolean bl = impactedGammaIds.add(stmt.getLong("gamma_id"));
            }, OseeSql.SELECT_IMPACTED_GAMMAS_BY_BRANCH_TX.getSql(), new Object[]{branchId, txIdToDelete});
        }
        if (!txsToDelete.isEmpty()) {
            recoveryFileNamePrefix = String.valueOf(recoveryFileNamePrefix) + txsToDelete.get(0) + "_" + txsToDelete.get(txsToDelete.size() - 1);
            ResultSet results = ((TransactionQuery)this.transactionQuery.andTxIds((Collection)txsToDelete)).getResults();
            if (!results.isEmpty()) {
                this.checkAllTxsFound("Purge Transaction", txsToDelete, (ResultSet<? extends TransactionId>)results);
                ArrayList list = Lists.newArrayList((Iterable)results);
                try {
                    this.purgeTransaction((Collection<? extends TransactionId>)list).call();
                }
                catch (Exception ex) {
                    throw OseeCoreException.wrap((Throwable)ex);
                }
                modified = true;
                for (Long gamma : impactedGammaIds) {
                    this.orcsApi.getJdbcService().getClient().runQuery(stmt -> {
                        boolean bl = unusedGammas.add(stmt.getLong("gamma_id"));
                    }, OseeSql.UNUSED_IMPACTED_GAMMAS_AFTER_PURGE.getSql(), new Object[]{gamma, gamma, gamma, 0});
                }
                this.txDataStore.purgeUnusedBackingDataAndTransactions(unusedGammas, insertTxStatements, recoveryFileNamePrefix);
            }
        }
        return modified;
    }

    public boolean setTxComment(TransactionId txId, String comment) {
        TransactionReadable tx = this.getTx(txId);
        boolean modified = false;
        if (Compare.isDifferent((Object)tx.getComment(), (Object)comment)) {
            this.setTransactionComment((TransactionId)tx, comment);
            modified = true;
        }
        return modified;
    }

    public ResultSet<TransactionReadable> getAllTxs() {
        return this.transactionQuery.getResults();
    }

    public TransactionReadable getTx(TransactionId tx) {
        if (tx instanceof TransactionReadable) {
            return (TransactionReadable)tx;
        }
        return (TransactionReadable)((TransactionQuery)this.transactionQuery.andTxId(tx)).getResults().getExactlyOne();
    }

    private void checkAllTxsFound(String opName, List<TransactionId> txIds, ResultSet<? extends TransactionId> result) {
        List difference;
        if (txIds.size() != result.size() && !(difference = Collections.setComplement(txIds, (Collection)result.getList())).isEmpty()) {
            throw new OseeNotFoundException("%s Error - The following transactions from %s were not found - txs %s - Please remove them from the request and try again.", new Object[]{opName, txIds, difference});
        }
    }

    public int[] purgeUnusedBackingDataAndTransactions(int rowCount) {
        return this.txDataStore.purgeUnusedBackingDataAndTransactions(rowCount);
    }

    public int[] purgeUnusedBackingDataAndTransactions(List<Long> gammasToPurge, List<String> additionalStatements, String prefixRecoveryFile) {
        return this.txDataStore.purgeUnusedBackingDataAndTransactions(gammasToPurge, additionalStatements, prefixRecoveryFile);
    }

    public boolean setTransactionCommitArtifact(TransactionId trans, ArtifactId commitArt) {
        TransactionReadable tx = this.getTx(trans);
        boolean modified = false;
        if (Compare.isDifferent((Object)tx.getCommitArt(), (Object)commitArt)) {
            this.txCallableFactory.setTransactionCommitArtifact(this.session, trans, commitArt);
            modified = true;
        }
        return modified;
    }

    public List<ChangeItem> getArtifactHistory(ArtifactId artifact, BranchId branch) {
        try {
            return this.txDataStore.getArtifactHistory(this.session, this.queryFactory, artifact, branch).call();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    public List<ChangeReportRowDto> getTxChangeReport(BranchId branch1, BranchId branch2, TransactionId txId1, TransactionId txId2) {
        LinkedList<ChangeReportRowDto> changeReportRows = new LinkedList<ChangeReportRowDto>();
        List<ChangeItem> changeItems = this.compareTxs(txId1, txId2);
        LinkedList<ArtifactId> artIds = new LinkedList<ArtifactId>();
        for (ChangeItem change : changeItems) {
            if (change.getArtId().isValid() && !artIds.contains(change.getArtId())) {
                artIds.add(change.getArtId());
            }
            if (!change.getArtIdB().isValid() || artIds.contains(change.getArtIdB())) continue;
            artIds.add(change.getArtIdB());
        }
        List artifacts = this.orcsApi.getQueryFactory().fromBranch(branch1).andIds(artIds).asArtifacts();
        for (ChangeItem changeItem : changeItems.stream().filter(a -> a.getIgnoreType().isNone()).collect(Collectors.toList())) {
            ArtifactReadable artB;
            ArtifactReadable artA = artifacts.stream().filter(a -> ArtifactId.valueOf((Long)a.getId()).equals(changeItem.getArtId())).findFirst().orElse(ArtifactReadable.SENTINEL);
            ArtifactReadable artifactReadable = artB = changeItem.getArtIdB().isValid() ? artifacts.stream().filter(a -> ArtifactId.valueOf((Long)a.getId()).equals(changeItem.getArtIdB())).findFirst().orElse(ArtifactReadable.SENTINEL) : ArtifactReadable.SENTINEL;
            if (!artA.isValid() && branch2.isValid() && !(artA = this.orcsApi.getQueryFactory().fromBranch(branch2).andIds(new ArtifactId[]{changeItem.getArtId()}).asArtifactOrSentinel()).isValid()) continue;
            if (changeItem.getArtIdB().isValid() && !artB.isValid() && branch2.isValid()) {
                artB = this.orcsApi.getQueryFactory().fromBranch(branch2).andIds(new ArtifactId[]{changeItem.getArtIdB()}).asArtifactOrSentinel();
            }
            ApplicabilityToken currentApplic = ApplicabilityToken.SENTINEL;
            ApplicabilityToken baselineApplic = ApplicabilityToken.SENTINEL;
            ChangeType itemKindType = changeItem.getChangeType();
            ModificationType modType = changeItem.getNetChange().getModType();
            String isValue = itemKindType.equals((Object)ChangeType.Relation) ? "" : changeItem.getCurrentVersion().getValue();
            String wasValue = itemKindType.equals((Object)ChangeType.Relation) ? "" : changeItem.getBaselineVersion().getValue();
            String changeType = modType.getName();
            TransactionToken tx = changeItem.getCurrentVersion().getTransactionToken();
            String names = artA.getName();
            if (itemKindType.equals((Object)ChangeType.Relation) && artB.isValid()) {
                names = String.valueOf(names) + " <---> " + artB.getName();
            }
            String itemType = "";
            if (itemKindType.equals((Object)ChangeType.Artifact)) {
                itemType = artA.getArtifactType().getName();
            } else if (itemKindType.equals((Object)ChangeType.Attribute)) {
                AttributeTypeToken attrToken = artA.getExistingAttributeTypes().stream().filter(a -> a.getIdString().equals(changeItem.getItemTypeId().getIdString())).findFirst().orElse((AttributeTypeToken)AttributeTypeToken.SENTINEL);
                itemType = attrToken.isValid() ? attrToken.getName() : "";
            } else if (itemKindType.equals((Object)ChangeType.Relation)) {
                RelationTypeToken relToken = artA.getExistingRelationTypes().stream().filter(a -> a.getIdString().equals(changeItem.getItemTypeId().getIdString())).findFirst().orElse(RelationTypeToken.SENTINEL);
                String string = itemType = relToken.isValid() ? relToken.getName() : "";
            }
            if (itemKindType.equals((Object)ChangeType.Artifact)) {
                currentApplic = changeItem.getCurrentVersion().getApplicabilityToken();
                baselineApplic = changeItem.getBaselineVersion().getApplicabilityToken();
                if (currentApplic != null && baselineApplic != null && !currentApplic.equals((Object)baselineApplic)) {
                    changeType = "Applicability";
                    isValue = currentApplic.getName();
                    wasValue = baselineApplic.getName();
                }
                if (currentApplic == null) {
                    currentApplic = ApplicabilityToken.SENTINEL;
                }
                if (baselineApplic == null) {
                    baselineApplic = ApplicabilityToken.SENTINEL;
                }
            }
            if (itemKindType.equals((Object)ChangeType.Artifact) && modType.equals(ModificationType.MODIFIED)) {
                isValue = "";
                wasValue = "";
            }
            changeReportRows.add(new ChangeReportRowDto(artA, artB, names, itemType, changeItem.getItemTypeId().getId(), changeType, isValue, wasValue, itemKindType, modType, currentApplic, baselineApplic, (TransactionId)tx));
        }
        changeReportRows.sort(new Comparator<ChangeReportRowDto>(){

            @Override
            public int compare(ChangeReportRowDto o1, ChangeReportRowDto o2) {
                return o1.getArtA().getId().compareTo(o2.getArtA().getId());
            }
        });
        return changeReportRows;
    }

    public boolean undoTx(BranchId branch, TransactionId transaction) {
        String query = "WITH\r\ncurrentTx as (SELECT * from osee_txs txs where txs.transaction_id =? and txs.branch_id=?),\r\nnewArts1 as (SELECT art.*, 2 as event_type, '' as name from osee_artifact art, currentTx txs  WHERE art.gamma_id = txs.gamma_id and txs.mod_type =1),\r\nnewArts2 as (SELECT art.*, 2 as event_type, '' as name from osee_artifact art, currentTx txs  WHERE art.gamma_id = txs.gamma_id and txs.mod_type =6),\r\nnewArts as (SELECT * FROM newArts1 UNION SELECT * FROM newArts2 ),\r\nmodifiedArts as (SELECT art.*, 8 as event_type, '' as name from osee_artifact art, currentTx txs WHERE art.gamma_id = txs.gamma_id and txs.mod_type =2),\r\ndeletedArts as (SELECT art.*, 3 as event_type, attr.value as name from osee_artifact art, currentTx txs, osee_attribute attr, osee_txs attrTxs WHERE art.gamma_id = txs.gamma_id and txs.mod_type =3 and attrTxs.transaction_id = txs.transaction_id and attr.gamma_id = attrTxs.gamma_id and attr.attr_type_id = ?),\r\nartsCombined as (SELECT * from newArts UNION SELECT * from modifiedArts UNION SELECT * from deletedArts),\r\nnewAttr1 as (SELECT attr.*, 1 as event_type,'' as previous_value from osee_attribute attr, currentTx txs WHERE attr.gamma_id=txs.gamma_id and txs.mod_type=1),\r\nnewAttr2 as (SELECT attr.*, 1 as event_type, '' as previous_value from osee_attribute attr, currentTx txs WHERE attr.gamma_id=txs.gamma_id and txs.mod_type=6),\r\nnewAttr as (SELECT * FROM newAttr1 UNION SELECT * FROM newAttr2 ),\r\nmodifiedAttr as (SELECT attr.*, 7 as event_type from osee_attribute attr, currentTx txs WHERE attr.gamma_id=txs.gamma_id and txs.mod_type=2),\r\npreviousModifiedAttr as (SELECT attr.* from osee_attribute attr, modifiedAttr modAttr, osee_txs txs WHERE txs.branch_id = ? and txs.tx_current <>? and txs.gamma_id = attr.gamma_id and attr.attr_type_id = modAttr.attr_type_id and attr.art_id = modAttr.art_id),\r\nfullModifiedAttr as (SELECT attr.*, prevMod.value as previous_value from modifiedAttr attr, previousModifiedAttr prevMod),\r\ndeletedAttr1 as (SELECT attr.*, 6 as event_type ,'' as previous_value from osee_attribute attr, currentTx txs WHERE attr.gamma_id=txs.gamma_id and txs.mod_type=3),\r\ndeletedAttr2 as (SELECT attr.*, 6 as event_type, '' as previous_value from osee_attribute attr, currentTx txs WHERE attr.gamma_id=txs.gamma_id and txs.mod_type=5),\r\ndeletedAttr as (SELECT * FROM deletedAttr1 UNION SELECT * FROM deletedAttr2 ),\r\nattrCombined as (SELECT * FROM newAttr UNION SELECT * from fullModifiedAttr UNION SELECT * from deletedAttr),\r\nnewRel1 as (SELECT rel.*, 0 as event_type from osee_relation rel, currentTx txs WHERE rel.gamma_id=txs.gamma_id and txs.mod_type=1),\r\nnewRel2 as (SELECT rel.*, 0 as event_type from osee_relation rel, currentTx txs WHERE rel.gamma_id=txs.gamma_id and txs.mod_type=6),\r\nnewRel as (SELECT * from newRel1 UNION SELECT * from newRel2),\r\nmodifiedRel as (SELECT rel.*, 5 as event_type from osee_relation rel, currentTx txs WHERE rel.gamma_id=txs.gamma_id and txs.mod_type=2),\r\ndeletedRel1 as (SELECT rel.*, 5 as event_type from osee_relation rel, currentTx txs WHERE rel.gamma_id=txs.gamma_id and txs.mod_type=3),\r\ndeletedRel2 as (SELECT rel.*, 5 as event_type from osee_relation rel, currentTx txs WHERE rel.gamma_id=txs.gamma_id and txs.mod_type=5),\r\ndeletedRel as (SELECT * FROM deletedRel1 UNION SELECT * FROM deletedRel2 ),\r\nrelsCombined as (SELECT * from newRel UNION SELECT * from modifiedRel UNION SELECT * from deletedRel ),\r\nafterArtifactLocation as (SELECT MAX(rel2.rel_order) OVER (PARTITION BY rel2.rel_type, rel2.a_art_id, rel1.event_type) as rel_order, rel2.rel_type,rel2.a_art_id, rel1.event_type as event_type \r\n                    FROM relsCombined rel1, osee_txs txs, osee_relation rel2 WHERE \r\n            txs.branch_id = ? and txs.tx_current =? and txs.gamma_id = rel2.gamma_id and\r\n           rel2.a_art_id = rel1.a_art_id and rel2.rel_type = rel1.rel_type and rel2.rel_order < rel1.rel_order  ),\r\nmissingRels AS (SELECT rels.rel_order, rels.rel_type, rels.a_art_id, rels.event_type from relsCombined rels WHERE NOT EXISTS (\r\nSELECT NULL FROM afterArtifactLocation art WHERE art.a_art_id = rels.a_art_id and art.rel_type = rels.rel_type and art.event_type = rels.event_type\r\n)),afterArtifactWithMissing as (SELECT DISTINCT rel_order, rel_type,a_art_id, event_type from afterArtifactLocation UNION SELECT rels.rel_order, rels.rel_type, rels.a_art_id, rels.event_type from missingRels rels),\r\nafterArtifact as (SELECT rel.a_art_id, rel.rel_type, art.event_type, CASE WHEN art.rel_order <>0 THEN rel.b_art_id ELSE 0 END as b_art_id FROM osee_relation rel, afterArtifactWithMissing art WHERE rel.rel_order = art.rel_order and rel.rel_type = art.rel_type and rel.a_art_id =art.a_art_id),\r\ncompleteNewRels as (SELECT relsCombined.rel_type, relsCombined.a_art_id, relsCombined.b_art_id, CASE WHEN afterArtifact.b_art_id <>0 THEN afterArtifact.b_art_id ELSE 0 END as rel_order, relsCombined.event_type from relsCombined, afterArtifact WHERE afterArtifact.rel_type = relsCombined.rel_type and afterArtifact.a_art_id = relsCombined.a_art_id and afterArtifact.event_type = relsCombined.event_type ),\r\nnewTuple21 as (SELECT t2.*, 9 as event_type from osee_tuple2 t2, currentTx txs  WHERE t2.gamma_id = txs.gamma_id and txs.mod_type =1),\r\nnewTuple22 as (SELECT t2.*, 9 as event_type from osee_tuple2 t2, currentTx txs  WHERE t2.gamma_id = txs.gamma_id and txs.mod_type =6),\r\nnewTuple2 as (SELECT * FROM newTuple21 UNION SELECT * FROM newTuple22 ),\r\nmodifiedTuple2 as (SELECT t2.*, 10 as event_type from osee_tuple2 t2, currentTx txs WHERE t2.gamma_id = txs.gamma_id and txs.mod_type =2),\r\ndeletedTuple2 as (SELECT t2.*, 11 as event_type from osee_tuple2 t2, currentTx txs WHERE t2.gamma_id = txs.gamma_id and txs.mod_type =3),\r\ntuple2Combined as (SELECT * from newTuple2 UNION SELECT * from modifiedTuple2 UNION SELECT * FROM deletedTuple2),\r\nnewTuple31 as (SELECT t3.*, 12 as event_type from osee_tuple3 t3, currentTx txs  WHERE t3.gamma_id = txs.gamma_id and txs.mod_type =1),\r\nnewTuple32 as (SELECT t3.*, 12 as event_type from osee_tuple3 t3, currentTx txs  WHERE t3.gamma_id = txs.gamma_id and txs.mod_type =6),\r\nnewTuple3 as (SELECT * FROM newTuple31 UNION SELECT * FROM newTuple32 ),\r\nmodifiedTuple3 as (SELECT t3.*, 13 as event_type from osee_tuple3 t3, currentTx txs WHERE t3.gamma_id = txs.gamma_id and txs.mod_type =2),\r\ndeletedTuple3 as (SELECT t3.*, 14 as event_type from osee_tuple3 t3, currentTx txs WHERE t3.gamma_id = txs.gamma_id and txs.mod_type =3),\r\ntuple3Combined as (SELECT * from newTuple3 UNION SELECT * from modifiedTuple3 UNION SELECT * FROM deletedTuple3),\r\nnewTuple41 as (SELECT t4.*, 15 as event_type from osee_tuple4 t4, currentTx txs  WHERE t4.gamma_id = txs.gamma_id and txs.mod_type =1),\r\nnewTuple42 as (SELECT t4.*, 15 as event_type from osee_tuple4 t4, currentTx txs  WHERE t4.gamma_id = txs.gamma_id and txs.mod_type =6),\r\nnewTuple4 as (SELECT * FROM newTuple41 UNION SELECT * FROM newTuple42 ),\r\nmodifiedTuple4 as (SELECT t4.*, 16 as event_type from osee_tuple4 t4, currentTx txs WHERE t4.gamma_id = txs.gamma_id and txs.mod_type =2),\r\ndeletedTuple4 as (SELECT t4.*, 17 as event_type from osee_tuple4 t4, currentTx txs WHERE t4.gamma_id = txs.gamma_id and txs.mod_type =3),\r\ntuple4Combined as (SELECT * from newTuple4 UNION SELECT * from modifiedTuple4 UNION SELECT * FROM deletedTuple4),\r\nnewOldRel1 as (SELECT rel.*, 0 as event_type from osee_relation_link rel, currentTx txs WHERE rel.gamma_id=txs.gamma_id and txs.mod_type=1),\r\nnewOldRel2 as (SELECT rel.*, 0 as event_type from osee_relation_link rel, currentTx txs WHERE rel.gamma_id=txs.gamma_id and txs.mod_type=6),\r\nnewOldRel as (SELECT * from newOldRel1 UNION SELECT * from newOldRel2),\r\nmodifiedOldRel as (SELECT rel.*, 4 as event_type from osee_relation_link rel, currentTx txs WHERE rel.gamma_id=txs.gamma_id and txs.mod_type=2),\r\ndeletedOldRel1 as (SELECT rel.*, 5 as event_type from osee_relation_link rel, currentTx txs WHERE rel.gamma_id=txs.gamma_id and txs.mod_type=3),\r\ndeletedOldRel2 as (SELECT rel.*, 5 as event_type from osee_relation_link rel, currentTx txs WHERE rel.gamma_id=txs.gamma_id and txs.mod_type=5),\r\ndeletedOldRel as (SELECT * FROM deletedOldRel1 UNION SELECT * FROM deletedOldRel2 ),\r\noldRelsCombined as (SELECT * from newOldRel UNION SELECT * from modifiedOldRel UNION SELECT * from deletedOldRel ),\r\narts as (SELECT art_id as id , art_type_id as type_id , guid as extra1,0 as extra2, 0 as extra3, 0 as extra4,0 as extra5, name as extra6,event_type from artsCombined),\r\nattr as (SELECT attr_id as id , attr_type_id as type_id ,value as extra1,art_id as extra2, 0 as extra3, 0 as extra4, 0 as extra5, previous_value as extra6, event_type from attrCombined),\r\nrels as (SELECT 0 as id, rel_type as type_id, '' as extra1, a_art_id as extra2,b_art_id as extra3, rel_order as extra4, 0 as extra5, '' as extra6, event_type from completeNewRels ),\r\noldRels as (SELECT rel_link_id as id, rel_link_type_id as type_id, '' as extra1, a_art_id as extra2, b_art_id as extra3,0 as extra4, 0 as extra5, '' as extra6, event_type from oldRelsCombined),\r\ntuple2s as (SELECT 0 as id, tuple_type as type_id, '' as extra1, e1 as extra2,e2 as extra3, 0 as extra4, 0 as extra5, '' as extra6, event_type from tuple2Combined ),\r\ntuple3s as (SELECT 0 as id, tuple_type as type_id, '' as extra1, e1 as extra2, e2 as extra3, e3 as extra4, 0 as extra5, '' as extra6, event_type from tuple3Combined), \r\ntuple4s as (SELECT 0 as id, tuple_type as type_id, '' as extra1, e1 as extra2, e2 as extra3, e3 as extra4, e4 as extra5, '' as extra6, event_type from tuple4Combined)\r\nselect * from (SELECT * from attr UNION SELECT * from arts UNION SELECT * FROM rels UNION SELECT * from tuple2s UNION SELECT * from tuple3s UNION SELECT * from tuple4s UNION SELECT * from oldRels) t1 ORDER BY event_type\r\n";
        TransactionBuilder tx = this.createTransaction(branch, "Undoing " + transaction.getIdString());
        LinkedList createdArts = new LinkedList();
        Consumer<JdbcStatement> consumer = stmt -> {
            int event_type = stmt.getInt("event_type");
            switch (event_type) {
                case 0: {
                    tx.unrelate(ArtifactId.valueOf((Long)stmt.getLong("extra2")), this.orcsApi.tokenService().getRelationType(Long.valueOf(stmt.getLong("type_id"))), ArtifactId.valueOf((Long)stmt.getLong("extra3")));
                    break;
                }
                case 1: {
                    tx.deleteByAttributeId(ArtifactId.valueOf((Long)stmt.getLong("extra2")), AttributeId.valueOf((Long)stmt.getLong("id")));
                    break;
                }
                case 2: {
                    tx.deleteArtifact(ArtifactId.valueOf((Long)stmt.getLong("id")));
                    break;
                }
                case 3: {
                    createdArts.add(tx.createArtifact(ArtifactToken.valueOf((long)stmt.getLong("id"), (String)stmt.getString("extra1"), (String)stmt.getString("extra6"), (BranchId)branch, (ArtifactTypeToken)this.orcsApi.tokenService().getArtifactType(Long.valueOf(stmt.getLong("type_id"))))));
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    Long afterArtifact = stmt.getLong("extra4");
                    if (afterArtifact != 0L) {
                        tx.relate(ArtifactId.valueOf((Long)stmt.getLong("extra2")), this.orcsApi.tokenService().getRelationType(Long.valueOf(stmt.getLong("type_id"))), ArtifactId.valueOf((Long)stmt.getLong("extra3")), ArtifactId.SENTINEL, String.valueOf(stmt.getLong("extra4")));
                        break;
                    }
                    tx.relate(ArtifactId.valueOf((Long)stmt.getLong("extra2")), this.orcsApi.tokenService().getRelationType(Long.valueOf(stmt.getLong("type_id"))), ArtifactId.valueOf((Long)stmt.getLong("extra3")), ArtifactId.SENTINEL, "end");
                    break;
                }
                case 6: {
                    AttributeTypeGeneric attrType = this.orcsApi.tokenService().getAttributeType(Long.valueOf(stmt.getLong("type_id")));
                    ArtifactId artId = ArtifactId.valueOf((Long)stmt.getLong("extra2"));
                    if (attrType.equals((Object)CoreAttributeTypes.Name)) break;
                    tx.createAttribute(artId, (AttributeTypeToken)attrType, (Object)stmt.getString("extra1"));
                    break;
                }
                case 7: {
                    tx.setAttributeById(ArtifactId.valueOf((Long)stmt.getLong("extra2")), AttributeId.valueOf((Long)stmt.getLong("id")), stmt.getString("extra6"));
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    tx.deleteTuple2(this.orcsApi.tokenService().getTuple2Type(Long.valueOf(stmt.getLong("type_id"))), (Object)stmt.getLong("extra2"), (Object)stmt.getLong("extra3"));
                    break;
                }
                case 10: {
                    break;
                }
                case 11: {
                    tx.addTuple2(this.orcsApi.tokenService().getTuple2Type(Long.valueOf(stmt.getLong("type_id"))), (Object)stmt.getLong("extra2"), (Object)stmt.getLong("extra3"));
                    break;
                }
                case 12: {
                    tx.deleteTuple3(this.orcsApi.tokenService().getTuple3Type(Long.valueOf(stmt.getLong("type_id"))), (Object)stmt.getLong("extra2"), (Object)stmt.getLong("extra3"), (Object)stmt.getLong("extra4"));
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    tx.addTuple3(this.orcsApi.tokenService().getTuple3Type(Long.valueOf(stmt.getLong("type_id"))), (Object)stmt.getLong("extra2"), (Object)stmt.getLong("extra3"), (Object)stmt.getLong("extra4"));
                    break;
                }
                case 15: {
                    tx.deleteTuple4(this.orcsApi.tokenService().getTuple4Type(Long.valueOf(stmt.getLong("type_id"))), (Object)stmt.getLong("extra2"), (Object)stmt.getLong("extra3"), (Object)stmt.getLong("extra4"), (Object)stmt.getLong("extra5"));
                    break;
                }
                case 16: {
                    break;
                }
                case 17: {
                    tx.addTuple4(this.orcsApi.tokenService().getTuple4Type(Long.valueOf(stmt.getLong("type_id"))), (Object)stmt.getLong("extra2"), (Object)stmt.getLong("extra3"), (Object)stmt.getLong("extra4"), (Object)stmt.getLong("extra5"));
                    break;
                }
            }
        };
        this.orcsApi.getJdbcService().getClient().runQuery(consumer, query, new Object[]{transaction, branch, CoreAttributeTypes.Name, branch, 1, branch, 1});
        return tx.commit().isValid();
    }
}

