/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.HashMapHashSet;
import org.eclipse.osee.framework.jdk.core.util.ListMap;
import org.eclipse.osee.framework.jdk.core.util.MapSet;

public final class Collectors {
    private Collectors() {
    }

    public static Collector<CharSequence, ?, Optional<Path>> toPath() {
        Supplier<LinkedList> supplier = LinkedList::new;
        BiConsumer<LinkedList, CharSequence> accumulator = List::add;
        BinaryOperator combiner = (listA, listB) -> {
            listA.addAll(listB);
            return listA;
        };
        Function<LinkedList, Optional> finisher = list -> {
            if (list.isEmpty()) {
                return Optional.empty();
            }
            Path path = Path.of(((CharSequence)list.removeFirst()).toString(), new String[0]);
            while (!list.isEmpty()) {
                path.resolve(((CharSequence)list.removeFirst()).toString());
            }
            return Optional.of(path);
        };
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, List<T>, T[]> toArray(Function<Integer, T[]> arraySupplier) {
        return Collector.of(LinkedList::new, List::add, (a, b) -> {
            a.addAll(b);
            return a;
        }, l -> l.toArray((Object[])arraySupplier.apply(l.size())), new Collector.Characteristics[0]);
    }

    public static <T, K, V> Collector<T, ?, MapSet<K, V>> toMapSet(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collector.of(HashMapHashSet::new, (mapSet, t) -> {
            Object c = mapSet.putValue(keyMapper.apply(t), valueMapper.apply(t));
        }, (a, b) -> {
            a.putAll(b);
            return a;
        }, new Collector.Characteristics[0]);
    }

    public static <T, K, V> Collector<T, ?, ListMap<K, V>> toListMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collector.of(ListMap::new, (listMap, t) -> {
            Optional optional = listMap.put(keyMapper.apply(t), valueMapper.apply(t));
        }, (a, b) -> {
            a.putAll(b);
            return a;
        }, new Collector.Characteristics[0]);
    }

    public static <T, A, B> @NonNull Collector<T, ?, Pair<List<A>, List<B>>> toListPair(Function<? super T, ? extends Optional<A>> listAValueExtractor, Function<? super T, ? extends Optional<B>> listBValueExtractor) {
        Collector<Object, Pair, Pair> collector = Collector.of(() -> new Pair(new LinkedList(), new LinkedList()), (listPair, t) -> {
            ((Optional)listAValueExtractor.apply(t)).ifPresent(((List)listPair.getFirstNonNull())::add);
            ((Optional)listBValueExtractor.apply(t)).ifPresent(((List)listPair.getSecondNonNull())::add);
        }, (leftListPair, rightListPair) -> {
            ((List)leftListPair.getFirstNonNull()).addAll((Collection)rightListPair.getFirst());
            ((List)leftListPair.getSecondNonNull()).addAll((Collection)rightListPair.getSecond());
            return leftListPair;
        }, new Collector.Characteristics[0]);
        return Conditions.requireNonNull(collector);
    }

    public static <IK, IV, OK, OV> @NonNull Collector<Map.Entry<IK, IV>, ?, Map<OK, OV>> toMap(@NonNull Supplier<Map<OK, OV>> mapSupplier, @NonNull Function<IK, OK> keyMapper, @NonNull Function<IV, OV> valueMapper) {
        Objects.requireNonNull(mapSupplier);
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        Collector<Map.Entry, Map, Map> collector = Collector.of(mapSupplier, (map, mapEntry) -> {
            Object r = map.put(keyMapper.apply(mapEntry.getKey()), valueMapper.apply(mapEntry.getValue()));
        }, (a, b) -> {
            a.putAll(b);
            return a;
        }, new Collector.Characteristics[0]);
        return Conditions.requireNonNull(collector);
    }

    public static <IK, IV, OK, OV> @NonNull Collector<Map.Entry<IK, IV>, ?, Map<OK, OV>> toMap(@NonNull Supplier<Map<OK, OV>> mapSupplier, @NonNull Function<IK, OK> keyMapper, @NonNull Function<IV, OV> valueMapper, @NonNull BiPredicate<OK, OV> outputFilter) {
        Objects.requireNonNull(mapSupplier);
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        Collector<Map.Entry, Map, Map> collector = Collector.of(mapSupplier, (map, mapEntry) -> {
            Object outputValue;
            Object outputKey = keyMapper.apply(mapEntry.getKey());
            if (outputFilter.test(outputKey, outputValue = valueMapper.apply(mapEntry.getValue()))) {
                map.put(outputKey, outputValue);
            }
        }, (a, b) -> {
            a.putAll(b);
            return a;
        }, new Collector.Characteristics[0]);
        return Conditions.requireNonNull(collector);
    }
}

