/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.rest.importing.parsers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.define.rest.api.importing.RoughArtifact;
import org.eclipse.osee.define.rest.api.importing.RoughArtifactKind;
import org.eclipse.osee.define.rest.importing.parsers.WordOutlineExtractorDelegate;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public abstract class SoftwareRequirementHandler
extends WordOutlineExtractorDelegate {
    private static final Pattern partitionPattern = Pattern.compile("\\[([\\w\\(|\\)]+)\\]");
    private final AttributeTypeToken attributeType;

    protected SoftwareRequirementHandler(AttributeTypeToken attributeType) {
        this.attributeType = attributeType;
    }

    @Override
    public void processHeadingText(RoughArtifact roughArtifact, String headingText) {
        StringBuilder text = new StringBuilder(headingText);
        Matcher matcher = partitionPattern.matcher(text);
        boolean isRequirement = false;
        while (matcher.find()) {
            isRequirement = true;
            roughArtifact.addAttribute(this.attributeType, matcher.group(1).trim());
            text.delete(matcher.start(), matcher.end());
            matcher.reset(text);
        }
        if (!isRequirement) {
            roughArtifact.setRoughArtifactKind(RoughArtifactKind.SECONDARY);
        }
        roughArtifact.setName(text.toString().trim());
    }
}

