/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.operations.synchronization.identifier;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierType;
import org.eclipse.osee.define.operations.synchronization.identifier.IdentifierTypeGroup;
import org.eclipse.osee.define.operations.synchronization.identifier.IncorrectIdentifierTypeException;

public class Identifier {
    private final String identifierText;
    private final IdentifierType identifierType;
    private final int hashCode;
    private final Long identifierCount;

    Identifier(String text, Long count, IdentifierType type) {
        this.identifierText = text;
        this.identifierType = type;
        this.identifierCount = count;
        this.hashCode = (int)((long)((type.ordinal() << 5) - type.ordinal() << 24) ^ count * count - count);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Identifier && this.identifierCount == ((Identifier)obj).identifierCount && this.identifierType == ((Identifier)obj).identifierType;
    }

    public long getCount() {
        return this.identifierCount;
    }

    String getText() {
        return this.identifierText;
    }

    public IdentifierType getType() {
        return this.identifierType;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isInGroup(IdentifierTypeGroup identifierTypeGroup) {
        return this.identifierType.isInGroup(identifierTypeGroup);
    }

    public boolean isInGroupAllOf(IdentifierTypeGroup ... identifierTypeGroups) {
        return this.identifierType.isInGroupAllOf(identifierTypeGroups);
    }

    public boolean isInGroupAnyOf(IdentifierTypeGroup ... identifierTypeGroups) {
        return this.identifierType.isInGroupAnyOf(identifierTypeGroups);
    }

    public List<IdentifierTypeGroup> notInGroups(IdentifierTypeGroup ... identifierTypeGroups) {
        return this.identifierType.notInGroups(identifierTypeGroups);
    }

    public boolean isType(IdentifierType identifierType) {
        return this.identifierType.equals(identifierType);
    }

    public Identifier requireInGroup(IdentifierTypeGroup ... identifierTypeGroups) {
        IdentifierTypeGroup[] identifierTypeGroupArray = identifierTypeGroups;
        int n = identifierTypeGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IdentifierTypeGroup identifierTypeGroup = identifierTypeGroupArray[n2];
            if (!this.identifierType.isInGroup(identifierTypeGroup)) {
                throw new IncorrectIdentifierTypeException(this, identifierTypeGroup, new IdentifierTypeGroup[0]);
            }
            ++n2;
        }
        return this;
    }

    public Identifier requireInGroup(String message, IdentifierTypeGroup ... identifierTypeGroups) {
        IdentifierTypeGroup[] identifierTypeGroupArray = identifierTypeGroups;
        int n = identifierTypeGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IdentifierTypeGroup identifierTypeGroup = identifierTypeGroupArray[n2];
            if (!this.identifierType.isInGroup(identifierTypeGroup)) {
                throw new IncorrectIdentifierTypeException(this, message, identifierTypeGroup, identifierTypeGroups);
            }
            ++n2;
        }
        return this;
    }

    public Identifier requireInGroup(Supplier<CharSequence> messageSupplier, IdentifierTypeGroup ... identifierTypeGroups) {
        IdentifierTypeGroup[] identifierTypeGroupArray = identifierTypeGroups;
        int n = identifierTypeGroups.length;
        int n2 = 0;
        while (n2 < n) {
            IdentifierTypeGroup identifierTypeGroup = identifierTypeGroupArray[n2];
            if (!this.identifierType.isInGroup(identifierTypeGroup)) {
                throw new IncorrectIdentifierTypeException(this, Objects.nonNull(messageSupplier) ? messageSupplier.get().toString() : null, identifierTypeGroup, identifierTypeGroups);
            }
            ++n2;
        }
        return this;
    }

    public Identifier requireType(IdentifierType identifierType) {
        if (!this.identifierType.equals(identifierType)) {
            throw new IncorrectIdentifierTypeException(this, identifierType);
        }
        return this;
    }

    public Identifier requireType(IdentifierType identifierType, String message) {
        if (!this.identifierType.equals(identifierType)) {
            throw new IncorrectIdentifierTypeException(this, identifierType, message);
        }
        return this;
    }

    public Identifier requireType(IdentifierType identifierType, Supplier<CharSequence> messageSupplier) {
        if (!this.identifierType.equals(identifierType)) {
            throw new IncorrectIdentifierTypeException(this, identifierType, Objects.nonNull(messageSupplier) ? messageSupplier.get().toString() : null);
        }
        return this;
    }

    public String toString() {
        return this.identifierText;
    }
}

